/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code.amd64;

import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.graal.code.CGlobalDataReference;
import com.oracle.svm.core.meta.SubstrateMethodPointerConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.HostedPatcher;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.DataSectionReference;
import jdk.vm.ci.code.site.Reference;
import org.graalvm.compiler.asm.amd64.AMD64BaseAssembler;
import org.graalvm.compiler.code.CompilationResult;

class AMD64HostedPatcher
extends CompilationResult.CodeAnnotation
implements HostedPatcher {
    private final AMD64BaseAssembler.OperandDataAnnotation annotation;

    AMD64HostedPatcher(AMD64BaseAssembler.OperandDataAnnotation annotation) {
        super(annotation.instructionPosition);
        this.annotation = annotation;
    }

    @Override
    @Uninterruptible(reason=".")
    public void patch(int compStart, int relative, byte[] code) {
        int curValue = relative - (this.annotation.nextInstructionPosition - this.annotation.instructionPosition);
        for (int i = 0; i < this.annotation.operandSize; ++i) {
            assert (code[this.annotation.operandPosition + i] == 0);
            code[this.annotation.operandPosition + i] = (byte)(curValue & 0xFF);
            curValue >>>= 8;
        }
        assert (curValue == 0);
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    @Override
    public void relocate(Reference ref, RelocatableBuffer relocs, int compStart) {
        long siteOffset = compStart + this.annotation.operandPosition;
        if (ref instanceof DataSectionReference || ref instanceof CGlobalDataReference) {
            long addend = this.annotation.nextInstructionPosition - this.annotation.operandPosition;
            relocs.addRelocationWithAddend((int)siteOffset, ObjectFile.RelocationKind.getPCRelative((int)this.annotation.operandSize), addend, ref);
        } else if (ref instanceof ConstantReference) {
            ConstantReference constantRef = (ConstantReference)ref;
            VMError.guarantee(!(constantRef.getConstant() instanceof SubstrateMethodPointerConstant), "SubstrateMethodPointerConstants should not be relocated %s", constantRef);
            relocs.addRelocationWithoutAddend((int)siteOffset, ObjectFile.RelocationKind.getDirect((int)this.annotation.operandSize), ref);
        } else {
            throw VMError.shouldNotReachHere("Unknown type of reference in code");
        }
    }
}

