/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.info;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.c.info.AccessorInfo;
import com.oracle.svm.hosted.c.info.ConstantInfo;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.EnumConstantInfo;
import com.oracle.svm.hosted.c.info.EnumInfo;
import com.oracle.svm.hosted.c.info.EnumLookupInfo;
import com.oracle.svm.hosted.c.info.EnumValueInfo;
import com.oracle.svm.hosted.c.info.NativeCodeInfo;
import com.oracle.svm.hosted.c.info.PointerToInfo;
import com.oracle.svm.hosted.c.info.PropertyInfo;
import com.oracle.svm.hosted.c.info.RawPointerToInfo;
import com.oracle.svm.hosted.c.info.RawStructureInfo;
import com.oracle.svm.hosted.c.info.StructBitfieldInfo;
import com.oracle.svm.hosted.c.info.StructFieldInfo;
import com.oracle.svm.hosted.c.info.StructInfo;
import java.util.Comparator;
import java.util.List;

public abstract class InfoTreeVisitor {
    static final Comparator<ElementInfo> elementInfoComparator;

    private static String asString(Object annotatedElement) {
        if (annotatedElement instanceof AnalysisMethod) {
            return ((AnalysisMethod)annotatedElement).getQualifiedName();
        }
        if (annotatedElement instanceof AnalysisType) {
            return ((AnalysisType)annotatedElement).getName();
        }
        return annotatedElement.toString();
    }

    protected final void processChildren(ElementInfo info) {
        List<ElementInfo> children = info.getChildren();
        children.sort(elementInfoComparator);
        for (ElementInfo child : children) {
            try {
                child.accept(this);
            }
            catch (NumberFormatException e) {
                throw UserError.abort("Missing CAP cache value for: %s", child.getUniqueID());
            }
        }
    }

    protected void visitNativeCodeInfo(NativeCodeInfo info) {
        this.processChildren(info);
    }

    protected void visitStructInfo(StructInfo info) {
        this.processChildren(info);
    }

    protected void visitRawStructureInfo(RawStructureInfo info) {
        this.processChildren(info);
    }

    protected void visitStructFieldInfo(StructFieldInfo info) {
        this.processChildren(info);
    }

    protected void visitStructBitfieldInfo(StructBitfieldInfo info) {
        this.processChildren(info);
    }

    protected void visitConstantInfo(ConstantInfo info) {
        this.processChildren(info);
    }

    protected void visitPointerToInfo(PointerToInfo info) {
        this.processChildren(info);
    }

    protected void visitRawPointerToInfo(RawPointerToInfo info) {
        this.processChildren(info);
    }

    protected void visitAccessorInfo(AccessorInfo info) {
        this.processChildren(info);
    }

    protected void visitElementPropertyInfo(PropertyInfo<?> info) {
        this.processChildren(info);
    }

    protected void visitEnumInfo(EnumInfo info) {
        this.processChildren(info);
    }

    protected void visitEnumConstantInfo(EnumConstantInfo info) {
        this.processChildren(info);
    }

    protected void visitEnumValueInfo(EnumValueInfo info) {
        this.processChildren(info);
    }

    protected void visitEnumLookupInfo(EnumLookupInfo info) {
        this.processChildren(info);
    }

    static {
        Comparator<ElementInfo> classNameComparator = Comparator.comparing(e -> e.getClass().getName());
        Comparator<ElementInfo> nameComparator = classNameComparator.thenComparing(e -> e.getName());
        elementInfoComparator = nameComparator.thenComparing(e -> InfoTreeVisitor.asString(e.getAnnotatedElement()));
    }
}

