/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.DefaultUnsafePartition;
import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.LinkerInvocation;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.SharedField;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ConcurrentReachabilityHandler;
import com.oracle.svm.hosted.FeatureHandler;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.ReachabilityHandler;
import com.oracle.svm.hosted.ReachabilityHandlerFeature;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.analysis.Inflation;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.image.AbstractImage;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.option.HostedOptionProvider;
import com.oracle.svm.util.ReflectionUtil;
import com.oracle.svm.util.UnsafePartitionKind;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

public class FeatureImpl {

    public static class AfterImageWriteAccessImpl
    extends FeatureAccessImpl
    implements Feature.AfterImageWriteAccess {
        private final HostedUniverse hUniverse;
        protected final LinkerInvocation linkerInvocation;
        protected final Path tempDirectory;
        protected final AbstractImage.NativeImageKind imageKind;

        AfterImageWriteAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, HostedUniverse hUniverse, LinkerInvocation linkerInvocation, Path tempDirectory, AbstractImage.NativeImageKind imageKind, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, debugContext);
            this.hUniverse = hUniverse;
            this.linkerInvocation = linkerInvocation;
            this.tempDirectory = tempDirectory;
            this.imageKind = imageKind;
        }

        public HostedUniverse getUniverse() {
            return this.hUniverse;
        }

        public Path getImagePath() {
            if (this.linkerInvocation == null) {
                return null;
            }
            return this.linkerInvocation.getOutputFile();
        }

        public Path getTempDirectory() {
            return this.tempDirectory;
        }

        public AbstractImage.NativeImageKind getImageKind() {
            return this.imageKind;
        }

        public List<String> getImageSymbols(boolean onlyGlobal) {
            return this.linkerInvocation.getImageSymbols(onlyGlobal);
        }
    }

    public static class BeforeImageWriteAccessImpl
    extends FeatureAccessImpl
    implements Feature.BeforeImageWriteAccess {
        private List<Function<LinkerInvocation, LinkerInvocation>> linkerInvocationTransformers = null;
        protected final String imageName;
        protected final AbstractImage image;
        protected final RuntimeConfiguration runtimeConfig;
        protected final AnalysisUniverse aUniverse;
        protected final HostedUniverse hUniverse;
        protected final HostedOptionProvider optionProvider;
        protected final HostedMetaAccess hMetaAccess;

        BeforeImageWriteAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, String imageName, AbstractImage image, RuntimeConfiguration runtimeConfig, AnalysisUniverse aUniverse, HostedUniverse hUniverse, HostedOptionProvider optionProvider, HostedMetaAccess hMetaAccess, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, debugContext);
            this.imageName = imageName;
            this.image = image;
            this.runtimeConfig = runtimeConfig;
            this.aUniverse = aUniverse;
            this.hUniverse = hUniverse;
            this.optionProvider = optionProvider;
            this.hMetaAccess = hMetaAccess;
        }

        public String getImageName() {
            return this.imageName;
        }

        public AbstractImage getImage() {
            return this.image;
        }

        public RuntimeConfiguration getRuntimeConfiguration() {
            return this.runtimeConfig;
        }

        public HostedUniverse getHostedUniverse() {
            return this.hUniverse;
        }

        public HostedMetaAccess getHostedMetaAccess() {
            return this.hMetaAccess;
        }

        public Iterable<Function<LinkerInvocation, LinkerInvocation>> getLinkerInvocationTransformers() {
            if (this.linkerInvocationTransformers == null) {
                return Collections.emptyList();
            }
            return this.linkerInvocationTransformers;
        }

        public void registerLinkerInvocationTransformer(Function<LinkerInvocation, LinkerInvocation> transformer) {
            if (this.linkerInvocationTransformers == null) {
                this.linkerInvocationTransformers = new ArrayList<Function<LinkerInvocation, LinkerInvocation>>();
            }
            this.linkerInvocationTransformers.add(transformer);
        }
    }

    public static class AfterHeapLayoutAccessImpl
    extends FeatureAccessImpl
    implements Feature.AfterHeapLayoutAccess {
        protected final HostedMetaAccess hMetaAccess;
        protected final NativeImageHeap heap;

        public AfterHeapLayoutAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, NativeImageHeap heap, HostedMetaAccess hMetaAccess, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, debugContext);
            this.heap = heap;
            this.hMetaAccess = hMetaAccess;
        }

        public HostedMetaAccess getMetaAccess() {
            return this.hMetaAccess;
        }

        public NativeImageHeap getHeap() {
            return this.heap;
        }
    }

    public static class AfterCompilationAccessImpl
    extends CompilationAccessImpl
    implements Feature.AfterCompilationAccess {
        private final Map<HostedMethod, CompileQueue.CompileTask> compilations;
        private final NativeImageCodeCache codeCache;

        public AfterCompilationAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, AnalysisUniverse aUniverse, HostedUniverse hUniverse, Map<HostedMethod, CompileQueue.CompileTask> compilations, NativeImageCodeCache codeCache, NativeImageHeap heap, DebugContext debugContext, RuntimeConfiguration runtimeConfiguration, NativeLibraries nativeLibraries) {
            super(featureHandler, imageClassLoader, aUniverse, hUniverse, heap, debugContext, runtimeConfiguration, nativeLibraries);
            this.compilations = compilations;
            this.codeCache = codeCache;
        }

        public Collection<CompileQueue.CompileTask> getCompilationTasks() {
            return this.compilations.values();
        }

        public Map<HostedMethod, CompileQueue.CompileTask> getCompilations() {
            return this.compilations;
        }

        public NativeImageCodeCache getCodeCache() {
            return this.codeCache;
        }
    }

    public static class BeforeCompilationAccessImpl
    extends CompilationAccessImpl
    implements Feature.BeforeCompilationAccess {
        public BeforeCompilationAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, AnalysisUniverse aUniverse, HostedUniverse hUniverse, NativeImageHeap heap, DebugContext debugContext, RuntimeConfiguration runtimeConfiguration, NativeLibraries nativeLibraries) {
            super(featureHandler, imageClassLoader, aUniverse, hUniverse, heap, debugContext, runtimeConfiguration, nativeLibraries);
        }

        public RuntimeConfiguration getRuntimeConfiguration() {
            return this.runtimeConfiguration;
        }
    }

    public static class CompilationAccessImpl
    extends FeatureAccessImpl
    implements Feature.CompilationAccess {
        protected final AnalysisUniverse aUniverse;
        protected final HostedUniverse hUniverse;
        protected final NativeImageHeap heap;
        protected final RuntimeConfiguration runtimeConfiguration;
        protected final NativeLibraries nativeLibraries;

        CompilationAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, AnalysisUniverse aUniverse, HostedUniverse hUniverse, NativeImageHeap heap, DebugContext debugContext, RuntimeConfiguration runtimeConfiguration, NativeLibraries nativeLibraries) {
            super(featureHandler, imageClassLoader, debugContext);
            this.aUniverse = aUniverse;
            this.hUniverse = hUniverse;
            this.heap = heap;
            this.runtimeConfiguration = runtimeConfiguration;
            this.nativeLibraries = nativeLibraries;
        }

        public NativeLibraries getNativeLibraries() {
            return this.nativeLibraries;
        }

        public long objectFieldOffset(Field field) {
            return this.objectFieldOffset(this.getMetaAccess().lookupJavaField(field));
        }

        public long objectFieldOffset(HostedField hField) {
            int result = hField.getLocation();
            assert (result > 0);
            return result;
        }

        public void registerAsImmutable(Object object) {
            this.heap.registerAsImmutable(object);
        }

        public void registerAsImmutable(Object root, Predicate<Object> includeObject) {
            ArrayDeque<Object> worklist = new ArrayDeque<Object>();
            IdentityHashMap<Object, Boolean> registeredObjects = new IdentityHashMap<Object, Boolean>();
            worklist.push(root);
            while (!worklist.isEmpty()) {
                Object cur = worklist.pop();
                this.registerAsImmutable(cur);
                if (!this.getMetaAccess().optionalLookupJavaType(cur.getClass()).isPresent()) continue;
                if (cur instanceof Object[]) {
                    for (Object element : (Object[])cur) {
                        CompilationAccessImpl.addToWorklist(this.aUniverse.replaceObject(element), includeObject, worklist, registeredObjects);
                    }
                    continue;
                }
                JavaConstant constant = this.aUniverse.getSnippetReflection().forObject(cur);
                for (HostedField field : this.getMetaAccess().lookupJavaType(constant).getInstanceFields(true)) {
                    if (!field.isAccessed() || field.getStorageKind() != JavaKind.Object) continue;
                    Object fieldValue = this.aUniverse.getSnippetReflection().asObject(Object.class, this.heap.hConstantReflection.readFieldValue(field, constant));
                    CompilationAccessImpl.addToWorklist(fieldValue, includeObject, worklist, registeredObjects);
                }
            }
        }

        private static void addToWorklist(Object object, Predicate<Object> includeObject, Deque<Object> worklist, IdentityHashMap<Object, Boolean> registeredObjects) {
            if (object == null || registeredObjects.containsKey(object)) {
                return;
            }
            if (object instanceof DynamicHub || object instanceof Class) {
                return;
            }
            if (!includeObject.test(object)) {
                return;
            }
            registeredObjects.put(object, Boolean.TRUE);
            worklist.push(object);
        }

        public HostedMetaAccess getMetaAccess() {
            return (HostedMetaAccess)this.getProviders().getMetaAccess();
        }

        public Providers getProviders() {
            return this.runtimeConfiguration.getProviders();
        }

        public HostedUniverse getUniverse() {
            return this.hUniverse;
        }

        public Collection<? extends SharedType> getTypes() {
            return this.hUniverse.getTypes();
        }

        public Collection<? extends SharedField> getFields() {
            return this.hUniverse.getFields();
        }

        public Collection<? extends SharedMethod> getMethods() {
            return this.hUniverse.getMethods();
        }
    }

    public static class BeforeUniverseBuildingAccessImpl
    extends FeatureAccessImpl
    implements Feature.BeforeUniverseBuildingAccess {
        protected final HostedMetaAccess hMetaAccess;

        BeforeUniverseBuildingAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, DebugContext debugContext, HostedMetaAccess hMetaAccess) {
            super(featureHandler, imageClassLoader, debugContext);
            this.hMetaAccess = hMetaAccess;
        }

        public HostedMetaAccess getMetaAccess() {
            return this.hMetaAccess;
        }
    }

    public static class OnAnalysisExitAccessImpl
    extends AnalysisAccessBase
    implements Feature.OnAnalysisExitAccess {
        public OnAnalysisExitAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, Inflation bb, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, bb, debugContext);
        }
    }

    public static class AfterAnalysisAccessImpl
    extends AnalysisAccessBase
    implements Feature.AfterAnalysisAccess {
        public AfterAnalysisAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, Inflation bb, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, bb, debugContext);
        }
    }

    public static class ConcurrentAnalysisAccessImpl
    extends DuringAnalysisAccessImpl {
        private static final String concurrentReachabilityOption = SubstrateOptionsParser.commandArgument(SubstrateOptions.RunReachabilityHandlersConcurrently, "-");

        public ConcurrentAnalysisAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, Inflation bb, NativeLibraries nativeLibraries, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, bb, nativeLibraries, debugContext);
        }

        @Override
        public void requireAnalysisIteration() {
            if (this.bb.executorIsStarted()) {
                String msg = "Calling DuringAnalysisAccessImpl.requireAnalysisIteration() is not necessary when running the reachability handlers concurrently during analysis. To fallback to running the reachability handlers sequentially, i.e., from Feature.duringAnalysis(), you can add the " + concurrentReachabilityOption + " option to the native-image command. Note that the fallback option is deprecated and it will be removed in a future release.";
                throw VMError.shouldNotReachHere(msg);
            }
            super.requireAnalysisIteration();
        }
    }

    public static class DuringAnalysisAccessImpl
    extends BeforeAnalysisAccessImpl
    implements Feature.DuringAnalysisAccess {
        private boolean requireAnalysisIteration;

        public DuringAnalysisAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, Inflation bb, NativeLibraries nativeLibraries, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, bb, nativeLibraries, debugContext);
        }

        public void requireAnalysisIteration() {
            this.requireAnalysisIteration = true;
        }

        public boolean getAndResetRequireAnalysisIteration() {
            boolean result = this.requireAnalysisIteration;
            this.requireAnalysisIteration = false;
            return result;
        }
    }

    public static class BeforeAnalysisAccessImpl
    extends AnalysisAccessBase
    implements Feature.BeforeAnalysisAccess {
        private final NativeLibraries nativeLibraries;
        private final boolean concurrentReachabilityHandlers;
        private final ReachabilityHandler reachabilityHandler;

        public BeforeAnalysisAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, Inflation bb, NativeLibraries nativeLibraries, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, bb, debugContext);
            this.nativeLibraries = nativeLibraries;
            this.concurrentReachabilityHandlers = (Boolean)SubstrateOptions.RunReachabilityHandlersConcurrently.getValue(bb.getOptions());
            this.reachabilityHandler = this.concurrentReachabilityHandlers ? ConcurrentReachabilityHandler.singleton() : ReachabilityHandlerFeature.singleton();
        }

        public NativeLibraries getNativeLibraries() {
            return this.nativeLibraries;
        }

        public void registerAsUsed(Class<?> clazz) {
            this.registerAsUsed(this.getMetaAccess().lookupJavaType(clazz), (Object)"registered from Feature API");
        }

        public void registerAsUsed(Class<?> clazz, Object reason) {
            this.registerAsUsed(this.getMetaAccess().lookupJavaType(clazz), reason);
        }

        public void registerAsUsed(AnalysisType aType, Object reason) {
            this.bb.registerTypeAsReachable(aType, reason);
        }

        public void registerAsInHeap(Class<?> clazz) {
            this.registerAsInHeap(this.getMetaAccess().lookupJavaType(clazz), (Object)"registered from Feature API");
        }

        public void registerAsInHeap(Class<?> clazz, Object reason) {
            this.registerAsInHeap(this.getMetaAccess().lookupJavaType(clazz), reason);
        }

        public void registerAsInHeap(AnalysisType aType, Object reason) {
            this.bb.registerTypeAsInHeap(aType, reason);
        }

        public void registerAsAccessed(Field field) {
            this.registerAsAccessed(this.getMetaAccess().lookupJavaField(field), "registered from Feature API");
        }

        public void registerAsAccessed(AnalysisField aField, Object reason) {
            this.bb.markFieldAccessed(aField, reason);
        }

        public void registerAsRead(Field field, Object reason) {
            this.registerAsRead(this.getMetaAccess().lookupJavaField(field), reason);
        }

        public void registerAsRead(AnalysisField aField, Object reason) {
            this.bb.markFieldRead(aField, reason);
        }

        public void registerAsUnsafeAccessed(Field field) {
            this.registerAsUnsafeAccessed(this.getMetaAccess().lookupJavaField(field), "registered from Feature API");
        }

        public boolean registerAsUnsafeAccessed(AnalysisField aField, Object reason) {
            return this.registerAsUnsafeAccessed(aField, DefaultUnsafePartition.get(), reason);
        }

        public void registerAsUnsafeAccessed(Field field, UnsafePartitionKind partitionKind, Object reason) {
            this.registerAsUnsafeAccessed(this.getMetaAccess().lookupJavaField(field), partitionKind, reason);
        }

        public boolean registerAsUnsafeAccessed(AnalysisField aField, UnsafePartitionKind partitionKind, Object reason) {
            assert (!AnnotationAccess.isAnnotationPresent((AnnotatedElement)aField, Delete.class));
            return this.bb.registerAsUnsafeAccessed(aField, partitionKind, reason);
        }

        public void registerAsFrozenUnsafeAccessed(Field field, Object reason) {
            this.registerAsFrozenUnsafeAccessed(this.getMetaAccess().lookupJavaField(field), reason);
        }

        public void registerAsFrozenUnsafeAccessed(AnalysisField aField, Object reason) {
            this.bb.registerAsFrozenUnsafeAccessed(aField);
            this.registerAsUnsafeAccessed(aField, reason);
        }

        public void registerAsRoot(Executable method, boolean invokeSpecial, String reason, MultiMethod.MultiMethodKey ... otherRoots) {
            this.bb.addRootMethod(method, invokeSpecial, reason, otherRoots);
        }

        public void registerAsRoot(AnalysisMethod aMethod, boolean invokeSpecial, String reason, MultiMethod.MultiMethodKey ... otherRoots) {
            this.bb.addRootMethod(aMethod, invokeSpecial, reason, otherRoots);
        }

        public void registerUnsafeFieldsRecomputed(Class<?> clazz) {
            this.getMetaAccess().lookupJavaType(clazz).registerUnsafeFieldsRecomputed();
        }

        public SVMHost getHostVM() {
            return this.bb.getHostVM();
        }

        public void registerHierarchyForReflectiveInstantiation(Class<?> c) {
            this.findSubclasses(c).stream().filter(clazz -> !Modifier.isAbstract(clazz.getModifiers())).forEach(clazz -> RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{clazz}));
        }

        public void registerReachabilityHandler(Consumer<Feature.DuringAnalysisAccess> callback, Object ... elements) {
            this.reachabilityHandler.registerReachabilityHandler(this, callback, elements);
        }

        public void registerMethodOverrideReachabilityHandler(BiConsumer<Feature.DuringAnalysisAccess, Executable> callback, Executable baseMethod) {
            this.reachabilityHandler.registerMethodOverrideReachabilityHandler(this, callback, baseMethod);
        }

        public void registerSubtypeReachabilityHandler(BiConsumer<Feature.DuringAnalysisAccess, Class<?>> callback, Class<?> baseClass) {
            this.reachabilityHandler.registerSubtypeReachabilityHandler(this, callback, baseClass);
        }

        public void registerClassInitializerReachabilityHandler(Consumer<Feature.DuringAnalysisAccess> callback, Class<?> clazz) {
            this.reachabilityHandler.registerClassInitializerReachabilityHandler(this, callback, clazz);
        }

        public boolean concurrentReachabilityHandlers() {
            return this.concurrentReachabilityHandlers;
        }

        public void registerFieldValueTransformer(Field field, FieldValueTransformer transformer) {
            this.bb.getAnnotationSubstitutionProcessor().registerFieldValueTransformer(field, transformer);
        }

        public void registerOpaqueMethodReturn(Method method) {
            AnalysisMethod aMethod = this.bb.getMetaAccess().lookupJavaMethod((Executable)method);
            VMError.guarantee(aMethod.getAllMultiMethods().size() == 1, "Opaque method return called for method with >1 multimethods: %s ", method);
            VMError.guarantee(method.getReturnType().equals(Object.class), "Called registerOpaqueMethodReturn for a method with a non-Object return type: %s", method);
            aMethod.setReturnsAllInstantiatedTypes();
        }
    }

    public static class DuringSetupAccessImpl
    extends AnalysisAccessBase
    implements Feature.DuringSetupAccess {
        public DuringSetupAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, Inflation bb, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, bb, debugContext);
        }

        public void registerObjectReplacer(Function<Object, Object> replacer) {
            this.getUniverse().registerObjectReplacer(replacer);
        }

        public void registerSubstitutionProcessor(SubstitutionProcessor substitution) {
            this.getUniverse().registerFeatureSubstitution(substitution);
        }

        public void registerNativeSubstitutionProcessor(SubstitutionProcessor substitution) {
            this.getUniverse().registerFeatureNativeSubstitution(substitution);
        }

        public void registerClassReachabilityListener(BiConsumer<Feature.DuringAnalysisAccess, Class<?>> listener) {
            this.getHostVM().registerClassReachabilityListener(listener);
        }

        public SVMHost getHostVM() {
            return this.bb.getHostVM();
        }
    }

    static abstract class AnalysisAccessBase
    extends FeatureAccessImpl {
        protected final Inflation bb;

        AnalysisAccessBase(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, Inflation bb, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, debugContext);
            this.bb = bb;
        }

        public BigBang getBigBang() {
            return this.bb;
        }

        public AnalysisUniverse getUniverse() {
            return this.bb.getUniverse();
        }

        public AnalysisMetaAccess getMetaAccess() {
            return this.bb.getMetaAccess();
        }

        public boolean isReachable(Class<?> clazz) {
            return this.isReachable(this.getMetaAccess().lookupJavaType(clazz));
        }

        public boolean isReachable(AnalysisType type) {
            return type.isReachable();
        }

        public boolean isReachable(Field field) {
            return this.isReachable(this.getMetaAccess().lookupJavaField(field));
        }

        public boolean isReachable(AnalysisField field) {
            return field.isAccessed();
        }

        public boolean isReachable(Executable method) {
            return this.isReachable(this.getMetaAccess().lookupJavaMethod(method));
        }

        public boolean isReachable(AnalysisMethod method) {
            return method.isReachable();
        }

        public Set<Class<?>> reachableSubtypes(Class<?> baseClass) {
            return this.reachableSubtypes(this.getMetaAccess().lookupJavaType(baseClass)).stream().map(AnalysisType::getJavaClass).collect(Collectors.toCollection(HashSet::new));
        }

        Set<AnalysisType> reachableSubtypes(AnalysisType baseType) {
            return AnalysisUniverse.reachableSubtypes((AnalysisType)baseType);
        }

        public Set<Executable> reachableMethodOverrides(Executable baseMethod) {
            return this.reachableMethodOverrides(this.getMetaAccess().lookupJavaMethod(baseMethod)).stream().map(AnalysisMethod::getJavaMethod).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        }

        Set<AnalysisMethod> reachableMethodOverrides(AnalysisMethod baseMethod) {
            return AnalysisUniverse.reachableMethodOverrides((AnalysisMethod)baseMethod);
        }

        public void rescanObject(Object obj) {
            this.getUniverse().getHeapScanner().rescanObject(obj);
        }

        public void rescanField(Object receiver, Field field) {
            this.getUniverse().getHeapScanner().rescanField(receiver, field);
        }

        public void rescanRoot(Field field) {
            this.getUniverse().getHeapScanner().rescanRoot(field);
        }

        public Field findField(String declaringClassName, String fieldName) {
            return this.findField(this.imageClassLoader.findClassOrFail(declaringClassName), fieldName);
        }

        public Field findField(Class<?> declaringClass, String fieldName) {
            return ReflectionUtil.lookupField(declaringClass, (String)fieldName);
        }

        public void ensureInitialized(String className) {
            try {
                this.imageClassLoader.forName(className, true);
            }
            catch (ClassNotFoundException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }
    }

    public static class AfterRegistrationAccessImpl
    extends FeatureAccessImpl
    implements Feature.AfterRegistrationAccess {
        private final MetaAccessProvider metaAccess;
        private Pair<Method, CEntryPointData> mainEntryPoint;

        public AfterRegistrationAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, MetaAccessProvider metaAccess, Pair<Method, CEntryPointData> mainEntryPoint, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, debugContext);
            this.metaAccess = metaAccess;
            this.mainEntryPoint = mainEntryPoint;
        }

        public MetaAccessProvider getMetaAccess() {
            return this.metaAccess;
        }

        public void setMainEntryPoint(Pair<Method, CEntryPointData> mainEntryPoint) {
            this.mainEntryPoint = mainEntryPoint;
        }

        public Pair<Method, CEntryPointData> getMainEntryPoint() {
            return this.mainEntryPoint;
        }
    }

    public static class IsInConfigurationAccessImpl
    extends FeatureAccessImpl
    implements Feature.IsInConfigurationAccess {
        IsInConfigurationAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, DebugContext debugContext) {
            super(featureHandler, imageClassLoader, debugContext);
        }
    }

    public static abstract class FeatureAccessImpl
    implements Feature.FeatureAccess {
        protected final FeatureHandler featureHandler;
        protected final ImageClassLoader imageClassLoader;
        protected final DebugContext debugContext;

        FeatureAccessImpl(FeatureHandler featureHandler, ImageClassLoader imageClassLoader, DebugContext debugContext) {
            this.featureHandler = featureHandler;
            this.imageClassLoader = imageClassLoader;
            this.debugContext = debugContext;
        }

        public ImageClassLoader getImageClassLoader() {
            return this.imageClassLoader;
        }

        public Class<?> findClassByName(String className) {
            return this.imageClassLoader.findClass(className).get();
        }

        public <T> List<Class<? extends T>> findSubclasses(Class<T> baseClass) {
            return this.imageClassLoader.findSubclasses(baseClass, false);
        }

        public List<Class<?>> findAnnotatedClasses(Class<? extends Annotation> annotationClass) {
            return this.imageClassLoader.findAnnotatedClasses(annotationClass, false);
        }

        public List<Method> findAnnotatedMethods(Class<? extends Annotation> annotationClass) {
            return this.imageClassLoader.findAnnotatedMethods(annotationClass);
        }

        public List<Field> findAnnotatedFields(Class<? extends Annotation> annotationClass) {
            return this.imageClassLoader.findAnnotatedFields(annotationClass);
        }

        public FeatureHandler getFeatureHandler() {
            return this.featureHandler;
        }

        public DebugContext getDebugContext() {
            return this.debugContext;
        }

        public List<Path> getApplicationClassPath() {
            return this.imageClassLoader.applicationClassPath();
        }

        public List<Path> getApplicationModulePath() {
            return this.imageClassLoader.applicationModulePath();
        }

        public ClassLoader getApplicationClassLoader() {
            return this.imageClassLoader.getClassLoader();
        }
    }
}

