/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.isolated;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.handles.ThreadLocalHandles;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.ClientIsolateThread;
import com.oracle.svm.graal.isolated.CompilerHandle;
import com.oracle.svm.graal.isolated.IsolatedCompilationExceptionDispatch;
import com.oracle.svm.graal.isolated.IsolatedCompileClient;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.ObjectHandle;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class IsolatedCompileContext
extends IsolatedCompilationExceptionDispatch {
    private static final FastThreadLocalObject<IsolatedCompileContext> currentContext = FastThreadLocalFactory.createObject(IsolatedCompileContext.class, "IsolatedCompileContext.currentContext");
    private final ClientIsolateThread client;
    private final ThreadLocalHandles<ObjectHandle> handles = new ThreadLocalHandles(64);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static IsolatedCompileContext get() {
        return currentContext.get();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void set(IsolatedCompileContext context) {
        assert (context == null != (currentContext.get() == null));
        currentContext.set(context);
    }

    public IsolatedCompileContext(ClientIsolateThread clientIsolate) {
        this.client = clientIsolate;
    }

    public ClientIsolateThread getClient() {
        return this.client;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected IsolateThread getOtherIsolate() {
        return this.client;
    }

    public <T> CompilerHandle<T> hand(T object) {
        return (CompilerHandle)this.handles.create(object);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T> T unhand(CompilerHandle<? extends T> handle) {
        return (T)this.handles.getObject(handle);
    }

    public ClientHandle<String> createStringInClient(CharSequence s) {
        try (CTypeConversion.CCharPointerHolder cstr = CTypeConversion.toCString((CharSequence)s);){
            ClientHandle<String> clientHandle = IsolatedCompileContext.createStringInClient0(this.client, cstr.get());
            return clientHandle;
        }
    }

    public ClientHandle<String[]> createStringArrayInClient(String[] array) {
        try (CTypeConversion.CCharPointerPointerHolder cstrs = CTypeConversion.toCStrings((CharSequence[])array);){
            ClientHandle<String[]> clientHandle = IsolatedCompileContext.createStringArrayInClient0(this.client, array.length, cstrs.get());
            return clientHandle;
        }
    }

    @CEntryPoint(exceptionHandler=IsolatedCompileClient.WordExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(callerEpilogue=IsolatedCompileClient.ExceptionRethrowCallerEpilogue.class)
    private static ClientHandle<String> createStringInClient0(ClientIsolateThread client, CCharPointer cstr) {
        return IsolatedCompileClient.get().hand(CTypeConversion.toJavaString((CCharPointer)cstr));
    }

    @CEntryPoint(exceptionHandler=IsolatedCompileClient.WordExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(callerEpilogue=IsolatedCompileClient.ExceptionRethrowCallerEpilogue.class)
    private static ClientHandle<String[]> createStringArrayInClient0(ClientIsolateThread client, int length, CCharPointerPointer ptrs) {
        String[] array = new String[length];
        for (int i = 0; i < length; ++i) {
            array[i] = CTypeConversion.toJavaString((CCharPointer)ptrs.read(i));
        }
        return IsolatedCompileClient.get().hand(array);
    }

    public static final class ExitCompilationEpilogue
    implements CEntryPointOptions.Epilogue {
        private static final CGlobalData<CCharPointer> errorMessage = CGlobalDataFactory.createCString("Failed to leave the current isolated compilation IsolateThread context.");

        @Uninterruptible(reason="Epilogue")
        static void epilogue() {
            IsolatedCompileContext.set(null);
            int code = CEntryPointActions.leave();
            if (code != 0) {
                CEntryPointActions.failFatally(code, errorMessage.get());
            }
        }
    }

    public static final class ResetContextWordExceptionHandler
    implements CEntryPoint.ExceptionHandler {
        @Uninterruptible(reason="Exception handler")
        static WordBase handle(Throwable t) {
            int v = IsolatedCompileContext.get().handleException(t);
            return WordFactory.signed((int)v);
        }
    }

    public static final class WordExceptionHandler
    implements CEntryPoint.ExceptionHandler {
        @Uninterruptible(reason="Exception handler")
        static WordBase handle(Throwable t) {
            return WordFactory.signed((int)IsolatedCompileContext.get().handleException(t));
        }
    }

    public static final class VoidExceptionHandler
    implements CEntryPoint.ExceptionHandler {
        @Uninterruptible(reason="Exception handler")
        static void handle(Throwable t) {
            IsolatedCompileContext.get().handleException(t);
        }
    }

    public static final class ExceptionRethrowCallerEpilogue
    implements CEntryPointOptions.CallerEpilogue {
        static void callerEpilogue() {
            IsolatedCompileContext.throwPendingException();
        }
    }
}

