/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.isolated;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import org.graalvm.compiler.core.common.GraalBailoutException;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;

public abstract class IsolatedCompilationExceptionDispatch {
    private static final RuntimeException EXCEPTION_WITHOUT_MESSAGE = new GraalBailoutException("[no details because exception allocation failed]", new Object[0]);
    private static final FastThreadLocalObject<RuntimeException> pendingException = FastThreadLocalFactory.createObject(RuntimeException.class, "IsolatedCompilationExceptionDispatch.pendingException");

    protected static void throwPendingException() {
        RuntimeException pending = pendingException.get();
        if (pending != null) {
            pendingException.set(null);
            throw pending;
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract IsolateThread getOtherIsolate();

    @Uninterruptible(reason="Called in exception handler.", calleeMustBe=false)
    protected final int handleException(Throwable t) {
        boolean done;
        try {
            done = this.dispatchExceptionToOtherIsolate(t);
        }
        catch (Throwable another) {
            done = false;
        }
        if (!done) {
            IsolatedCompilationExceptionDispatch.dispatchExceptionWithoutMessage(this.getOtherIsolate());
        }
        return 0;
    }

    @NeverInline(value="Ensure that an exception thrown from this method can always be caught.")
    private boolean dispatchExceptionToOtherIsolate(Throwable t) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (PrintWriter pw = new PrintWriter(os);){
            pw.print("{ ");
            t.printStackTrace(pw);
            pw.print("}");
        }
        try (CTypeConversion.CCharPointerHolder cstr = CTypeConversion.toCString((CharSequence)os.toString());){
            boolean bl = IsolatedCompilationExceptionDispatch.dispatchException(this.getOtherIsolate(), cstr.get());
            return bl;
        }
    }

    @CEntryPoint(exceptionHandler=ReturnFalseExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static boolean dispatchException(IsolateThread other, CCharPointer cstr) {
        String message = CTypeConversion.toJavaString((CCharPointer)cstr);
        GraalBailoutException exception = new GraalBailoutException(message, new Object[0]);
        pendingException.set((RuntimeException)exception);
        return true;
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @Uninterruptible(reason="Called from exception handler, should not raise an exception.")
    private static void dispatchExceptionWithoutMessage(IsolateThread other) {
        pendingException.set(EXCEPTION_WITHOUT_MESSAGE);
    }

    private static final class ReturnFalseExceptionHandler
    implements CEntryPoint.ExceptionHandler {
        private ReturnFalseExceptionHandler() {
        }

        @Uninterruptible(reason="Exception handler")
        static boolean handle(Throwable t) {
            return false;
        }
    }
}

