/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.isolated;

import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.meta.DirectSubstrateObjectConstant;
import com.oracle.svm.core.meta.ObjectConstantEquality;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.ClientIsolateThread;
import com.oracle.svm.graal.isolated.ImageHeapObjects;
import com.oracle.svm.graal.isolated.ImageHeapRef;
import com.oracle.svm.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.graal.isolated.IsolatedCompileContext;
import com.oracle.svm.graal.isolated.IsolatedObjectConstant;
import jdk.vm.ci.meta.Constant;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.word.ComparableWord;

final class IsolateAwareObjectConstantEquality
implements ObjectConstantEquality {
    IsolateAwareObjectConstantEquality() {
    }

    @Override
    public boolean test(SubstrateObjectConstant x, SubstrateObjectConstant y) {
        if (x == y) {
            return true;
        }
        if (x instanceof DirectSubstrateObjectConstant && y instanceof DirectSubstrateObjectConstant) {
            return ((DirectSubstrateObjectConstant)x).getObject() == ((DirectSubstrateObjectConstant)y).getObject();
        }
        if (x instanceof IsolatedObjectConstant) {
            return IsolateAwareObjectConstantEquality.compareIsolatedConstant((IsolatedObjectConstant)x, (Constant)y);
        }
        if (y instanceof IsolatedObjectConstant) {
            return IsolateAwareObjectConstantEquality.compareIsolatedConstant((IsolatedObjectConstant)y, (Constant)x);
        }
        throw VMError.shouldNotReachHere("Unknown object constants: " + String.valueOf(x) + " and " + String.valueOf(y));
    }

    private static boolean compareIsolatedConstant(IsolatedObjectConstant a, Constant b) {
        ClientHandle<?> u = a.getHandle();
        if (b instanceof IsolatedObjectConstant) {
            ClientHandle<?> v = ((IsolatedObjectConstant)b).getHandle();
            return u.equal((ComparableWord)v) || IsolateAwareObjectConstantEquality.isolatedConstantHandleTargetsEqual(IsolatedCompileContext.get().getClient(), u, v);
        }
        if (b instanceof DirectSubstrateObjectConstant) {
            ImageHeapRef<Object> v = ImageHeapObjects.ref(((DirectSubstrateObjectConstant)b).getObject());
            return IsolateAwareObjectConstantEquality.isolatedHandleTargetEqualImageObject(IsolatedCompileContext.get().getClient(), u, v);
        }
        throw VMError.shouldNotReachHere("Unknown object constant: " + String.valueOf(b));
    }

    @CEntryPoint(exceptionHandler=IsolatedCompileClient.BooleanExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(callerEpilogue=IsolatedCompileClient.ExceptionRethrowCallerEpilogue.class)
    static boolean isolatedConstantHandleTargetsEqual(ClientIsolateThread client, ClientHandle<?> x, ClientHandle<?> y) {
        return IsolatedCompileClient.get().unhand(x) == IsolatedCompileClient.get().unhand(y);
    }

    @CEntryPoint(exceptionHandler=IsolatedCompileClient.BooleanExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(callerEpilogue=IsolatedCompileClient.ExceptionRethrowCallerEpilogue.class)
    private static boolean isolatedHandleTargetEqualImageObject(ClientIsolateThread client, ClientHandle<?> x, ImageHeapRef<?> y) {
        return IsolatedCompileClient.get().unhand(x) == ImageHeapObjects.deref(y);
    }
}

