/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.locks.ClassInstanceReplacer;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMLockSupport;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.locks.VMSemaphore;
import com.oracle.svm.core.windows.WindowsVMCondition;
import com.oracle.svm.core.windows.WindowsVMLockSupport;
import com.oracle.svm.core.windows.WindowsVMMutex;
import com.oracle.svm.core.windows.WindowsVMSemaphore;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
@Platforms(value={Platform.WINDOWS.class})
final class WindowsVMLockFeature
implements InternalFeature {
    private final ClassInstanceReplacer<VMMutex, WindowsVMMutex> mutexReplacer = new ClassInstanceReplacer<VMMutex, WindowsVMMutex>(VMMutex.class){

        @Override
        protected WindowsVMMutex createReplacement(VMMutex source) {
            return new WindowsVMMutex(source.getName());
        }
    };
    private final ClassInstanceReplacer<VMCondition, WindowsVMCondition> conditionReplacer = new ClassInstanceReplacer<VMCondition, WindowsVMCondition>(VMCondition.class){

        @Override
        protected WindowsVMCondition createReplacement(VMCondition source) {
            return new WindowsVMCondition((WindowsVMMutex)WindowsVMLockFeature.this.mutexReplacer.apply(source.getMutex()));
        }
    };
    private final ClassInstanceReplacer<VMSemaphore, VMSemaphore> semaphoreReplacer = new ClassInstanceReplacer<VMSemaphore, VMSemaphore>(VMSemaphore.class){

        @Override
        protected VMSemaphore createReplacement(VMSemaphore source) {
            return new WindowsVMSemaphore(source.getName());
        }
    };

    WindowsVMLockFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return SubstrateOptions.MultiThreaded.getValue();
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        ImageSingletons.add(VMLockSupport.class, (Object)new WindowsVMLockSupport());
        access.registerObjectReplacer(this.mutexReplacer);
        access.registerObjectReplacer(this.conditionReplacer);
        access.registerObjectReplacer(this.semaphoreReplacer);
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        WindowsVMMutex[] mutexes = this.mutexReplacer.getReplacements().toArray(new WindowsVMMutex[0]);
        WindowsVMCondition[] conditions = this.conditionReplacer.getReplacements().toArray(new WindowsVMCondition[0]);
        WindowsVMLockSupport lockSupport = WindowsVMLockSupport.singleton();
        lockSupport.mutexes = mutexes;
        lockSupport.conditions = conditions;
        lockSupport.semaphores = this.semaphoreReplacer.getReplacements().toArray(new WindowsVMSemaphore[0]);
    }
}

