/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.heap.StoredContinuationAccess;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.jdk.InternalVMMethod;
import com.oracle.svm.core.snippets.ImplicitExceptions;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.ContinuationSupport;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.LoomSupport;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@InternalVMMethod
public final class Continuation {
    public static final int YIELDING = -2;
    public static final int FREEZE_OK = 0;
    private final Runnable target;
    public StoredContinuation stored;
    private Pointer sp;
    private CodePointer ip;
    private Pointer baseSP;
    private int overflowCheckState;

    @Fold
    public static boolean isSupported() {
        return LoomSupport.isEnabled();
    }

    Continuation(Runnable target) {
        this.target = target;
    }

    public Pointer getBaseSP() {
        return this.baseSP;
    }

    void enter() {
        boolean isContinue;
        int stateBefore = StackOverflowCheck.singleton().getState();
        VMError.guarantee(!StackOverflowCheck.singleton().isYellowZoneAvailable());
        boolean bl = isContinue = this.stored != null;
        if (isContinue) {
            StackOverflowCheck.singleton().setState(this.overflowCheckState);
        }
        try {
            this.enter0(isContinue);
        }
        catch (StackOverflowError e) {
            throw e == ImplicitExceptions.CACHED_STACK_OVERFLOW_ERROR ? new StackOverflowError() : e;
        }
        finally {
            this.overflowCheckState = StackOverflowCheck.singleton().getState();
            StackOverflowCheck.singleton().setState(stateBefore);
            assert (this.sp.isNull() && this.ip.isNull() && this.baseSP.isNull());
        }
    }

    @NeverInline(value="Needs a frame to return to when yielding.")
    private void enter0(boolean isContinue) {
        this.enter1(isContinue);
    }

    @NeverInline(value="Accesses caller stack pointer and return address.")
    private Object enter1(boolean isContinue) {
        Pointer callerSP = KnownIntrinsics.readCallerStackPointer();
        CodePointer callerIP = KnownIntrinsics.readReturnAddress();
        assert (this.sp.isNull() && this.ip.isNull() && this.baseSP.isNull());
        if (isContinue) {
            StoredContinuation cont = this.stored;
            assert (cont != null);
            this.ip = callerIP;
            this.sp = callerSP;
            this.baseSP = KnownIntrinsics.readStackPointer();
            this.stored = null;
            int framesSize = StoredContinuationAccess.getFramesSizeInBytes(cont);
            Pointer topSP = KnownIntrinsics.readStackPointer().subtract(framesSize);
            if (!StackOverflowCheck.singleton().isWithinBounds((UnsignedWord)topSP)) {
                throw ImplicitExceptions.CACHED_STACK_OVERFLOW_ERROR;
            }
            Object preparedData = ((ContinuationSupport)ImageSingletons.lookup(ContinuationSupport.class)).prepareCopy(cont);
            ContinuationSupport.enter(cont, topSP, preparedData);
            throw VMError.shouldNotReachHereAtRuntime();
        }
        assert (this.stored == null);
        this.ip = callerIP;
        this.sp = callerSP;
        this.baseSP = KnownIntrinsics.readStackPointer();
        this.enter2();
        throw VMError.shouldNotReachHereAtRuntime();
    }

    @NeverInline(value="Needs a separate frame which is part of the continuation stack that we can eventually return to.")
    private void enter2() {
        try {
            this.target.run();
        }
        catch (Throwable t) {
            throw VMError.shouldNotReachHere(t);
        }
        Pointer returnSP = this.sp;
        CodePointer returnIP = this.ip;
        this.ip = (CodePointer)WordFactory.nullPointer();
        this.sp = (Pointer)WordFactory.nullPointer();
        this.baseSP = (Pointer)WordFactory.nullPointer();
        assert (this.isEmpty());
        KnownIntrinsics.farReturn(null, returnSP, returnIP, false);
        throw VMError.shouldNotReachHereAtRuntime();
    }

    int tryPreempt(Thread thread) {
        TryPreemptOperation vmOp = new TryPreemptOperation(this, thread);
        vmOp.enqueue();
        return vmOp.preemptStatus;
    }

    @NeverInline(value="Needs a frame to resume the continuation at.")
    Integer yield() {
        return this.yield0();
    }

    @NeverInline(value="Accesses caller stack pointer and return address.")
    private Integer yield0() {
        Pointer leafSP = KnownIntrinsics.readCallerStackPointer();
        CodePointer leafIP = KnownIntrinsics.readReturnAddress();
        Pointer returnSP = this.sp;
        CodePointer returnIP = this.ip;
        int preemptStatus = StoredContinuationAccess.allocateToYield(this, this.baseSP, leafSP, leafIP);
        if (preemptStatus != 0) {
            return preemptStatus;
        }
        this.ip = (CodePointer)WordFactory.nullPointer();
        this.sp = (Pointer)WordFactory.nullPointer();
        this.baseSP = (Pointer)WordFactory.nullPointer();
        KnownIntrinsics.farReturn(null, returnSP, returnIP, false);
        throw VMError.shouldNotReachHereAtRuntime();
    }

    boolean isStarted() {
        return this.stored != null || this.ip.isNonNull();
    }

    boolean isEmpty() {
        return this.stored == null;
    }

    private static final class TryPreemptOperation
    extends JavaVMOperation {
        int preemptStatus = 0;
        final Continuation cont;
        final Thread thread;

        TryPreemptOperation(Continuation cont, Thread thread) {
            super(VMOperationInfos.get(TryPreemptOperation.class, "Try to preempt continuation", VMOperation.SystemEffect.SAFEPOINT));
            this.cont = cont;
            this.thread = thread;
        }

        @Override
        public void operate() {
            IsolateThread vmThread = PlatformThreads.getIsolateThread(this.thread);
            Pointer baseSP = this.cont.baseSP;
            Pointer returnSP = this.cont.sp;
            CodePointer returnIP = this.cont.ip;
            this.preemptStatus = StoredContinuationAccess.allocateToPreempt(this.cont, baseSP, vmThread);
            if (this.preemptStatus == 0) {
                this.cont.sp = (Pointer)WordFactory.nullPointer();
                this.cont.baseSP = (Pointer)WordFactory.nullPointer();
                this.cont.ip = (CodePointer)WordFactory.nullPointer();
                VMThreads.ActionOnExitSafepointSupport.setSwitchStack(vmThread);
                VMThreads.ActionOnExitSafepointSupport.setSwitchStackTarget(vmThread, returnSP, returnIP);
            }
        }
    }
}

