/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect;

import com.oracle.svm.core.MissingRegistrationUtils;
import com.oracle.svm.core.graal.snippets.SubstrateAllocationSnippets;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.graalvm.nativeimage.MissingReflectionRegistrationError;

public final class MissingReflectionRegistrationUtils {
    private static final Map<String, Set<String>> reflectionEntryPoints = Map.of(Class.class.getTypeName(), Set.of("forName", "getClasses", "getDeclaredClasses", "getConstructor", "getConstructors", "getDeclaredConstructor", "getDeclaredConstructors", "getField", "getFields", "getDeclaredField", "getDeclaredFields", "getMethod", "getMethods", "getDeclaredMethod", "getDeclaredMethods", "getNestMembers", "getPermittedSubclasses", "getRecordComponents", "getSigners", "arrayType", "newInstance"), Method.class.getTypeName(), Set.of("invoke"), Constructor.class.getTypeName(), Set.of("newInstance"), Proxy.class.getTypeName(), Set.of("getProxyClass", "newProxyInstance"), "java.lang.reflect.ReflectAccess", Set.of("newInstance"), "jdk.internal.access.JavaLangAccess", Set.of("getDeclaredPublicMethods"), "sun.misc.Unsafe", Set.of("allocateInstance"), SubstrateAllocationSnippets.class.getName(), Set.of("instanceHubErrorStub"));

    public static void forClass(String className) {
        MissingReflectionRegistrationError exception = new MissingReflectionRegistrationError(MissingReflectionRegistrationUtils.errorMessage("access class", className), Class.class, null, className, null);
        MissingReflectionRegistrationUtils.report(exception);
    }

    public static void forField(Class<?> declaringClass, String fieldName) {
        MissingReflectionRegistrationError exception = new MissingReflectionRegistrationError(MissingReflectionRegistrationUtils.errorMessage("access field", declaringClass.getTypeName() + "#" + fieldName), Field.class, declaringClass, fieldName, null);
        MissingReflectionRegistrationUtils.report(exception);
    }

    public static MissingReflectionRegistrationError errorForQueriedOnlyField(Field field) {
        MissingReflectionRegistrationError exception = new MissingReflectionRegistrationError(MissingReflectionRegistrationUtils.errorMessage("read or write field", field.toString()), field.getClass(), field.getDeclaringClass(), field.getName(), null);
        MissingReflectionRegistrationUtils.report(exception);
        return exception;
    }

    public static void forMethod(Class<?> declaringClass, String methodName, Class<?>[] paramTypes) {
        StringJoiner paramTypeNames = new StringJoiner(", ", "(", ")");
        if (paramTypes != null) {
            for (Class<?> paramType : paramTypes) {
                paramTypeNames.add(paramType.getTypeName());
            }
        }
        MissingReflectionRegistrationError exception = new MissingReflectionRegistrationError(MissingReflectionRegistrationUtils.errorMessage("access method", declaringClass.getTypeName() + "#" + methodName + String.valueOf(paramTypeNames)), Method.class, declaringClass, methodName, (Class[])paramTypes);
        MissingReflectionRegistrationUtils.report(exception);
    }

    public static void forQueriedOnlyExecutable(Executable executable) {
        MissingReflectionRegistrationError exception = new MissingReflectionRegistrationError(MissingReflectionRegistrationUtils.errorMessage("invoke method", executable.toString()), executable.getClass(), executable.getDeclaringClass(), executable.getName(), (Class[])executable.getParameterTypes());
        MissingReflectionRegistrationUtils.report(exception);
        throw exception;
    }

    public static void forBulkQuery(Class<?> declaringClass, String methodName) {
        MissingReflectionRegistrationError exception = new MissingReflectionRegistrationError(MissingReflectionRegistrationUtils.errorMessage("access", declaringClass.getTypeName() + "." + methodName + "()"), null, declaringClass, methodName, null);
        MissingReflectionRegistrationUtils.report(exception);
    }

    public static void forProxy(Class<?> ... interfaces) {
        MissingReflectionRegistrationError exception = new MissingReflectionRegistrationError(MissingReflectionRegistrationUtils.errorMessage("access the proxy class inheriting", Arrays.toString(Arrays.stream(interfaces).map(Class::getTypeName).toArray()), "The order of interfaces used to create proxies matters.", "dynamic-proxy"), Proxy.class, null, null, (Class[])interfaces);
        MissingReflectionRegistrationUtils.report(exception);
        throw exception;
    }

    private static String errorMessage(String failedAction, String elementDescriptor) {
        return MissingReflectionRegistrationUtils.errorMessage(failedAction, elementDescriptor, null, "reflection");
    }

    private static String errorMessage(String failedAction, String elementDescriptor, String note, String helpLink) {
        return "The program tried to reflectively " + failedAction + " " + elementDescriptor + " without it being registered for runtime reflection. Add " + elementDescriptor + " to the " + helpLink + " metadata to solve this problem. " + (String)(note != null ? "Note: " + note + " " : "") + "See https://www.graalvm.org/latest/reference-manual/native-image/metadata/#" + helpLink + " for help.";
    }

    private static void report(MissingReflectionRegistrationError exception) {
        StackTraceElement responsibleClass = MissingReflectionRegistrationUtils.getResponsibleClass((Throwable)exception);
        MissingRegistrationUtils.report((Error)exception, responsibleClass);
    }

    private static StackTraceElement getResponsibleClass(Throwable t) {
        StackTraceElement[] stackTrace = t.getStackTrace();
        boolean returnNext = false;
        for (StackTraceElement stackTraceElement : stackTrace) {
            if (reflectionEntryPoints.getOrDefault(stackTraceElement.getClassName(), Set.of()).contains(stackTraceElement.getMethodName())) {
                returnNext = true;
                continue;
            }
            if (!returnNext) continue;
            return stackTraceElement;
        }
        return null;
    }
}

