/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CIsolateData;
import com.oracle.svm.core.c.CIsolateDataFactory;
import com.oracle.svm.core.locks.VMSemaphore;
import com.oracle.svm.core.posix.headers.Semaphore;
import com.oracle.svm.core.posix.pthread.PthreadVMLockSupport;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.WordFactory;

final class LinuxVMSemaphore
extends VMSemaphore {
    private final CIsolateData<Semaphore.sem_t> structPointer;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    LinuxVMSemaphore(String name) {
        super(name);
        this.structPointer = CIsolateDataFactory.createStruct("linuxSemaphore_" + name, Semaphore.sem_t.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private Semaphore.sem_t getStructPointer() {
        return this.structPointer.get();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected int init() {
        return Semaphore.NoTransitions.sem_init(this.getStructPointer(), WordFactory.signed((int)0), WordFactory.unsigned((int)0));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void destroy() {
        PthreadVMLockSupport.checkResult(Semaphore.NoTransitions.sem_destroy(this.getStructPointer()), "sem_destroy");
    }

    @Override
    public void await() {
        PthreadVMLockSupport.checkResult(Semaphore.sem_wait(this.getStructPointer()), "sem_wait");
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void signal() {
        PthreadVMLockSupport.checkResult(Semaphore.NoTransitions.sem_post(this.getStructPointer()), "sem_post");
    }
}

