/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.stack.StackOverflowCheck;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredImageSingleton(value={StackOverflowCheck.PlatformSupport.class})
final class LinuxStackOverflowSupport
implements StackOverflowCheck.PlatformSupport {
    LinuxStackOverflowSupport() {
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean lookupStack(WordPointer stackBasePtr, WordPointer stackEndPtr) {
        boolean result = LinuxStackOverflowSupport.lookupStack0(stackBasePtr, stackEndPtr);
        if (!result) {
            stackBasePtr.write(WordFactory.zero());
            stackEndPtr.write(WordFactory.zero());
        }
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean lookupStack0(WordPointer stackBasePtr, WordPointer stackEndPtr) {
        WordPointer guardSizePtr = (WordPointer)StackValue.get(WordPointer.class);
        Pthread.pthread_attr_t attr = (Pthread.pthread_attr_t)StackValue.get(Pthread.pthread_attr_t.class);
        if (Pthread.pthread_getattr_np(Pthread.pthread_self(), attr) != 0) {
            return false;
        }
        if (Pthread.pthread_attr_getstack(attr, stackBasePtr, stackEndPtr) != 0) {
            return false;
        }
        if (Pthread.pthread_attr_getguardsize(attr, guardSizePtr) != 0) {
            return false;
        }
        UnsignedWord stackAddr = (UnsignedWord)stackBasePtr.read();
        UnsignedWord stackSize = (UnsignedWord)stackEndPtr.read();
        UnsignedWord guardSize = (UnsignedWord)guardSizePtr.read();
        UnsignedWord stackBase = stackAddr.add(stackSize);
        UnsignedWord stackEnd = stackAddr.add(guardSize);
        stackBasePtr.write((WordBase)stackBase);
        stackEndPtr.write((WordBase)stackEnd);
        PosixUtils.checkStatusIs0(Pthread.pthread_attr_destroy(attr), "LinuxStackOverflowSupport: pthread_attr_destroy");
        return true;
    }
}

