/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.core.option.URIOptionOrigin;
import com.oracle.svm.core.util.VMError;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.graalvm.compiler.core.common.SuppressFBWarnings;

final class DirectoryOptionOrigin
extends URIOptionOrigin {
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="originPath.getRoot() is never null")
    protected DirectoryOptionOrigin(boolean isStable, Path originPath) {
        super(isStable);
        int pathPos = 0;
        int metaInfPos = -1;
        for (Path entry : originPath) {
            if ("META-INF".equals(entry.toString())) {
                metaInfPos = pathPos;
                break;
            }
            ++pathPos;
        }
        VMError.guarantee(metaInfPos > 0, "Invalid directory origin");
        this.container = originPath.getRoot().resolve(originPath.subpath(0, metaInfPos)).toUri();
        this.location = originPath.subpath(metaInfPos, originPath.getNameCount());
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="location()).getParent() is never null")
    public List<String> getRedirectionValues(Path valuesFile) throws IOException {
        Path normalizedRedirPath = Path.of(this.container()).resolve(this.location()).getParent().resolve(valuesFile).normalize();
        return DirectoryOptionOrigin.getRedirectionValuesFromPath(normalizedRedirPath);
    }
}

