/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.jfr.JfrBuffer;
import com.oracle.svm.core.jfr.JfrBufferNode;
import com.oracle.svm.core.jfr.JfrBufferNodeAccess;
import com.oracle.svm.core.jfr.JfrBufferType;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.UnsignedUtils;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.impl.UnmanagedMemorySupport;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class JfrBufferAccess {
    private static final byte NO_FLAGS = 0;
    private static final byte RETIRED_FLAG = 1;

    private JfrBufferAccess() {
    }

    @Fold
    public static UnsignedWord getHeaderSize() {
        return UnsignedUtils.roundUp(SizeOf.unsigned(JfrBuffer.class), WordFactory.unsigned((int)ConfigurationValues.getTarget().wordSize));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static JfrBuffer allocate(JfrBufferType bufferType) {
        long dataSize = SubstrateJVM.getThreadLocal().getThreadLocalBufferSize();
        return JfrBufferAccess.allocate(WordFactory.unsigned((long)dataSize), bufferType);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static JfrBuffer allocate(UnsignedWord dataSize, JfrBufferType bufferType) {
        UnsignedWord headerSize = JfrBufferAccess.getHeaderSize();
        JfrBuffer result = (JfrBuffer)((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).malloc(headerSize.add(dataSize));
        if (result.isNonNull()) {
            result.setSize(dataSize);
            result.setBufferType(bufferType);
            result.setNode((JfrBufferNode)WordFactory.nullPointer());
            result.setFlags((byte)0);
            JfrBufferAccess.reinitialize(result);
        }
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void free(JfrBuffer buffer) {
        ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).free((PointerBase)buffer);
    }

    @Uninterruptible(reason="Prevent safepoints as those could change the flushed position.")
    public static void reinitialize(JfrBuffer buffer) {
        if (buffer.isNonNull()) {
            Pointer pos = JfrBufferAccess.getDataStart(buffer);
            buffer.setCommittedPos(pos);
            JfrBufferAccess.setFlushedPos(buffer, pos);
        }
    }

    @Uninterruptible(reason="Changes flushed position.")
    public static void setFlushedPos(JfrBuffer buffer, Pointer pos) {
        assert (buffer.getNode().isNull() || VMOperation.isInProgressAtSafepoint() || JfrBufferNodeAccess.isLockedByCurrentThread(buffer.getNode()));
        buffer.setFlushedPos(pos);
    }

    @Uninterruptible(reason="Accesses flushed position. Possible race between flushing and working threads.")
    public static Pointer getFlushedPos(JfrBuffer buffer) {
        assert (buffer.getNode().isNull() || VMOperation.isInProgressAtSafepoint() || JfrBufferNodeAccess.isLockedByCurrentThread(buffer.getNode()));
        return buffer.getFlushedPos();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer getAddressOfCommittedPos(JfrBuffer buffer) {
        assert (buffer.isNonNull());
        return ((Pointer)buffer).add(JfrBuffer.offsetOfCommittedPos());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer getDataStart(JfrBuffer buffer) {
        assert (buffer.isNonNull());
        return ((Pointer)buffer).add(JfrBufferAccess.getHeaderSize());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer getDataEnd(JfrBuffer buffer) {
        assert (buffer.isNonNull());
        return JfrBufferAccess.getDataStart(buffer).add(buffer.getSize());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getAvailableSize(JfrBuffer buffer) {
        assert (buffer.isNonNull());
        return JfrBufferAccess.getDataEnd(buffer).subtract((UnsignedWord)buffer.getCommittedPos());
    }

    @Uninterruptible(reason="Prevent safepoints as those could change the flushed position.", callerMustBe=true)
    public static UnsignedWord getUnflushedSize(JfrBuffer buffer) {
        assert (buffer.isNonNull());
        return buffer.getCommittedPos().subtract((UnsignedWord)JfrBufferAccess.getFlushedPos(buffer));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void increaseCommittedPos(JfrBuffer buffer, UnsignedWord delta) {
        assert (buffer.isNonNull());
        buffer.setCommittedPos(buffer.getCommittedPos().add(delta));
    }

    @Uninterruptible(reason="Prevent safepoints as those could change the flushed position.")
    public static void increaseFlushedPos(JfrBuffer buffer, UnsignedWord delta) {
        assert (buffer.isNonNull());
        JfrBufferAccess.setFlushedPos(buffer, JfrBufferAccess.getFlushedPos(buffer).add(delta));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isEmpty(JfrBuffer buffer) {
        assert (buffer.isNonNull());
        return JfrBufferAccess.getDataStart(buffer).equal((UnsignedWord)buffer.getCommittedPos());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean verify(JfrBuffer buffer) {
        if (buffer.isNull()) {
            return false;
        }
        Pointer start = JfrBufferAccess.getDataStart(buffer);
        Pointer end = JfrBufferAccess.getDataEnd(buffer);
        return buffer.getCommittedPos().aboveOrEqual((UnsignedWord)start) && buffer.getCommittedPos().belowOrEqual((UnsignedWord)end) && buffer.getFlushedPos().aboveOrEqual((UnsignedWord)start) && buffer.getFlushedPos().belowOrEqual((UnsignedWord)end) && buffer.getFlushedPos().belowOrEqual((UnsignedWord)buffer.getCommittedPos());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isThreadLocal(JfrBuffer buffer) {
        return buffer.getBufferType().isThreadLocal();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setRetired(JfrBuffer buffer) {
        assert (!JfrBufferAccess.isRetired(buffer));
        buffer.setFlags((byte)(buffer.getFlags() | 1));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void clearRetired(JfrBuffer buffer) {
        assert (JfrBufferAccess.isRetired(buffer));
        buffer.setFlags((byte)(buffer.getFlags() & 0xFFFFFFFE));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isRetired(JfrBuffer buffer) {
        return (buffer.getFlags() & 1) != 0;
    }
}

