/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.localization.compression;

import com.oracle.svm.core.jdk.localization.bundles.CompressedBundle;
import com.oracle.svm.core.jdk.localization.compression.utils.BundleSerializationUtils;
import com.oracle.svm.core.jdk.localization.compression.utils.CompressionUtils;
import com.oracle.svm.core.util.VMError;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.graalvm.collections.Pair;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class GzipBundleCompression {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static boolean canCompress(ResourceBundle bundle) {
        return BundleSerializationUtils.extractContent(bundle).values().stream().allMatch(value -> value instanceof String || value instanceof Object[] && Arrays.stream((Object[])value).allMatch(elem -> elem instanceof String));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static CompressedBundle compress(ResourceBundle bundle) {
        Map<String, Object> content = BundleSerializationUtils.extractContent(bundle);
        Pair<String, int[]> input = BundleSerializationUtils.serializeContent(content);
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();){
            CompressedBundle compressedBundle;
            try (GZIPOutputStream out = new GZIPOutputStream(byteStream);){
                GzipBundleCompression.writeIndices((int[])input.getRight(), out);
                GzipBundleCompression.writeText((String)input.getLeft(), out);
                out.finish();
                compressedBundle = new CompressedBundle(byteStream.toByteArray(), GzipBundleCompression::decompressBundle);
            }
            return compressedBundle;
        }
        catch (IOException ex) {
            throw VMError.shouldNotReachHere("Compression of a bundle " + String.valueOf(bundle.getClass()) + " failed. This is an internal error. Please open an issue and submit a reproducer.", ex);
        }
    }

    private static Map<String, Object> decompressBundle(byte[] data) {
        Map<String, Object> map;
        GZIPInputStream input = new GZIPInputStream(new ByteArrayInputStream(data));
        try {
            int[] indices = GzipBundleCompression.readIndices(input);
            String decompressed = GzipBundleCompression.readText(input);
            map = BundleSerializationUtils.deserializeContent(indices, decompressed);
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw VMError.shouldNotReachHere("Decompressing a resource bundle failed.", e);
            }
        }
        input.close();
        return map;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static void writeIndices(int[] indices, GZIPOutputStream out) throws IOException {
        byte[] indicesInBytes = CompressionUtils.intsToBytes(indices);
        CompressionUtils.writeInt(out, indicesInBytes.length);
        out.write(indicesInBytes);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static void writeText(String text, GZIPOutputStream out) throws IOException {
        byte[] textBytes = text.getBytes(StandardCharsets.UTF_8);
        CompressionUtils.writeInt(out, textBytes.length);
        out.write(textBytes);
    }

    private static int[] readIndices(GZIPInputStream input) throws IOException {
        int indicesInBytesLen = CompressionUtils.readInt(input);
        byte[] indicesInBytes = new byte[indicesInBytesLen];
        int realIntsRead = CompressionUtils.readNBytes(input, indicesInBytes);
        assert (realIntsRead == indicesInBytesLen) : "Not enough indices bytes read";
        return CompressionUtils.bytesToInts(indicesInBytes);
    }

    private static String readText(GZIPInputStream input) throws IOException {
        int remainingBytesSize = CompressionUtils.readInt(input);
        byte[] stringBytes = new byte[remainingBytesSize];
        int allBytesRead = CompressionUtils.readNBytes(input, stringBytes);
        assert (allBytesRead == remainingBytesSize) : "Not enough indices bytes read";
        return new String(stringBytes, StandardCharsets.UTF_8);
    }
}

