/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoDecoder;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.jdk.BacktraceVisitor;
import com.oracle.svm.core.jdk.StackTraceUtils;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.WordFactory;

public abstract class BacktraceDecoder {
    private final CodeInfoDecoder.FrameInfoCursor frameInfoCursor = new CodeInfoDecoder.FrameInfoCursor();

    protected final int visitBacktrace(long[] backtrace, int maxFramesProcessed, int maxFramesDecode) {
        int maxFramesDecodeLimit = maxFramesDecode > 0 ? maxFramesDecode : Integer.MAX_VALUE;
        int framesDecoded = 0;
        if (backtrace != null) {
            int backtraceIndex = 0;
            while (backtraceIndex < backtrace.length && backtrace[backtraceIndex] != 0L) {
                long entry = backtrace[backtraceIndex];
                if (BacktraceVisitor.isSourceReference(entry)) {
                    VMError.guarantee(backtraceIndex + BacktraceVisitor.entriesPerSourceReference() <= backtrace.length, "Truncated backtrace array");
                    this.visitSourceReference(maxFramesProcessed, framesDecoded, backtrace, backtraceIndex);
                    ++framesDecoded;
                    backtraceIndex += BacktraceVisitor.entriesPerSourceReference();
                } else {
                    CodePointer ip = (CodePointer)WordFactory.pointer((long)entry);
                    framesDecoded = this.visitCodePointer(ip, framesDecoded, maxFramesProcessed, maxFramesDecodeLimit);
                    ++backtraceIndex;
                }
                if (framesDecoded != maxFramesDecodeLimit) continue;
                break;
            }
        }
        return framesDecoded - maxFramesProcessed;
    }

    private void visitSourceReference(int maxFramesProcessed, int framesDecoded, long[] trace, int backtraceIndex) {
        int sourceLineNumber = BacktraceVisitor.readSourceLineNumber(trace, backtraceIndex);
        Class<?> sourceClass = BacktraceVisitor.readSourceClass(trace, backtraceIndex);
        String sourceMethodName = BacktraceVisitor.readSourceMethodName(trace, backtraceIndex);
        if (framesDecoded < maxFramesProcessed) {
            this.processSourceReference(sourceClass, sourceMethodName, sourceLineNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Prevent the GC from freeing the CodeInfo object.")
    private int visitCodePointer(CodePointer ip, int oldFramesDecoded, int maxFramesProcessed, int maxFramesDecode) {
        int framesDecoded = oldFramesDecoded;
        UntetheredCodeInfo untetheredInfo = CodeInfoTable.lookupCodeInfo(ip);
        if (untetheredInfo.isNull()) {
            VMError.shouldNotReachHere("Stack walk must walk only frames of known code.");
        }
        Object tether = CodeInfoAccess.acquireTether(untetheredInfo);
        try {
            CodeInfo tetheredCodeInfo = CodeInfoAccess.convert(untetheredInfo, tether);
            framesDecoded = this.visitFrame(ip, tetheredCodeInfo, framesDecoded, maxFramesProcessed, maxFramesDecode);
        }
        finally {
            CodeInfoAccess.releaseTether(untetheredInfo, tether);
        }
        return framesDecoded;
    }

    @Uninterruptible(reason="Wraps the now safe call to the possibly interruptible visitor.", callerMustBe=true, calleeMustBe=false)
    private int visitFrame(CodePointer ip, CodeInfo tetheredCodeInfo, int oldFramesDecoded, int maxFramesProcessed, int maxFramesDecode) {
        int framesDecoded = oldFramesDecoded;
        this.frameInfoCursor.initialize(tetheredCodeInfo, ip, true);
        while (this.frameInfoCursor.advance()) {
            FrameInfoQueryResult frameInfo = this.frameInfoCursor.get();
            if (!StackTraceUtils.shouldShowFrame(frameInfo, false, true, false) || framesDecoded == 0 && Throwable.class.isAssignableFrom(frameInfo.getSourceClass())) continue;
            if (framesDecoded < maxFramesProcessed) {
                this.processSourceReference(frameInfo.getSourceClass(), frameInfo.getSourceMethodName(), frameInfo.getSourceLineNumber());
            }
            if (++framesDecoded != maxFramesDecode) continue;
            break;
        }
        return framesDecoded;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.UNRESTRICTED, reason="Some implementations allocate.")
    protected abstract void processSourceReference(Class<?> var1, String var2, int var3);
}

