/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class GCCause {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static final ArrayList<GCCause> HostedGCCauseList = new ArrayList();
    public static final GCCause JavaLangSystemGC = new GCCause("java.lang.System.gc()", 0);
    public static final GCCause UnitTest = new GCCause("Forced GC in unit test", 1);
    public static final GCCause TestGCInDeoptimizer = new GCCause("Test GC in deoptimizer", 2);
    public static final GCCause HintedGC = new GCCause("Hinted GC", 3);
    public static final GCCause JvmtiForceGC = new GCCause("JvmtiEnv ForceGarbageCollection", 4);
    public static final GCCause HeapDump = new GCCause("Heap Dump Initiated GC ", 5);
    @UnknownObjectField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    protected static GCCause[] GCCauses;
    private final int id;
    private final String name;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected GCCause(String name, int id) {
        this.id = id;
        this.name = name;
        this.addGCCauseMapping();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private void addGCCauseMapping() {
        ArrayList<GCCause> arrayList = HostedGCCauseList;
        synchronized (arrayList) {
            while (HostedGCCauseList.size() <= this.id) {
                HostedGCCauseList.add(null);
            }
            VMError.guarantee(HostedGCCauseList.get(this.id) == null, "%s and another GCCause have the same id.", this.name);
            HostedGCCauseList.set(this.id, this);
        }
    }

    public String getName() {
        return this.name;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getId() {
        return this.id;
    }

    public static GCCause fromId(int causeId) {
        return GCCauses[causeId];
    }

    public static GCCause[] getGCCauses() {
        return GCCauses;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void cacheReverseMapping() {
        GCCauses = HostedGCCauseList.toArray(new GCCause[HostedGCCauseList.size()]);
    }
}

