/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.stackvalue;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.stackvalue.AbstractStackValueNode;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.PermanentBailoutException;
import org.graalvm.compiler.core.common.calc.UnsignedMath;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;

@NodeInfo(cycles=NodeCycles.CYCLES_4, size=NodeSize.SIZE_8)
public class StackValueNode
extends AbstractStackValueNode {
    public static final NodeClass<StackValueNode> TYPE = NodeClass.create(StackValueNode.class);
    static final int MAX_SIZE = 0xA00000;
    protected final int sizeInBytes;

    protected StackValueNode(int sizeInBytes, int alignmentInBytes, StackSlotIdentity slotIdentity, boolean checkVirtualThread) {
        this(TYPE, sizeInBytes, alignmentInBytes, slotIdentity, checkVirtualThread);
    }

    protected StackValueNode(NodeClass<? extends StackValueNode> type, int sizeInBytes, int alignmentInBytes, StackSlotIdentity slotIdentity, boolean checkVirtualThread) {
        super(type, alignmentInBytes, slotIdentity, checkVirtualThread);
        this.sizeInBytes = sizeInBytes;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public static ValueNode create(long numElements, long elementSize, GraphBuilderContext b, boolean disallowVirtualThread) {
        if (UnsignedMath.aboveOrEqual((long)numElements, (long)0xA00000L) || UnsignedMath.aboveOrEqual((long)elementSize, (long)0xA00000L) || UnsignedMath.aboveOrEqual((long)(numElements * elementSize), (long)0xA00000L)) {
            throw new PermanentBailoutException("Stack value has illegal size " + numElements + " * " + elementSize);
        }
        int sizeInBytes = NumUtil.safeToInt((long)(numElements * elementSize));
        return StackValueNode.create(sizeInBytes, b.getGraph().method(), b.bci(), disallowVirtualThread);
    }

    public static StackValueNode create(int sizeInBytes, ResolvedJavaMethod method, int bci, boolean disallowVirtualThread) {
        StackSlotIdentity slotIdentity = StackValueNode.createStackSlotIdentity(method, bci);
        return StackValueNode.create(sizeInBytes, slotIdentity, StackValueNode.needsVirtualThreadCheck(method, disallowVirtualThread));
    }

    public static StackValueNode create(int sizeInBytes, StackSlotIdentity slotIdentity, boolean checkVirtualThread) {
        if (UnsignedMath.aboveOrEqual((int)sizeInBytes, (int)0xA00000)) {
            throw new PermanentBailoutException("Stack value has illegal size " + sizeInBytes + ": " + slotIdentity.name);
        }
        int alignmentInBytes = ConfigurationValues.getTarget().stackAlignment;
        return new StackValueNode(sizeInBytes, alignmentInBytes, slotIdentity, checkVirtualThread);
    }

    public static class StackSlotIdentity {
        protected final boolean shared;
        protected final String name;

        public StackSlotIdentity(String name, boolean shared) {
            this.name = name;
            this.shared = shared;
        }

        public String toString() {
            return this.name;
        }
    }
}

