/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.amd64;

import com.oracle.svm.core.graal.code.NativeImagePatcher;
import org.graalvm.compiler.asm.amd64.AMD64BaseAssembler;
import org.graalvm.compiler.code.CompilationResult;

public class AMD64NativeImagePatcher
extends CompilationResult.CodeAnnotation
implements NativeImagePatcher {
    private final AMD64BaseAssembler.OperandDataAnnotation annotation;

    public AMD64NativeImagePatcher(AMD64BaseAssembler.OperandDataAnnotation annotation) {
        super(annotation.instructionPosition);
        this.annotation = annotation;
    }

    @Override
    public void patchCode(long methodStartAddress, int relative, byte[] code) {
        int curValue = relative - (this.annotation.nextInstructionPosition - this.annotation.instructionPosition);
        for (int i = 0; i < this.annotation.operandSize; ++i) {
            assert (code[this.annotation.operandPosition + i] == 0);
            code[this.annotation.operandPosition + i] = (byte)(curValue & 0xFF);
            curValue >>>= 8;
        }
        assert (curValue == 0);
    }

    @Override
    public int getOffset() {
        return this.annotation.operandPosition;
    }

    @Override
    public int getLength() {
        return this.annotation.operandSize;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }
}

