/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.util.VMError;
import java.util.Objects;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@AutomaticallyRegisteredImageSingleton
public final class StaticFieldsSupport {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private Object[] staticObjectFields;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private byte[] staticPrimitiveFields;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected StaticFieldsSupport() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void setData(Object[] staticObjectFields, byte[] staticPrimitiveFields) {
        StaticFieldsSupport support = (StaticFieldsSupport)ImageSingletons.lookup(StaticFieldsSupport.class);
        support.staticObjectFields = Objects.requireNonNull(staticObjectFields);
        support.staticPrimitiveFields = Objects.requireNonNull(staticPrimitiveFields);
    }

    public static Object getStaticObjectFields() {
        Object[] result = ((StaticFieldsSupport)ImageSingletons.lookup(StaticFieldsSupport.class)).staticObjectFields;
        VMError.guarantee(result != null, "arrays that hold static fields are only available after static analysis");
        return result;
    }

    public static Object getStaticPrimitiveFields() {
        byte[] result = ((StaticFieldsSupport)ImageSingletons.lookup(StaticFieldsSupport.class)).staticPrimitiveFields;
        VMError.guarantee(result != null, "arrays that hold static fields are only available after static analysis");
        return result;
    }

    public static FloatingNode createStaticFieldBaseNode(boolean primitive) {
        return new StaticFieldBaseNode(primitive);
    }

    @NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_1)
    public static final class StaticFieldBaseNode
    extends FloatingNode
    implements Lowerable {
        public static final NodeClass<StaticFieldBaseNode> TYPE = NodeClass.create(StaticFieldBaseNode.class);
        public final boolean primitive;

        protected StaticFieldBaseNode(boolean primitive) {
            super(TYPE, StampFactory.objectNonNull());
            this.primitive = primitive;
        }

        public void lower(LoweringTool tool) {
            if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.LOW_TIER) {
                return;
            }
            JavaConstant constant = tool.getSnippetReflection().forObject(this.primitive ? StaticFieldsSupport.getStaticPrimitiveFields() : StaticFieldsSupport.getStaticObjectFields());
            assert (constant.isNonNull());
            this.replaceAndDelete((Node)ConstantNode.forConstant((JavaConstant)constant, (MetaAccessProvider)tool.getMetaAccess(), (StructuredGraph)this.graph()));
        }
    }
}

