/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.processor;

import java.util.HashMap;
import java.util.Iterator;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.graalvm.compiler.processor.AbstractProcessor;
import org.graalvm.compiler.replacements.processor.GeneratedPlugin;

public class InjectedDependencies
implements Iterable<Dependency> {
    protected final HashMap<String, Dependency> deps;
    protected final boolean useVariables;
    protected final ExecutableElement intrinsicMethod;

    public InjectedDependencies(boolean useVariables, ExecutableElement intrinsicMethod) {
        this.useVariables = useVariables;
        this.intrinsicMethod = intrinsicMethod;
        this.deps = new HashMap();
    }

    public String use(AbstractProcessor processor, WellKnownDependency wellKnown) {
        if (wellKnown.generateMember != null) {
            this.deps.put(wellKnown.type, wellKnown.generateMember);
        }
        if (this.useVariables) {
            return wellKnown.getName(processor, this.intrinsicMethod) + "/* A " + String.valueOf(wellKnown) + " */";
        }
        return wellKnown.getExpression(processor, this.intrinsicMethod) + "/* B " + String.valueOf(wellKnown) + " */";
    }

    public Dependency find(AbstractProcessor processor, DeclaredType type) {
        for (WellKnownDependency wellKnown : WellKnownDependency.values()) {
            if (!processor.env().getTypeUtils().isAssignable(wellKnown.getType(processor), type)) continue;
            this.use(processor, wellKnown);
            return wellKnown;
        }
        String typeName = type.toString();
        Dependency ret = this.deps.get(typeName);
        if (ret == null) {
            ret = new InjectedDependency("injected" + String.valueOf(type.asElement().getSimpleName()), typeName);
            this.deps.put(typeName, ret);
        }
        return ret;
    }

    public String use(AbstractProcessor processor, DeclaredType type) {
        return this.find(processor, type).getName(processor, this.intrinsicMethod);
    }

    public String inject(AbstractProcessor processor, DeclaredType type) {
        return this.find(processor, type).getExpression(processor, this.intrinsicMethod);
    }

    @Override
    public Iterator<Dependency> iterator() {
        return this.deps.values().iterator();
    }

    public boolean isEmpty() {
        return this.deps.isEmpty();
    }

    public static enum WellKnownDependency implements Dependency
    {
        CONSTANT_REFLECTION("b.getConstantReflection()", "jdk.vm.ci.meta.ConstantReflectionProvider"),
        META_ACCESS("b.getMetaAccess()", "jdk.vm.ci.meta.MetaAccessProvider"),
        ASSUMPTIONS("b.getAssumptions()", "jdk.vm.ci.meta.Assumptions"),
        OPTIONVALUES("b.getOptions()", "org.graalvm.compiler.options.OptionValues"),
        INJECTED_STAMP(new InjectedStampDependency()),
        SNIPPET_REFLECTION(new InjectedDependency("snippetReflection", "org.graalvm.compiler.api.replacements.SnippetReflectionProvider")),
        STAMP_PROVIDER("b.getStampProvider()", "org.graalvm.compiler.nodes.spi.StampProvider"),
        INTRINSIC_CONTEXT("b.getIntrinsic()", "org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext"),
        STRUCTURED_GRAPH("b.getGraph()", "org.graalvm.compiler.nodes.StructuredGraph");

        private final String expr;
        private final String type;
        protected final DependencyImpl generateMember;

        private WellKnownDependency(String expr, String type) {
            this.expr = expr;
            this.type = type;
            this.generateMember = null;
        }

        private WellKnownDependency(DependencyImpl generateMember) {
            this.expr = null;
            this.type = generateMember.getType();
            this.generateMember = generateMember;
        }

        protected TypeMirror getType(AbstractProcessor processor) {
            return processor.getType(this.type);
        }

        @Override
        public String getExpression(AbstractProcessor processor, ExecutableElement inject) {
            if (this.generateMember != null) {
                return this.generateMember.getExpression(processor, inject);
            }
            return this.expr;
        }

        @Override
        public String getName(AbstractProcessor processor, ExecutableElement inject) {
            if (this.generateMember != null) {
                return this.generateMember.getName(processor, inject);
            }
            return this.expr;
        }

        @Override
        public String getType() {
            if (this.generateMember != null) {
                return this.generateMember.getType();
            }
            return this.type;
        }
    }

    private static abstract class DependencyImpl
    implements Dependency {
        private final String name;
        private final String type;

        private DependencyImpl(String name, String type) {
            this.name = name;
            this.type = type;
        }

        @Override
        public abstract String getExpression(AbstractProcessor var1, ExecutableElement var2);

        @Override
        public String getName(AbstractProcessor processor, ExecutableElement inject) {
            return this.name;
        }

        @Override
        public String getType() {
            return this.type;
        }
    }

    public static interface Dependency {
        public String getName(AbstractProcessor var1, ExecutableElement var2);

        public String getExpression(AbstractProcessor var1, ExecutableElement var2);

        public String getType();
    }

    protected static final class InjectedDependency
    extends DependencyImpl {
        protected InjectedDependency(String name, String type) {
            super(name, type);
        }

        @Override
        public String getExpression(AbstractProcessor processor, ExecutableElement inject) {
            return String.format("injection.getInjectedArgument(%s.class)", this.getType());
        }
    }

    private static final class InjectedStampDependency
    extends DependencyImpl {
        private InjectedStampDependency() {
            super("stamp", "org.graalvm.compiler.core.common.type.Stamp");
        }

        @Override
        public String getExpression(AbstractProcessor processor, ExecutableElement inject) {
            AnnotationMirror nodeIntrinsic = processor.getAnnotation(inject, processor.getType("org.graalvm.compiler.graph.Node.NodeIntrinsic"));
            boolean nonNull = nodeIntrinsic != null && AbstractProcessor.getAnnotationValue(nodeIntrinsic, "injectedStampIsNonNull", Boolean.class) != false;
            return String.format("injection.getInjectedStamp(%s.class, %s)", GeneratedPlugin.getErasedType(inject.getReturnType()), nonNull);
        }
    }
}

