/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.config.ConfigurationMemberInfo;
import com.oracle.svm.configure.config.ConfigurationMethod;
import com.oracle.svm.configure.config.ConfigurationType;
import com.oracle.svm.configure.config.TypeConfiguration;
import com.oracle.svm.core.TypeResult;
import com.oracle.svm.core.configure.ConfigurationTypeDescriptor;
import com.oracle.svm.core.configure.NamedConfigurationTypeDescriptor;
import com.oracle.svm.core.configure.ReflectionConfigurationParserDelegate;
import java.util.List;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

public class ParserConfigurationAdapter
implements ReflectionConfigurationParserDelegate<ConfigurationType> {
    private final TypeConfiguration configuration;

    public ParserConfigurationAdapter(TypeConfiguration configuration) {
        this.configuration = configuration;
    }

    public TypeResult<ConfigurationType> resolveType(ConfigurationCondition condition, ConfigurationTypeDescriptor typeDescriptor, boolean allowPrimitives) {
        if (typeDescriptor instanceof NamedConfigurationTypeDescriptor) {
            NamedConfigurationTypeDescriptor namedDescriptor = (NamedConfigurationTypeDescriptor)typeDescriptor;
            String typeName = namedDescriptor.name();
            ConfigurationType type = this.configuration.get(condition, typeName);
            ConfigurationType result = type != null ? type : new ConfigurationType(condition, typeName);
            return TypeResult.forType((String)typeName, (Object)result);
        }
        return TypeResult.forException((String)typeDescriptor.toString(), null);
    }

    public void registerType(ConfigurationCondition condition, ConfigurationType type) {
        this.configuration.add(type);
    }

    public void registerField(ConfigurationCondition condition, ConfigurationType type, String fieldName, boolean finalButWritable) {
        type.addField(fieldName, ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT, finalButWritable);
    }

    public boolean registerAllMethodsWithName(ConfigurationCondition condition, boolean queriedOnly, ConfigurationType type, String methodName) {
        type.addMethodsWithName(methodName, ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT, queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
        return true;
    }

    public boolean registerAllConstructors(ConfigurationCondition condition, boolean queriedOnly, ConfigurationType type) {
        type.addMethodsWithName("<init>", ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT, queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
        return true;
    }

    public void registerUnsafeAllocated(ConfigurationCondition condition, ConfigurationType type) {
        type.setUnsafeAllocated();
    }

    public void registerMethod(ConfigurationCondition condition, boolean queriedOnly, ConfigurationType type, String methodName, List<ConfigurationType> methodParameterTypes) {
        type.addMethod(methodName, ConfigurationMethod.toInternalParamsSignature(methodParameterTypes), ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT, queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
    }

    public void registerConstructor(ConfigurationCondition condition, boolean queriedOnly, ConfigurationType type, List<ConfigurationType> methodParameterTypes) {
        type.addMethod("<init>", ConfigurationMethod.toInternalParamsSignature(methodParameterTypes), ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT, queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
    }

    public void registerPublicClasses(ConfigurationCondition condition, ConfigurationType type) {
        type.setAllPublicClasses();
    }

    public void registerDeclaredClasses(ConfigurationCondition condition, ConfigurationType type) {
        type.setAllDeclaredClasses();
    }

    public void registerRecordComponents(ConfigurationCondition condition, ConfigurationType type) {
        type.setAllRecordComponents();
    }

    public void registerPermittedSubclasses(ConfigurationCondition condition, ConfigurationType type) {
        type.setAllPermittedSubclasses();
    }

    public void registerNestMembers(ConfigurationCondition condition, ConfigurationType type) {
        type.setAllNestMembers();
    }

    public void registerSigners(ConfigurationCondition condition, ConfigurationType type) {
        type.setAllSigners();
    }

    public void registerPublicFields(ConfigurationCondition condition, boolean queriedOnly, ConfigurationType type) {
        type.setAllPublicFields();
    }

    public void registerDeclaredFields(ConfigurationCondition condition, boolean queriedOnly, ConfigurationType type) {
        type.setAllDeclaredFields();
    }

    public void registerPublicMethods(ConfigurationCondition condition, boolean queriedOnly, ConfigurationType type) {
        type.setAllPublicMethods(queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
    }

    public void registerDeclaredMethods(ConfigurationCondition condition, boolean queriedOnly, ConfigurationType type) {
        type.setAllDeclaredMethods(queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
    }

    public void registerPublicConstructors(ConfigurationCondition condition, boolean queriedOnly, ConfigurationType type) {
        type.setAllPublicConstructors(queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
    }

    public void registerDeclaredConstructors(ConfigurationCondition condition, boolean queriedOnly, ConfigurationType type) {
        type.setAllDeclaredConstructors(queriedOnly ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
    }

    public String getTypeName(ConfigurationType type) {
        return type.getQualifiedJavaName();
    }

    public String getSimpleName(ConfigurationType type) {
        return this.getTypeName(type);
    }
}

