/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.io;

import java.io.CharConversionException;
import java.nio.ByteBuffer;

public final class Utf8 {
    private Utf8() {
    }

    private static int utf8Size(char c) {
        if ('\u0001' <= c && c <= '\u007f') {
            return 1;
        }
        if (c <= '\u07ff') {
            return 2;
        }
        return 3;
    }

    public static int utf8Length(String string) {
        return Utf8.utf8Length(string, 0, string.length());
    }

    public static int utf8Length(String s, int beginIndex, int endIndex) {
        char c;
        long sz;
        if (beginIndex < 0 || endIndex > s.length() || beginIndex > endIndex) {
            throw new StringIndexOutOfBoundsException();
        }
        long result = 0L;
        for (int index = beginIndex; index < endIndex && result + (sz = (long)Utf8.utf8Size(c = s.charAt(index))) <= 0x7FFFFFFEL; ++index) {
            result += sz;
        }
        return (int)result;
    }

    public static void substringToUtf8(ByteBuffer dest, String source, int beginIndex, int endIndex, boolean zeroTerminate) {
        if (beginIndex < 0 || endIndex > source.length() || beginIndex > endIndex) {
            throw new StringIndexOutOfBoundsException();
        }
        for (int i = beginIndex; i < endIndex; ++i) {
            char c = source.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                dest.put((byte)c);
                continue;
            }
            if (c > '\u07ff') {
                dest.put((byte)(0xE0 | (byte)(c >> 12)));
                dest.put((byte)(0x80 | (c & 0xFC0) >> 6));
                dest.put((byte)(0x80 | c & 0x3F));
                continue;
            }
            dest.put((byte)(0xC0 | (byte)(c >> 6)));
            dest.put((byte)(0x80 | c & 0x3F));
        }
        if (zeroTerminate) {
            dest.put((byte)0);
        }
    }

    public static String utf8ToString(boolean zeroTerminated, ByteBuffer source) throws CharConversionException {
        StringBuilder sb = new StringBuilder();
        block5: while (source.hasRemaining()) {
            int c0 = source.get() & 0xFF;
            if (zeroTerminated && c0 == 0) break;
            switch (c0 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    sb.append((char)c0);
                    continue block5;
                }
                case 12: 
                case 13: {
                    byte c1 = source.get();
                    if ((c1 & 0xC0) != 128) {
                        throw new CharConversionException();
                    }
                    sb.append((char)((c0 & 0x1F) << 6 | c1 & 0x3F));
                    continue block5;
                }
                case 14: {
                    byte c1 = source.get();
                    byte c2 = source.get();
                    if ((c1 & 0xC0) != 128 || (c2 & 0xC0) != 128) {
                        throw new CharConversionException();
                    }
                    sb.append((char)((c0 & 0xF) << 12 | (c1 & 0x3F) << 6 | c2 & 0x3F));
                    continue block5;
                }
            }
            throw new CharConversionException();
        }
        return sb.toString();
    }
}

