/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.foreign;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.foreign.AbiUtils;
import com.oracle.svm.core.foreign.DowncallStubsHolder;
import com.oracle.svm.core.foreign.ForeignFunctionsRuntime;
import com.oracle.svm.core.foreign.NativeEntryPointInfo;
import com.oracle.svm.core.foreign.Target_jdk_internal_foreign_abi_NativeEntryPoint;
import com.oracle.svm.core.graal.code.AssignedLocation;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionType;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.hosted.code.NonBytecodeMethod;
import com.oracle.svm.hosted.code.SimpleSignature;
import com.oracle.svm.hosted.foreign.ForeignGraphKit;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.MethodType;
import java.util.List;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Signature;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.java.FrameStateBuilder;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunction;

@Platforms(value={Platform.HOSTED_ONLY.class})
class DowncallStub
extends NonBytecodeMethod {
    private final NativeEntryPointInfo nep;

    public static Signature createSignature(MetaAccessProvider metaAccess) {
        return SimpleSignature.fromKinds((JavaKind[])new JavaKind[]{JavaKind.Object}, (JavaKind)JavaKind.Object, (MetaAccessProvider)metaAccess);
    }

    DowncallStub(NativeEntryPointInfo nep, MetaAccessProvider metaAccess) {
        super(DowncallStubsHolder.stubName(nep), true, metaAccess.lookupJavaType(DowncallStubsHolder.class), DowncallStub.createSignature(metaAccess), DowncallStubsHolder.getConstantPool(metaAccess));
        this.nep = nep;
    }

    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        ForeignGraphKit kit = new ForeignGraphKit(debug, providers, method, purpose);
        FrameStateBuilder state = kit.getFrameState();
        boolean deoptimizationTarget = MultiMethod.isDeoptTarget((ResolvedJavaMethod)method);
        List arguments = kit.loadArguments(this.getSignature().toParameterTypes(null));
        assert (arguments.size() == 1);
        Pair<List<ValueNode>, ValueNode> argumentsAndNep = kit.unpackArgumentsAndExtractNEP((ValueNode)arguments.get(0), this.nep.methodType());
        arguments = (List)argumentsAndNep.getLeft();
        ValueNode runtimeNep = (ValueNode)argumentsAndNep.getRight();
        AbiUtils.Adapter.AdaptationResult adapted = AbiUtils.singleton().adapt(kit.unboxArguments(arguments, this.nep.methodType()), this.nep);
        ValueNode callAddress = adapted.getArgument(AbiUtils.Adapter.Extracted.CallTarget);
        SnippetRuntime.SubstrateForeignCallDescriptor captureFunction = null;
        LoadFieldNode captureMask = null;
        ValueNode captureAddress = null;
        if (this.nep.capturesCallState()) {
            captureFunction = ForeignFunctionsRuntime.CAPTURE_CALL_STATE;
            captureMask = kit.createLoadField(runtimeNep, kit.getMetaAccess().lookupJavaField(ReflectionUtil.lookupField(Target_jdk_internal_foreign_abi_NativeEntryPoint.class, (String)"captureMask")));
            captureAddress = adapted.getArgument(AbiUtils.Adapter.Extracted.CaptureBufferAddress);
        }
        state.clearLocals();
        SubstrateCallingConventionType cc = SubstrateCallingConventionType.makeCustom((boolean)true, (AssignedLocation[])adapted.parametersAssignment().toArray(new AssignedLocation[0]), (AssignedLocation[])adapted.returnsAssignment().toArray(new AssignedLocation[0]));
        CFunction.Transition transition = this.nep.skipsTransition() ? CFunction.Transition.NO_TRANSITION : CFunction.Transition.TO_NATIVE;
        ValueNode returnValue = kit.createCFunctionCallWithCapture(callAddress, adapted.arguments(), (Signature)SimpleSignature.fromMethodType((MethodType)adapted.callType(), (MetaAccessProvider)kit.getMetaAccess()), VMThreads.StatusSupport.getNewThreadStatus((CFunction.Transition)transition), deoptimizationTarget, (CallingConvention.Type)cc, (ForeignCallDescriptor)captureFunction, (ValueNode)captureMask, captureAddress);
        kit.boxAndReturn(returnValue, this.nep.methodType());
        return kit.finalizeGraph();
    }
}

