/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.foreign;

import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.foreign.AbiUtils;
import com.oracle.svm.core.foreign.NativeEntryPointInfo;
import com.oracle.svm.core.graal.code.AssignedLocation;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.headers.WindowsAPIs;
import com.oracle.svm.core.util.VMError;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import jdk.internal.foreign.abi.Binding;
import jdk.internal.foreign.abi.CallingSequence;
import jdk.internal.foreign.abi.LinkerOptions;
import jdk.internal.foreign.abi.VMStorage;
import jdk.internal.foreign.abi.x64.sysv.CallArranger;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

class ABIs {
    ABIs() {
    }

    static final class Win64
    extends X86_64 {
        Win64() {
        }

        @Override
        protected CallingSequence makeCallingSequence(MethodType type, FunctionDescriptor desc, boolean forUpcall, LinkerOptions options) {
            return jdk.internal.foreign.abi.x64.windows.CallArranger.getBindings(type, desc, forUpcall, options).callingSequence();
        }

        @Override
        protected List<AbiUtils.Adapter.Adaptation> generateAdaptations(NativeEntryPointInfo nep) {
            List<AbiUtils.Adapter.Adaptation> adaptations = super.generateAdaptations(nep);
            AMD64 target = (AMD64)((SubstrateTargetDescription)ImageSingletons.lookup(SubstrateTargetDescription.class)).arch;
            boolean previousMatched = false;
            PlatformKind previousKind = null;
            for (int i = adaptations.size() - 1; i >= 0; --i) {
                PlatformKind kind = target.getPlatformKind(JavaKind.fromJavaClass((Class)nep.methodType().parameterType(i)));
                if ((kind.equals((Object)target.getPlatformKind(JavaKind.Float)) || kind.equals((Object)target.getPlatformKind(JavaKind.Double))) && nep.parametersAssignment()[i].type() == 0) {
                    assert (Objects.equals(previousKind, kind) && previousMatched);
                    assert (adaptations.get(i) == null);
                    adaptations.set(i, AbiUtils.Adapter.reinterpret(JavaKind.Long));
                    previousMatched = false;
                } else {
                    previousMatched = true;
                }
                previousKind = kind;
            }
            return adaptations;
        }

        @Override
        @Platforms(value={Platform.HOSTED_ONLY.class})
        public void checkLibrarySupport() {
            String name = "Win64 (Windows AMD64)";
            VMError.guarantee((boolean)LibC.isSupported(), (String)("Foreign functions feature requires LibC support on" + name));
            VMError.guarantee((boolean)WindowsAPIs.isSupported(), (String)("Foreign functions feature requires Windows APIs support on" + name));
        }

        @Override
        public Map<String, MemoryLayout> canonicalLayouts() {
            return Win64.canonicalLayouts(ValueLayout.JAVA_INT, ValueLayout.JAVA_LONG, ValueLayout.JAVA_CHAR);
        }
    }

    static final class SysV
    extends X86_64 {
        SysV() {
        }

        @Override
        protected CallingSequence makeCallingSequence(MethodType type, FunctionDescriptor desc, boolean forUpcall, LinkerOptions options) {
            return CallArranger.getBindings(type, desc, forUpcall, options).callingSequence();
        }

        @Override
        protected List<AbiUtils.Adapter.Adaptation> generateAdaptations(NativeEntryPointInfo nep) {
            List<AbiUtils.Adapter.Adaptation> adaptations = super.generateAdaptations(nep);
            assert (adaptations.get(adaptations.size() - 1) == null);
            adaptations.set(adaptations.size() - 1, AbiUtils.Adapter.drop());
            return adaptations;
        }

        @Override
        @Platforms(value={Platform.HOSTED_ONLY.class})
        public void checkLibrarySupport() {
            String name = "SystemV (Linux AMD64)";
            VMError.guarantee((boolean)LibC.isSupported(), (String)("Foreign functions feature requires LibC support on " + name));
        }

        @Override
        public Map<String, MemoryLayout> canonicalLayouts() {
            return SysV.canonicalLayouts(ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT);
        }
    }

    private static abstract class X86_64
    extends AbiUtils {
        private X86_64() {
        }

        protected abstract CallingSequence makeCallingSequence(MethodType var1, FunctionDescriptor var2, boolean var3, LinkerOptions var4);

        @Override
        public NativeEntryPointInfo makeNativeEntrypoint(FunctionDescriptor desc, Linker.Option ... options) {
            LinkerOptions optionSet = LinkerOptions.forDowncall(desc, options);
            MethodType type = desc.toMethodType();
            CallingSequence callingSequence = this.makeCallingSequence(type, desc, false, optionSet);
            VMStorage[] argMoves = Downcalls.toStorageArray((Binding.Move[])Downcalls.argMoveBindingsStream(callingSequence).toArray(Binding.VMStore[]::new));
            VMStorage[] returnMoves = Downcalls.toStorageArray(Downcalls.retMoveBindings(callingSequence));
            MethodType boundaryType = callingSequence.calleeMethodType();
            boolean needsReturnBuffer = callingSequence.needsReturnBuffer();
            return NativeEntryPointInfo.make(argMoves, returnMoves, boundaryType, needsReturnBuffer, callingSequence.capturedStateMask(), callingSequence.needsTransition());
        }

        @Override
        public AssignedLocation[] toMemoryAssignment(VMStorage[] argMoves, boolean forReturn) {
            block10: for (VMStorage move : argMoves) {
                switch (move.type()) {
                    case 2: {
                        throw VMError.unsupportedFeature((String)"Unsupported register kind: X87");
                    }
                    case 3: {
                        if (!forReturn) continue block10;
                        throw VMError.unsupportedFeature((String)"Unsupported register kind for return: STACK");
                    }
                }
            }
            AssignedLocation[] storages = new AssignedLocation[argMoves.length];
            int i = 0;
            for (VMStorage move : argMoves) {
                int n = i++;
                storages[n] = switch (move.type()) {
                    case 4 -> AssignedLocation.placeholder();
                    case 0 -> {
                        Register reg = AMD64.cpuRegisters[move.indexOrOffset()];
                        if (!$assertionsDisabled && !reg.name.equals(move.debugName())) {
                            throw new AssertionError();
                        }
                        if (!$assertionsDisabled && !reg.getRegisterCategory().equals((Object)AMD64.CPU)) {
                            throw new AssertionError();
                        }
                        yield AssignedLocation.forRegister((Register)reg);
                    }
                    case 1 -> {
                        Register reg = AMD64.xmmRegistersSSE[move.indexOrOffset()];
                        if (!$assertionsDisabled && !reg.name.equals(move.debugName())) {
                            throw new AssertionError();
                        }
                        if (!$assertionsDisabled && !reg.getRegisterCategory().equals((Object)AMD64.XMM)) {
                            throw new AssertionError();
                        }
                        yield AssignedLocation.forRegister((Register)reg);
                    }
                    case 3 -> AssignedLocation.forStack((int)move.indexOrOffset());
                    default -> throw VMError.unsupportedFeature((String)("Unhandled VMStorage: " + String.valueOf(move)));
                };
            }
            assert (i == storages.length);
            return storages;
        }

        protected static Map<String, MemoryLayout> canonicalLayouts(ValueLayout longLayout, ValueLayout sizetLayout, ValueLayout wchartLayout) {
            return Map.ofEntries(Map.entry("bool", ValueLayout.JAVA_BOOLEAN), Map.entry("char", ValueLayout.JAVA_BYTE), Map.entry("short", ValueLayout.JAVA_SHORT), Map.entry("int", ValueLayout.JAVA_INT), Map.entry("float", ValueLayout.JAVA_FLOAT), Map.entry("long", longLayout), Map.entry("long long", ValueLayout.JAVA_LONG), Map.entry("double", ValueLayout.JAVA_DOUBLE), Map.entry("void*", ValueLayout.ADDRESS), Map.entry("size_t", sizetLayout), Map.entry("wchar_t", wchartLayout), Map.entry("int8_t", ValueLayout.JAVA_BYTE), Map.entry("int16_t", ValueLayout.JAVA_SHORT), Map.entry("int32_t", ValueLayout.JAVA_INT), Map.entry("int64_t", ValueLayout.JAVA_LONG), Map.entry("jboolean", ValueLayout.JAVA_BOOLEAN), Map.entry("jchar", ValueLayout.JAVA_CHAR), Map.entry("jbyte", ValueLayout.JAVA_BYTE), Map.entry("jshort", ValueLayout.JAVA_SHORT), Map.entry("jint", ValueLayout.JAVA_INT), Map.entry("jlong", ValueLayout.JAVA_LONG), Map.entry("jfloat", ValueLayout.JAVA_FLOAT), Map.entry("jdouble", ValueLayout.JAVA_DOUBLE));
        }

        static class Downcalls {
            Downcalls() {
            }

            protected static Stream<Binding.VMStore> argMoveBindingsStream(CallingSequence callingSequence) {
                return callingSequence.argumentBindings().filter(Binding.VMStore.class::isInstance).map(Binding.VMStore.class::cast);
            }

            protected static Stream<Binding.VMLoad> retMoveBindingsStream(CallingSequence callingSequence) {
                return callingSequence.returnBindings().stream().filter(Binding.VMLoad.class::isInstance).map(Binding.VMLoad.class::cast);
            }

            protected static Binding.VMLoad[] retMoveBindings(CallingSequence callingSequence) {
                return (Binding.VMLoad[])Downcalls.retMoveBindingsStream(callingSequence).toArray(Binding.VMLoad[]::new);
            }

            protected static VMStorage[] toStorageArray(Binding.Move[] moves) {
                return (VMStorage[])Arrays.stream(moves).map(Binding.Move::storage).toArray(VMStorage[]::new);
            }
        }
    }

    static final class Unsupported
    extends AbiUtils {
        private final String name;

        Unsupported(String name) {
            this.name = name;
        }

        private <Z> Z fail() {
            throw VMError.unsupportedFeature((String)this.name());
        }

        private String name() {
            return "Unsupported ABI: " + this.name;
        }

        @Override
        public NativeEntryPointInfo makeNativeEntrypoint(FunctionDescriptor desc, Linker.Option ... options) {
            return (NativeEntryPointInfo)this.fail();
        }

        @Override
        public AssignedLocation[] toMemoryAssignment(VMStorage[] moves, boolean forReturn) {
            return (AssignedLocation[])this.fail();
        }

        @Override
        protected List<AbiUtils.Adapter.Adaptation> generateAdaptations(NativeEntryPointInfo nep) {
            return (List)this.fail();
        }

        @Override
        public void checkLibrarySupport() {
            this.fail();
        }

        @Override
        public Map<String, MemoryLayout> canonicalLayouts() {
            return (Map)this.fail();
        }
    }
}

