/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver;

import com.oracle.svm.core.OS;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.driver.MacroOption;
import com.oracle.svm.driver.NativeImage;
import java.io.File;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Objects;

class MacroOptionHandler
extends NativeImage.OptionHandler<NativeImage> {
    private final HashSet<MacroOption> addedCheck = new HashSet();
    private static final String PATH_SEPARATOR_REGEX = OS.WINDOWS.isCurrent() ? ":|;" : File.pathSeparator;

    MacroOptionHandler(NativeImage nativeImage) {
        super(nativeImage);
    }

    @Override
    public boolean consume(NativeImage.ArgumentQueue args) {
        String headArg = args.peek();
        boolean consumed = false;
        try {
            consumed = this.nativeImage.optionRegistry.enableOption(this.nativeImage.config, headArg, this.addedCheck, null, enabledOption -> this.applyEnabled((MacroOption.EnabledOption)enabledOption, args.argumentOrigin));
        }
        catch (MacroOption.VerboseInvalidMacroException e1) {
            NativeImage.showError(e1.getMessage(this.nativeImage.optionRegistry));
        }
        catch (OptionUtils.InvalidMacroException | MacroOption.AddedTwiceException e) {
            NativeImage.showError(e.getMessage());
        }
        catch (NativeImage.NativeImageError err) {
            NativeImage.showError("Applying MacroOption " + headArg + " failed", err);
        }
        if (consumed) {
            args.poll();
        }
        return consumed;
    }

    private void applyEnabled(MacroOption.EnabledOption enabledOption, String argumentOrigin) {
        String imageModule;
        String imageClass;
        String imagePath;
        String imageName;
        Path imageJarsDirectory = enabledOption.getOption().getOptionDirectory();
        if (imageJarsDirectory == null) {
            return;
        }
        NativeImage.BuildConfiguration config = this.nativeImage.config;
        boolean ignoreIfBuilderOnClasspath = Boolean.parseBoolean(enabledOption.getProperty(config, "IgnoreIfBuilderOnClasspath"));
        if (ignoreIfBuilderOnClasspath && !config.modulePathBuild) {
            return;
        }
        String propertyName = "BuilderOnClasspath";
        String propertyValue = enabledOption.getProperty(config, propertyName);
        if (propertyValue != null) {
            boolean modulePathBuild = Boolean.valueOf(propertyValue) == false;
            String imageBuilderModeEnforcer = enabledOption.getOption().toString();
            if (config.imageBuilderModeEnforcer != null && modulePathBuild != config.modulePathBuild) {
                NativeImage.showError(String.format("Conflicting %s property values. %s (%b) vs %s (%b)", propertyName, imageBuilderModeEnforcer, modulePathBuild, config.imageBuilderModeEnforcer, config.modulePathBuild));
            }
            config.imageBuilderModeEnforcer = imageBuilderModeEnforcer;
            config.modulePathBuild = modulePathBuild;
        }
        enabledOption.forEachPropertyValue(config, "ImageBuilderClasspath", entry -> this.nativeImage.addImageBuilderClasspath(Path.of(entry, new String[0])), PATH_SEPARATOR_REGEX);
        enabledOption.forEachPropertyValue(config, "ImageBuilderModulePath", entry -> this.nativeImage.addImageBuilderModulePath(Path.of(entry, new String[0])), PATH_SEPARATOR_REGEX);
        boolean explicitImageModulePath = enabledOption.forEachPropertyValue(config, "ImageModulePath", entry -> this.nativeImage.addImageModulePath(Path.of(entry, new String[0])), PATH_SEPARATOR_REGEX);
        boolean explicitImageClasspath = enabledOption.forEachPropertyValue(config, "ImageClasspath", entry -> NativeImage.expandAsteriskClassPathElement(entry).forEach(this.nativeImage::addImageClasspath), PATH_SEPARATOR_REGEX);
        if (!explicitImageModulePath && !explicitImageClasspath) {
            NativeImage.getJars(imageJarsDirectory, new String[0]).forEach(this.nativeImage::addImageClasspath);
        }
        if ((imageName = enabledOption.getProperty(config, "ImageName")) != null) {
            this.nativeImage.addPlainImageBuilderArg(this.nativeImage.oHName + imageName);
        }
        if ((imagePath = enabledOption.getProperty(config, "ImagePath")) != null) {
            this.nativeImage.addPlainImageBuilderArg(this.nativeImage.oHPath + imagePath);
        }
        if ((imageClass = enabledOption.getProperty(config, "ImageClass")) != null) {
            this.nativeImage.addPlainImageBuilderArg(this.nativeImage.oHClass + imageClass);
        }
        if ((imageModule = enabledOption.getProperty(config, "ImageModule")) != null) {
            this.nativeImage.addPlainImageBuilderArg(this.nativeImage.oHModule + imageModule);
        }
        enabledOption.forEachPropertyValue(config, "JavaArgs", xva$0 -> this.nativeImage.addImageBuilderJavaArgs((String)xva$0));
        Object origin = enabledOption.getOption().getDescription(true);
        origin = (String)origin + "@" + String.valueOf(enabledOption.getOption().getOptionDirectory().toUri());
        if (argumentOrigin != null) {
            origin = (String)origin + "@" + argumentOrigin;
        }
        NativeImage nativeImage = this.nativeImage;
        Objects.requireNonNull(nativeImage);
        NativeImage.NativeImageArgsProcessor args = nativeImage.new NativeImage.NativeImageArgsProcessor((String)origin);
        enabledOption.forEachPropertyValue(config, "Args", args);
        args.apply(true);
    }
}

