/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.MultiRelease;
import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.fips.CryptoOp;
import com.oracle.jipher.internal.fips.Fips;
import com.oracle.jipher.internal.openssl.MacCtx;
import com.oracle.jipher.internal.openssl.MdAlg;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;

public abstract class Hmac
extends MacSpi
implements Cloneable {
    private State state;
    private Object cleanable;
    final int macLen;
    final MdAlg mdAlg;
    private MacCtx ctx;

    Hmac(MdAlg mdAlg, int macLen) {
        this.mdAlg = mdAlg;
        this.macLen = macLen;
    }

    @Override
    protected int engineGetMacLength() {
        return this.macLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cleanup();
        if (this.state != null) {
            MultiRelease.clean(this.cleanable);
            this.state = null;
            this.cleanable = null;
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Expected SecretKey");
        }
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("Did not expect parameters");
        }
        byte[] kb = key.getEncoded();
        try {
            Fips.enforcement().checkStrength(CryptoOp.MAC, "HMAC", kb.length * 8);
            this.initInternal(kb);
            this.state = new State(kb);
            this.cleanable = MultiRelease.CLEANER_INSTANCE.register(this, this.state);
            kb = null;
        }
        finally {
            Util.clearArray(kb);
        }
    }

    private void initInternal(byte[] key) throws InvalidKeyException {
        this.ctx = new MacCtx.Hmac(this.mdAlg);
        this.ctx.init(key);
    }

    private void resetIfNecessary() {
        if (this.ctx == null) {
            if (this.state == null) {
                throw new IllegalStateException("Not initialized");
            }
            try {
                this.initInternal(this.state.keyData);
                MultiRelease.reachabilityFence(this);
            }
            catch (InvalidKeyException e) {
                throw new ProviderException("Unexpected exception", e);
            }
        }
    }

    @Override
    protected void engineUpdate(byte b) {
        this.engineUpdate(new byte[]{b}, 0, 1);
    }

    @Override
    protected void engineUpdate(byte[] bytes, int offset, int len) {
        this.resetIfNecessary();
        this.ctx.update(bytes, offset, len);
    }

    @Override
    protected void engineReset() {
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] engineDoFinal() {
        this.resetIfNecessary();
        try {
            byte[] output = new byte[this.macLen];
            int len = this.ctx.mac(output, 0);
            if (output.length == len) {
                byte[] byArray = output;
                return byArray;
            }
            byte[] byArray = Arrays.copyOf(output, len);
            return byArray;
        }
        finally {
            this.cleanup();
        }
    }

    private void cleanup() {
        if (this.ctx != null) {
            this.ctx.free();
            this.ctx = null;
        }
    }

    public static class HmacSha512
    extends Hmac {
        public HmacSha512() {
            super(MdAlg.SHA512, 64);
        }
    }

    public static class HmacSha384
    extends Hmac {
        public HmacSha384() {
            super(MdAlg.SHA384, 48);
        }
    }

    public static class HmacSha256
    extends Hmac {
        public HmacSha256() {
            super(MdAlg.SHA256, 32);
        }
    }

    public static class HmacSha224
    extends Hmac {
        public HmacSha224() {
            super(MdAlg.SHA224, 28);
        }
    }

    public static class HmacSha1
    extends Hmac {
        public HmacSha1() {
            super(MdAlg.SHA1, 20);
        }
    }

    static final class State
    implements Runnable {
        final byte[] keyData;

        State(byte[] keyData) {
            this.keyData = keyData;
        }

        @Override
        public final void run() {
            Util.clearArray(this.keyData);
        }
    }
}

