/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.tools.asn1.Asn1;
import com.oracle.jipher.internal.tools.asn1.Asn1BerValue;
import com.oracle.jipher.internal.tools.asn1.Asn1DecodeException;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.List;

public final class DsaParameters
extends AlgorithmParametersSpi {
    private DSAParameterSpec spec;

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> paramSpec) throws InvalidParameterSpecException {
        if (paramSpec == DSAParameterSpec.class) {
            return (T)((AlgorithmParameterSpec)paramSpec.cast(this.spec));
        }
        throw new InvalidParameterSpecException("Invalid parameter spec class");
    }

    @Override
    protected void engineInit(byte[] params) throws IOException {
        try {
            Asn1BerValue dsaParams = Asn1.decodeOne(params);
            Util.assertAllUniversal(dsaParams);
            List<Asn1BerValue> dsaPValues = dsaParams.count(3).sequence();
            this.spec = new DSAParameterSpec(dsaPValues.get(0).getInteger(), dsaPValues.get(1).getInteger(), dsaPValues.get(2).getInteger());
        }
        catch (Asn1DecodeException ex) {
            throw new IOException("Invalid DSA parameters", ex);
        }
    }

    @Override
    protected void engineInit(byte[] params, String format) throws IOException {
        this.engineInit(params);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof DSAParameterSpec)) {
            throw new InvalidParameterSpecException("Invalid parameter spec for DSA parameters");
        }
        this.spec = (DSAParameterSpec)paramSpec;
    }

    @Override
    protected String engineToString() {
        return "DSA Parameters (P=" + Util.bytesToHex(this.spec.getP().toByteArray()) + ",Q=" + Util.bytesToHex(this.spec.getQ().toByteArray()) + ",G =" + Util.bytesToHex(this.spec.getG().toByteArray()) + ")";
    }

    @Override
    protected byte[] engineGetEncoded() {
        Asn1BerValue dsaParams = Asn1.newSequence(Asn1.newInteger(this.spec.getP()), Asn1.newInteger(this.spec.getQ()), Asn1.newInteger(this.spec.getG()));
        return dsaParams.encodeDerOctets();
    }

    @Override
    protected byte[] engineGetEncoded(String format) {
        return this.engineGetEncoded();
    }
}

