/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.openssl.MdAlg;
import com.oracle.jipher.internal.spi.AsymKeyFactory;
import com.oracle.jipher.internal.spi.DigestSignature;
import com.oracle.jipher.internal.spi.DsaKeyFactory;

public abstract class DsaDigestSig
extends DigestSignature {
    DsaDigestSig(MdAlg md) {
        super(md);
    }

    @Override
    AsymKeyFactory getKeyFactory() {
        return new DsaKeyFactory();
    }

    public static final class Sha512WithDsa
    extends DsaDigestSig {
        public Sha512WithDsa() {
            super(MdAlg.SHA512);
        }
    }

    public static final class Sha384WithDsa
    extends DsaDigestSig {
        public Sha384WithDsa() {
            super(MdAlg.SHA384);
        }
    }

    public static final class Sha256WithDsa
    extends DsaDigestSig {
        public Sha256WithDsa() {
            super(MdAlg.SHA256);
        }
    }

    public static final class Sha224WithDsa
    extends DsaDigestSig {
        public Sha224WithDsa() {
            super(MdAlg.SHA224);
        }
    }

    public static final class Sha1WithDsa
    extends DsaDigestSig {
        public Sha1WithDsa() {
            super(MdAlg.SHA1);
        }
    }
}

