/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.openssl;

import com.oracle.jipher.internal.common.Debug;
import com.oracle.jipher.internal.openssl.OpenSsl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class OpenSslDebug {
    public static OpenSsl newProxyInstance(OpenSsl ossl) {
        return (OpenSsl)Proxy.newProxyInstance(OpenSsl.class.getClassLoader(), new Class[]{OpenSsl.class}, (InvocationHandler)new Handler(ossl));
    }

    static class Handler
    implements InvocationHandler {
        private static final Debug DEBUG = Debug.getInstance("jni");
        private final OpenSsl ossl;

        Handler(OpenSsl ossl) {
            this.ossl = ossl;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            DEBUG.println("Calling native method " + method.getName());
            try {
                return method.invoke((Object)this.ossl, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getCause();
            }
        }
    }
}

