/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.fips;

import com.oracle.jipher.internal.common.Debug;
import com.oracle.jipher.internal.common.ToolkitProperties;
import com.oracle.jipher.internal.fips.CryptoOp;
import com.oracle.jipher.internal.fips.Policy;
import com.oracle.jipher.internal.openssl.MdAlg;

public class Fips {
    static final Debug DEBUG = Debug.getInstance("jipher");
    public static final String POLICY_FIPS = "FIPS";
    private static final String POLICY_NONE = "NONE";
    private static final String POLICY_FIPS_STRICT = "FIPS_STRICT";
    private static final Policy ENFORCER = Fips.initPolicy();

    private Fips() {
    }

    public static Policy enforcement() {
        return ENFORCER;
    }

    private static Policy initPolicy() {
        Policy policy = ToolkitProperties.getFipsEnforcementValue().equalsIgnoreCase(POLICY_NONE) ? Fips.none() : (ToolkitProperties.getFipsEnforcementValue().equalsIgnoreCase(POLICY_FIPS_STRICT) ? Fips.fipsStrictPolicy() : Fips.fipsPolicy());
        DEBUG.println("Setting FIPS enforcement policy = " + policy.getPolicyName());
        return policy;
    }

    private static boolean isValidDsaLens(int ... sizes) {
        if (sizes.length == 2) {
            return Fips.isValidDsaPQlen(sizes[0], sizes[1]);
        }
        if (sizes.length == 1) {
            return sizes[0] >= 2048;
        }
        throw new IllegalArgumentException("Wrong number of sizes for checking valid DSA lengths.");
    }

    private static boolean isValidDsaPQlen(int plen, int qlen) {
        if (plen == 2048) {
            return qlen == 224 || qlen == 256;
        }
        return plen == 3072 && qlen == 256;
    }

    static Policy fipsStrictPolicy() {
        return new Policy.Builder(POLICY_FIPS_STRICT).strengthRule("RSA", keyBits -> (Integer)keyBits >= 2048, CryptoOp.ASYM_CIPH, CryptoOp.KEYGEN, CryptoOp.SIGN, CryptoOp.VERIFY).strengthRule("EC", curveBits -> (Integer)curveBits >= 224, CryptoOp.KEYGEN, CryptoOp.SIGN, CryptoOp.VERIFY, CryptoOp.KEYAGREE).strengthRule("DSA", paramBits -> Fips.isValidDsaLens((int[])paramBits), CryptoOp.KEYGEN, CryptoOp.SIGN, CryptoOp.VERIFY).strengthRule("DH", keyBits -> (Integer)keyBits >= 2048, CryptoOp.KEYAGREE, CryptoOp.KEYGEN).strengthRule("HMAC", keyBits -> (Integer)keyBits >= 112, CryptoOp.MAC).strengthRule("AES", keyBits -> (Integer)keyBits >= 128, CryptoOp.ENCRYPT_SYM, CryptoOp.DECRYPT_SYM).strengthRule("DESede", keyBits -> (Integer)keyBits == 192, CryptoOp.ENCRYPT_SYM, CryptoOp.DECRYPT_SYM).algRule(mdAlg -> !MdAlg.SHA1.getAlg().equals(mdAlg), CryptoOp.SIGN, CryptoOp.VERIFY).build();
    }

    static Policy fipsPolicy() {
        return new Policy.Builder(POLICY_FIPS).strengthRule("RSA", keyBits -> (Integer)keyBits >= 2048, CryptoOp.ASYM_CIPH, CryptoOp.KEYGEN, CryptoOp.SIGN).strengthRule("RSA", keyBits -> (Integer)keyBits >= 1024, CryptoOp.VERIFY).strengthRule("EC", curveBits -> (Integer)curveBits >= 224, CryptoOp.KEYGEN, CryptoOp.SIGN, CryptoOp.KEYAGREE).strengthRule("EC", curveBits -> (Integer)curveBits >= 160, CryptoOp.VERIFY).strengthRule("DSA", paramBits -> Fips.isValidDsaLens((int[])paramBits), CryptoOp.KEYGEN, CryptoOp.SIGN).strengthRule("DSA", paramBits -> ((int[])paramBits)[0] >= 512, CryptoOp.VERIFY).strengthRule("DH", keyBits -> (Integer)keyBits >= 2048, CryptoOp.KEYAGREE, CryptoOp.KEYGEN).strengthRule("HMAC", keyBits -> (Integer)keyBits >= 0, CryptoOp.MAC).strengthRule("AES", keyBits -> (Integer)keyBits >= 128, CryptoOp.ENCRYPT_SYM, CryptoOp.DECRYPT_SYM).strengthRule("DESede", keyBits -> (Integer)keyBits == 192, CryptoOp.ENCRYPT_SYM, CryptoOp.DECRYPT_SYM).algRule(mdAlg -> !MdAlg.SHA1.getAlg().equals(mdAlg), CryptoOp.SIGN).build();
    }

    static Policy none() {
        return new Policy.Builder(POLICY_NONE).build();
    }
}

