/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.posix.PosixVMSemaphoreSupport;
import com.oracle.svm.core.posix.linux.LinuxVMSemaphore;

final class LinuxVMSemaphoreSupport
extends PosixVMSemaphoreSupport {
    @UnknownObjectField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    LinuxVMSemaphore[] semaphores;

    LinuxVMSemaphoreSupport() {
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code. Too early for safepoints.")
    public boolean initialize() {
        for (LinuxVMSemaphore semaphore : this.semaphores) {
            if (semaphore.init() == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    @Uninterruptible(reason="The isolate teardown is in progress.")
    public void destroy() {
        for (LinuxVMSemaphore semaphore : this.semaphores) {
            semaphore.destroy();
        }
    }

    public LinuxVMSemaphore[] getSemaphores() {
        return this.semaphores;
    }
}

