/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.truffle;

import com.oracle.graal.compiler.enterprise.q;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.enterprise.truffle.EnterpriseTruffleBaseFeature;
import com.oracle.svm.enterprise.truffle.g;
import com.oracle.svm.enterprise.truffle.v;
import com.oracle.svm.graal.hosted.RuntimeCompilationFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.truffle.TruffleFeature;
import com.oracle.svm.truffle.TruffleSupport;
import com.oracle.svm.truffle.api.SubstrateTruffleRuntime;
import com.oracle.truffle.runtime.EngineCacheSupport;
import java.util.List;
import java.util.function.BooleanSupplier;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

public final class EnterpriseTruffleFeature
implements InternalFeature {
    static boolean j() {
        return ImageSingletons.contains(EnterpriseTruffleFeature.class);
    }

    public String getDescription() {
        return "Provides enterprise extensions for Truffle runtime compilation";
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess isInConfigurationAccess) {
        return TruffleFeature.isInConfiguration() && isInConfigurationAccess.findClassByName("com.oracle.truffle.runtime.enterprise.EnterpriseTruffle") != null;
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return List.of(EnterpriseTruffleBaseFeature.class, TruffleFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess afterRegistrationAccess) {
        if (!EnterpriseTruffleFeature.j()) {
            return;
        }
        ImageSingletons.add(TruffleSupport.class, (Object)((Object)new g()));
        SubstrateTruffleRuntime substrateTruffleRuntime = (SubstrateTruffleRuntime)SubstrateTruffleRuntime.getRuntime();
        substrateTruffleRuntime.initializeEngineCacheSupport((EngineCacheSupport)new com.oracle.svm.enterprise.truffle.a());
    }

    public void registerInvocationPlugins(Providers providers, SnippetReflectionProvider snippetReflectionProvider, GraphBuilderConfiguration.Plugins plugins, ParsingReason parsingReason) {
        Architecture architecture = providers.getLowerer().getTarget().arch;
        if (architecture instanceof AMD64 || architecture instanceof AArch64) {
            q.a((Architecture)architecture, (InvocationPlugins)plugins.getInvocationPlugins(), (Replacements)providers.getReplacements());
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess beforeAnalysisAccess) {
        if (!EnterpriseTruffleFeature.j()) {
            return;
        }
        FeatureImpl.BeforeAnalysisAccessImpl beforeAnalysisAccessImpl = (FeatureImpl.BeforeAnalysisAccessImpl)beforeAnalysisAccess;
        v.a((MetaAccessProvider)beforeAnalysisAccessImpl.getMetaAccess());
        v.singleton().b(beforeAnalysisAccessImpl);
        v.singleton().a((Feature.BeforeAnalysisAccess)beforeAnalysisAccessImpl);
        RuntimeCompilationFeature runtimeCompilationFeature = RuntimeCompilationFeature.singleton();
        for (ResolvedJavaMethod resolvedJavaMethod : v.singleton().ak.values()) {
            runtimeCompilationFeature.prepareMethodForRuntimeCompilation(resolvedJavaMethod, beforeAnalysisAccessImpl);
        }
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess beforeCompilationAccess) {
        if (!EnterpriseTruffleFeature.j()) {
            return;
        }
        v v2 = v.singleton();
        v2.a((Feature.CompilationAccess)beforeCompilationAccess);
        beforeCompilationAccess.registerAsImmutable((Object)v2);
    }

    static final class a
    implements BooleanSupplier {
        a() {
        }

        @Override
        public boolean getAsBoolean() {
            return EnterpriseTruffleFeature.j();
        }
    }
}

