/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.truffle;

import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.truffle.TruffleBaseFeature;
import java.util.function.BooleanSupplier;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

public class EnterpriseTruffleBaseFeature
implements InternalFeature {
    public String getDescription() {
        return "Provides enterprise extensions for Truffle";
    }

    static boolean j() {
        try {
            Class.forName("com.oracle.truffle.runtime.enterprise.EnterpriseTruffle");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return ImageSingletons.contains(TruffleBaseFeature.class);
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess isInConfigurationAccess) {
        return isInConfigurationAccess.findClassByName("com.oracle.truffle.runtime.enterprise.EnterpriseTruffle") != null;
    }

    public void duringSetup(Feature.DuringSetupAccess duringSetupAccess) {
        if (!EnterpriseTruffleBaseFeature.j()) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("com.oracle.truffle.object.enterprise.UnsafeAccess");
            AnalysisType analysisType = ((FeatureImpl.DuringSetupAccessImpl)duringSetupAccess).getMetaAccess().lookupJavaType(clazz);
            analysisType.registerAsReachable((Object)"used by TruffleEnterpriseInvocationPlugins");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw VMError.shouldNotReachHere((Throwable)classNotFoundException);
        }
    }

    public static final class a
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return EnterpriseTruffleBaseFeature.j();
        }
    }
}

