/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.truffle.TruffleBaseFeature;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.collections.Pair;

@TargetClass(className="com.oracle.truffle.api.staticobject.StaticShape", innerClass={"Builder"}, onlyWith={TruffleBaseFeature.IsEnabled.class})
final class Target_com_oracle_truffle_api_staticobject_StaticShape_Builder {
    Target_com_oracle_truffle_api_staticobject_StaticShape_Builder() {
    }

    @Substitute
    static void validateClasses(Class<?> storageSuperClass, Class<?> storageFactoryInterface) {
        IllegalArgumentException exception = ExceptionCache.get(storageSuperClass, storageFactoryInterface);
        if (exception != null) {
            throw new IllegalArgumentException(exception.getMessage(), exception);
        }
    }

    static final class ExceptionCache {
        private static final ConcurrentHashMap<Pair<Class<?>, Class<?>>, IllegalArgumentException> cache = new ConcurrentHashMap();

        ExceptionCache() {
        }

        static IllegalArgumentException get(Class<?> storageSuperClass, Class<?> storageFactoryInterface) {
            return cache.get(Pair.create(storageSuperClass, storageFactoryInterface));
        }

        static void set(Class<?> storageSuperClass, Class<?> storageFactoryInterface, IllegalArgumentException e) {
            cache.putIfAbsent(Pair.create(storageSuperClass, storageFactoryInterface), e);
        }
    }
}

