/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.profiling.profiles;

import com.oracle.svm.enterprise.profiling.collect.e;
import com.oracle.svm.enterprise.profiling.data.l;
import com.oracle.svm.enterprise.profiling.kinds.c;
import com.oracle.svm.enterprise.profiling.kinds.d;
import com.oracle.svm.enterprise.profiling.loaders.ProfilingLoader;
import com.oracle.svm.enterprise.profiling.m;
import com.oracle.svm.enterprise.profiling.metadata.a;
import com.oracle.svm.enterprise.profiling.metadata.b;
import com.oracle.svm.enterprise.profiling.r;
import com.oracle.svm.util.LogUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.graalvm.collections.Pair;

public abstract class ProfilingBaseProfile {
    protected l profilingData;
    protected a profilingMetadata;

    protected ProfilingBaseProfile() {
    }

    protected ProfilingBaseProfile(a a2, l l2) {
        this.profilingMetadata = a2;
        this.profilingData = l2;
    }

    public ProfilingBaseProfile normalize(long l2) {
        List<Map<String, com.oracle.svm.enterprise.profiling.metadata.cctree.c>> list = this.findAllNodesWithStringContext();
        long l3 = this.findSums(list.get(d.zu.gN()));
        double d2 = (double)l2 / (double)l3;
        for (Map<String, com.oracle.svm.enterprise.profiling.metadata.cctree.c> map : list) {
            map.forEach((string, c2) -> c2.a(this.profilingData, d2));
        }
        return this;
    }

    public ProfilingBaseProfile merge(ProfilingBaseProfile profilingBaseProfile) {
        com.oracle.svm.enterprise.profiling.data.m m2 = new com.oracle.svm.enterprise.profiling.data.m();
        b b2 = new b();
        this.merge0(b2, m2);
        profilingBaseProfile.merge0(b2, m2);
        return this.newInstance(b2.gV(), m2);
    }

    public void dump(OutputStream outputStream) throws IOException {
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);){
            outputStreamWriter.append("{\"version\":\"").append("0.4.0").append("\"");
            outputStreamWriter.append(",\"types\":[");
            this.profilingMetadata.gR().a(outputStreamWriter);
            outputStreamWriter.append("],\"methods\":[");
            this.profilingMetadata.gS().a(outputStreamWriter);
            List<List<com.oracle.svm.enterprise.profiling.metadata.cctree.c>> list = this.findLeafNodes();
            for (d d2 : d.values()) {
                outputStreamWriter.append("],\"").append(d2.getName()).append("\":[");
                if (d2.gN() == d.zw.gN() && list.get(d2.gN()).isEmpty()) {
                    ProfilingBaseProfile.dumpSamples(r.gt(), outputStreamWriter);
                    continue;
                }
                this.dump(list.get(d2.gN()), outputStreamWriter);
            }
            outputStreamWriter.append("]}");
            outputStreamWriter.flush();
        }
    }

    protected <T, M> a buildMetadata(ProfilingLoader<T, M> profilingLoader, e e2, com.oracle.svm.enterprise.profiling.adapters.b<T, M> b2) {
        b b3 = new b();
        b3.a(profilingLoader.getGlobalTypes());
        b3.b(profilingLoader.getGlobalMethods());
        for (Map.Entry<Byte, List<com.oracle.svm.enterprise.profiling.collect.d>> entry : e2.gH().gw().entrySet()) {
            profilingLoader.loadNodes(b3, this.profilingData, entry.getValue(), entry.getKey(), b2);
        }
        return b3.gV();
    }

    protected static <T, M> void assimilate(ProfilingLoader<T, M> profilingLoader, com.oracle.svm.enterprise.profiling.adapters.b<T, M> b2, e e2, boolean bl2, boolean bl3) {
        long l2 = 0L;
        long l3 = 0L;
        com.oracle.svm.enterprise.profiling.collect.c c3 = e2.gG();
        Map<Integer, com.oracle.svm.enterprise.profiling.metadata.elements.d> map = c3.gA().stream().collect(Collectors.toMap(com.oracle.svm.enterprise.profiling.metadata.elements.d::ho, d2 -> d2));
        Map<Integer, com.oracle.svm.enterprise.profiling.metadata.elements.c> map2 = c3.dU().stream().collect(Collectors.toMap(com.oracle.svm.enterprise.profiling.metadata.elements.d::ho, c2 -> c2));
        Map<Integer, T> map3 = profilingLoader.loadTypes(map);
        Map<Integer, M> map4 = profilingLoader.loadMethods(map, map2);
        for (Map.Entry<Byte, List<com.oracle.svm.enterprise.profiling.collect.d>> entry : e2.gH().gw().entrySet()) {
            l2 += (long)entry.getValue().size();
            List<com.oracle.svm.enterprise.profiling.collect.d> list = ProfilingBaseProfile.assimilate0(entry.getValue(), b2, map, map3, map2, map4, bl2, entry.getKey());
            l3 += (long)list.size();
            entry.setValue(list);
        }
        if (bl3) {
            LogUtils.info((String)"%.2f%% of the entries from the profile file(s) did not match the target application.".formatted(Float.valueOf((1.0f - (float)l3 / (float)l2) * 100.0f)));
        }
    }

    protected abstract ProfilingBaseProfile newInstance(a var1, com.oracle.svm.enterprise.profiling.data.m var2);

    private void dump(List<com.oracle.svm.enterprise.profiling.metadata.cctree.c> list, OutputStreamWriter outputStreamWriter) throws IOException {
        String string = "";
        for (com.oracle.svm.enterprise.profiling.metadata.cctree.c c2 : list) {
            long[] lArray;
            String string2 = ProfilingBaseProfile.makeContext(c2);
            c c3 = c2.gZ();
            if (c3.i(lArray = c2.a(this.profilingData)) <= 0L) continue;
            outputStreamWriter.append(string);
            outputStreamWriter.append("{\"ctx\":\"").append(string2).append("\",");
            ProfilingBaseProfile.dump(outputStreamWriter, lArray);
            outputStreamWriter.append("}");
            string = ",";
        }
        outputStreamWriter.flush();
    }

    private static String makeContext(com.oracle.svm.enterprise.profiling.metadata.cctree.c c2) {
        StringBuilder stringBuilder = new StringBuilder();
        com.oracle.svm.enterprise.profiling.metadata.cctree.d d2 = c2;
        do {
            com.oracle.svm.enterprise.profiling.metadata.codepositions.a<?> a2 = d2.hb();
            stringBuilder.insert(0, a2.hh()).insert(0, ":").insert(0, a2.hi());
            if (d2.hd() == null) continue;
            stringBuilder.insert(0, "<");
        } while ((d2 = d2.hd()) != null);
        return stringBuilder.toString();
    }

    private static void dumpSamples(Map<String, long[]> map, OutputStreamWriter outputStreamWriter) throws IOException {
        String string = "";
        c c2 = d.zw.gO();
        for (Map.Entry<String, long[]> entry : map.entrySet()) {
            String string2 = entry.getKey();
            long[] lArray = entry.getValue();
            if (c2.i(lArray) <= 0L) continue;
            outputStreamWriter.append(string);
            outputStreamWriter.append("{\"ctx\":\"").append(string2).append("\",");
            ProfilingBaseProfile.dump(outputStreamWriter, lArray);
            outputStreamWriter.append("}");
            string = ",";
        }
        outputStreamWriter.flush();
    }

    private static void dump(OutputStreamWriter outputStreamWriter, long[] lArray) throws IOException {
        outputStreamWriter.append("\"records\":[");
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            outputStreamWriter.append(Long.toString(lArray[i2]));
            if (i2 >= lArray.length - 1) continue;
            outputStreamWriter.append(",");
        }
        outputStreamWriter.append("]");
        outputStreamWriter.flush();
    }

    private long findSums(Map<String, com.oracle.svm.enterprise.profiling.metadata.cctree.c> map) {
        long l2 = 0L;
        for (com.oracle.svm.enterprise.profiling.metadata.cctree.c c2 : map.values()) {
            l2 += c2.b(this.profilingData);
        }
        return l2;
    }

    private void merge0(b b2, l l2) {
        this.mergeTypes(b2);
        this.mergeNodes(b2, l2);
    }

    private void mergeTypes(b b2) {
        b2.a(this.profilingMetadata.gR());
        b2.b(this.profilingMetadata.gS());
    }

    private void mergeNodes(b b2, l l2) {
        List<Map<List<com.oracle.svm.enterprise.profiling.metadata.codepositions.a<?>>, com.oracle.svm.enterprise.profiling.metadata.cctree.c>> list = this.findAllNodes();
        for (Map<List<com.oracle.svm.enterprise.profiling.metadata.codepositions.a<?>>, com.oracle.svm.enterprise.profiling.metadata.cctree.c> map : list) {
            for (Map.Entry<List<com.oracle.svm.enterprise.profiling.metadata.codepositions.a<?>>, com.oracle.svm.enterprise.profiling.metadata.cctree.c> entry : map.entrySet()) {
                com.oracle.svm.enterprise.profiling.metadata.cctree.c c2 = entry.getValue();
                long[] lArray = c2.a(this.profilingData);
                List<com.oracle.svm.enterprise.profiling.metadata.codepositions.a<?>> list2 = entry.getKey();
                byte by = d.a(c2.gZ());
                com.oracle.svm.enterprise.profiling.metadata.cctree.e e2 = b2.o(list2);
                com.oracle.svm.enterprise.profiling.metadata.cctree.d d2 = e2.hf();
                if (e2.hg() && d2 instanceof com.oracle.svm.enterprise.profiling.metadata.cctree.c) {
                    com.oracle.svm.enterprise.profiling.metadata.cctree.c c3 = (com.oracle.svm.enterprise.profiling.metadata.cctree.c)d2;
                    c3.a(l2, lArray);
                    continue;
                }
                int n2 = l2.c(lArray.length, false);
                l2.a(n2, lArray);
                b2.a(list2, by, n2, false);
            }
        }
    }

    private static <T, M> List<com.oracle.svm.enterprise.profiling.collect.d> assimilate0(List<com.oracle.svm.enterprise.profiling.collect.d> list, com.oracle.svm.enterprise.profiling.adapters.b<T, M> b2, Map<Integer, com.oracle.svm.enterprise.profiling.metadata.elements.d> map, Map<Integer, T> map2, Map<Integer, com.oracle.svm.enterprise.profiling.metadata.elements.c> map3, Map<Integer, M> map4, boolean bl2, byte by) {
        ArrayList<com.oracle.svm.enterprise.profiling.collect.d> arrayList = new ArrayList<com.oracle.svm.enterprise.profiling.collect.d>();
        d d2 = d.d(by);
        for (com.oracle.svm.enterprise.profiling.collect.d d3 : list) {
            d3.c(d2.gO().a(d3.gD(), b2, map2));
            if (d2.gO().i(d3.gD()) <= 0L) continue;
            if (ProfilingBaseProfile.checkCallingContext(d3, b2, map4)) {
                arrayList.add(d3);
                continue;
            }
            if (!bl2) continue;
            ProfilingBaseProfile.printDroppedContexts(d3.gE(), d2.getName(), map, map3, map4);
        }
        return arrayList;
    }

    private static <T, M> boolean checkCallingContext(com.oracle.svm.enterprise.profiling.collect.d d2, com.oracle.svm.enterprise.profiling.adapters.b<T, M> b2, Map<Integer, M> map) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : m.O(d2.gE())) {
            Pair<Integer, Integer> pair = m.N(string);
            int n2 = 0;
            if ((Integer)pair.getLeft() != 0) {
                M m2 = map.get(pair.getLeft());
                if (m2 == null) {
                    return false;
                }
                n2 = b2.o(m2);
            }
            arrayList.add(m.b(n2, (Integer)pair.getRight()));
        }
        d2.P(String.join((CharSequence)"<", arrayList));
        return true;
    }

    private static <M> void printDroppedContexts(String string, String string2, Map<Integer, com.oracle.svm.enterprise.profiling.metadata.elements.d> map, Map<Integer, com.oracle.svm.enterprise.profiling.metadata.elements.c> map2, Map<Integer, M> map3) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        for (String string3 : m.O(string)) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append("<-");
            }
            Pair<Integer, Integer> pair = m.N(string3);
            Integer n2 = (Integer)pair.getLeft();
            com.oracle.svm.enterprise.profiling.metadata.elements.c c2 = map2.get(n2);
            com.oracle.svm.enterprise.profiling.metadata.elements.d d2 = map.get(c2.hp()[0]);
            String string4 = map3.get(n2) == null ? "*" : "";
            stringBuilder.append(d2.getName()).append("#").append(c2.getName()).append(':').append(pair.getRight()).append(string4);
        }
        LogUtils.warning((String)"Dropping calling-context for %s (* missing method) %s.".formatted(string2, stringBuilder.toString()));
    }

    private List<Map<List<com.oracle.svm.enterprise.profiling.metadata.codepositions.a<?>>, com.oracle.svm.enterprise.profiling.metadata.cctree.c>> findAllNodes() {
        return this.profilingMetadata.a((list, a2) -> {
            ArrayList<com.oracle.svm.enterprise.profiling.metadata.codepositions.a> arrayList = new ArrayList<com.oracle.svm.enterprise.profiling.metadata.codepositions.a>((Collection<com.oracle.svm.enterprise.profiling.metadata.codepositions.a>)list);
            arrayList.add((com.oracle.svm.enterprise.profiling.metadata.codepositions.a)a2);
            return arrayList;
        }, ArrayList::new);
    }

    private List<Map<String, com.oracle.svm.enterprise.profiling.metadata.cctree.c>> findAllNodesWithStringContext() {
        return this.profilingMetadata.a((string, a2) -> {
            Object object = m.b(a2.hi(), a2.hh());
            if (!string.isEmpty()) {
                object = string + "<" + (String)object;
            }
            return object;
        }, () -> "");
    }

    private List<List<com.oracle.svm.enterprise.profiling.metadata.cctree.c>> findLeafNodes() {
        return this.profilingMetadata.findLeafNodes();
    }
}

