/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.objectinlining;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.hosted.objectinlining.i;
import com.oracle.svm.enterprise.hosted.objectinlining.j;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.Fields;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.java.AccessFieldNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;
import org.graalvm.compiler.nodes.java.StoreFieldNode;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.nodes.virtual.CommitAllocationNode;
import org.graalvm.compiler.nodes.virtual.VirtualInstanceNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.phases.Phase;

public class ObjectInliningPhase
extends Phase {
    private static final byte tr = 0;
    private static final byte ts = 1;
    private final HostedUniverse tt;

    public ObjectInliningPhase(HostedUniverse hostedUniverse) {
        this.tt = hostedUniverse;
    }

    protected void run(StructuredGraph structuredGraph) {
        DebugContext debugContext = structuredGraph.getDebug();
        try (DebugContext.Scope scope = debugContext.scope((Object)"ObjectInlining (compiler phase)");){
            for (AccessFieldNode accessFieldNode : structuredGraph.getNodes().filter(AccessFieldNode.class)) {
                HostedField hostedField = (HostedField)accessFieldNode.field();
                boolean bl2 = com.oracle.svm.enterprise.hosted.objectinlining.b.eI().k((ResolvedJavaField)hostedField);
                boolean bl3 = com.oracle.svm.enterprise.hosted.objectinlining.b.eI().j((ResolvedJavaField)hostedField);
                if (bl3 && i.eM().l(hostedField.wrapped)) {
                    this.c(structuredGraph, accessFieldNode);
                    debugContext.log(3, "intercepting value graph access: %s", (Object)accessFieldNode);
                    continue;
                }
                if (!bl2 || !i.eM().l(hostedField.wrapped)) continue;
                this.b(structuredGraph, accessFieldNode);
                debugContext.log(3, "intercepting value field access: %s", (Object)accessFieldNode);
            }
        }
    }

    private static AnalysisField l(List<AnalysisField> list) {
        AnalysisField analysisField = null;
        for (AnalysisField analysisField2 : list) {
            if (!analysisField2.getType().isArray()) continue;
            analysisField = analysisField2;
            break;
        }
        assert (analysisField != null);
        return analysisField;
    }

    public static void f(StructuredGraph structuredGraph) {
        for (CommitAllocationNode commitAllocationNode : structuredGraph.getNodes().filter(CommitAllocationNode.class)) {
            ArrayList<ValueNode> arrayList = new ArrayList<ValueNode>(commitAllocationNode.getValues());
            int n2 = 0;
            for (VirtualObjectNode virtualObjectNode : commitAllocationNode.getVirtualObjects()) {
                AnalysisType analysisType = (AnalysisType)virtualObjectNode.type();
                if (!analysisType.isArray() && i.eM().c(analysisType)) {
                    VirtualInstanceNode virtualInstanceNode = (VirtualInstanceNode)virtualObjectNode;
                    for (int i2 = 0; i2 < virtualInstanceNode.getFields().length; ++i2) {
                        arrayList.remove(n2);
                    }
                    ObjectInliningPhase.a((Node)virtualInstanceNode, virtualInstanceNode.getFields(), analysisType.getInstanceFields(true));
                    for (ResolvedJavaField resolvedJavaField : virtualInstanceNode.getFields()) {
                        arrayList.add(n2, (ValueNode)structuredGraph.addOrUniqueWithInputs((Node)ConstantNode.defaultForKind((JavaKind)resolvedJavaField.getJavaKind())));
                        ++n2;
                    }
                    continue;
                }
                n2 += virtualObjectNode.entryCount();
            }
            if (commitAllocationNode.getValues().size() == arrayList.size()) continue;
            commitAllocationNode.getValues().clear();
            commitAllocationNode.getValues().addAll(arrayList);
        }
    }

    private void a(StructuredGraph structuredGraph, AccessFieldNode accessFieldNode) {
        if (accessFieldNode instanceof StoreFieldNode) {
            new f(structuredGraph, accessFieldNode).an();
        } else {
            new c(structuredGraph, accessFieldNode).an();
        }
    }

    private void b(StructuredGraph structuredGraph, AccessFieldNode accessFieldNode) {
        HostedField hostedField = (HostedField)accessFieldNode.field();
        if (ObjectInliningPhase.b(hostedField)) {
            if (accessFieldNode instanceof StoreFieldNode) {
                new g(structuredGraph, accessFieldNode).an();
            } else {
                new d(structuredGraph, accessFieldNode).an();
            }
        } else if (ObjectInliningPhase.i(hostedField.wrapped)) {
            this.a(structuredGraph, accessFieldNode);
        } else {
            throw VMError.shouldNotReachHere((String)("Can't handle access to : " + String.valueOf(hostedField)));
        }
    }

    private void c(StructuredGraph structuredGraph, AccessFieldNode accessFieldNode) {
        if (accessFieldNode instanceof StoreFieldNode) {
            new h(structuredGraph, accessFieldNode).an();
        } else {
            new e(structuredGraph, accessFieldNode).an();
        }
    }

    private static void a(Node node, Object object, Object object2) {
        Fields fields = node.getNodeClass().getData();
        for (int i2 = 0; i2 < fields.getCount(); ++i2) {
            if (object != fields.get((Object)node, i2)) continue;
            fields.putObjectChecked((Object)node, i2, object2);
        }
    }

    public HostedField g(AnalysisField analysisField) {
        return this.a(i.eM().n(analysisField), analysisField);
    }

    private HostedField a(List<AnalysisField> list, AnalysisField analysisField) {
        HostedField hostedField = null;
        if (ObjectInliningPhase.h(analysisField)) {
            for (AnalysisField analysisField2 : list) {
                j j2 = (j)analysisField2.wrapped;
                if (!j2.eG().equals(analysisField)) continue;
                hostedField = this.tt.lookup((JavaField)analysisField2);
                break;
            }
        } else if (ObjectInliningPhase.i(analysisField)) {
            hostedField = this.tt.lookup((JavaField)ObjectInliningPhase.l(i.eM().j(analysisField)));
        } else {
            throw VMError.shouldNotReachHere((String)("Could not find state for : " + String.valueOf(analysisField)));
        }
        assert (hostedField != null);
        return hostedField;
    }

    private static boolean b(HostedField hostedField) {
        return ObjectInliningPhase.h(hostedField.wrapped);
    }

    private static boolean h(AnalysisField analysisField) {
        return !ObjectInliningPhase.i(analysisField);
    }

    private static boolean i(AnalysisField analysisField) {
        return analysisField.getType().getJavaClass().equals(String.class);
    }

    private static StoreFieldNode a(StructuredGraph structuredGraph, ValueNode valueNode, ResolvedJavaField resolvedJavaField, ValueNode valueNode2, FrameState frameState) {
        StoreFieldNode storeFieldNode = (StoreFieldNode)structuredGraph.addOrUniqueWithInputs((Node)new StoreFieldNode(valueNode, resolvedJavaField, valueNode2, frameState));
        return storeFieldNode;
    }

    class f
    extends g {
        protected LoadFieldNode tO;

        f(StructuredGraph structuredGraph, AccessFieldNode accessFieldNode) {
            super(structuredGraph, accessFieldNode);
        }

        @Override
        protected void a(EndNode endNode) {
            ValueNode valueNode = (ValueNode)this.tu.addOrUniqueWithInputs((Node)ConstantNode.defaultForKind((JavaKind)JavaKind.Object));
            StoreFieldNode storeFieldNode = ObjectInliningPhase.a(this.tu, this.tz, (ResolvedJavaField)this.tx, valueNode, this.tA);
            this.tu.addBeforeFixed((FixedNode)endNode, (FixedWithNextNode)storeFieldNode);
        }

        @Override
        protected void b(EndNode endNode) {
        }
    }

    class c
    extends d {
        c(StructuredGraph structuredGraph, AccessFieldNode accessFieldNode) {
            super(structuredGraph, accessFieldNode);
        }

        @Override
        public LogicNode eL() {
            this.tK = (LoadFieldNode)this.tu.add((Node)LoadFieldNode.create(null, (ValueNode)this.tz, (ResolvedJavaField)this.tx));
            return (LogicNode)this.tu.addOrUniqueWithInputs((Node)IsNullNode.create((ValueNode)this.tK));
        }
    }

    class g
    extends a {
        protected ValueNode tQ;

        g(StructuredGraph structuredGraph, AccessFieldNode accessFieldNode) {
            super(structuredGraph, accessFieldNode);
            this.tQ = ((StoreFieldNode)accessFieldNode).value();
        }

        @Override
        public LogicNode eL() {
            return (LogicNode)this.tu.addOrUniqueWithInputs((Node)IsNullNode.create((ValueNode)this.tQ));
        }

        private StoreFieldNode a(ConstantNode constantNode) {
            return ObjectInliningPhase.a(this.tu, this.tz, (ResolvedJavaField)this.tx, (ValueNode)constantNode, this.tA);
        }

        protected void a(EndNode endNode) {
            StoreFieldNode storeFieldNode = this.a((ConstantNode)this.tu.addOrUniqueWithInputs((Node)ConstantNode.forByte((byte)0, (StructuredGraph)this.tu)));
            this.tu.addBeforeFixed((FixedNode)endNode, (FixedWithNextNode)storeFieldNode);
        }

        protected void b(EndNode endNode) {
            StoreFieldNode storeFieldNode = this.a(ConstantNode.forByte((byte)1, (StructuredGraph)this.tu));
            this.tu.addBeforeFixed((FixedNode)endNode, (FixedWithNextNode)storeFieldNode);
        }

        @Override
        public void a(BeginNode beginNode, EndNode endNode) {
            ArrayList<StoreFieldNode> arrayList = new ArrayList<StoreFieldNode>();
            this.a(endNode);
            for (AnalysisField analysisField : this.ty) {
                HostedField hostedField = ObjectInliningPhase.this.tt.lookup((JavaField)analysisField);
                if (analysisField.getType().isPrimitive()) continue;
                StoreFieldNode storeFieldNode = ObjectInliningPhase.a(this.tu, this.tz, (ResolvedJavaField)hostedField, (ValueNode)ConstantNode.defaultForKind((JavaKind)JavaKind.Object), this.tA);
                arrayList.add(storeFieldNode);
            }
            for (StoreFieldNode storeFieldNode : arrayList) {
                this.tu.addBeforeFixed((FixedNode)endNode, (FixedWithNextNode)storeFieldNode);
            }
        }

        @Override
        public void b(BeginNode beginNode, EndNode endNode) {
            ArrayList<LoadFieldNode> arrayList = new ArrayList<LoadFieldNode>();
            ArrayList<StoreFieldNode> arrayList2 = new ArrayList<StoreFieldNode>();
            for (AnalysisField analysisField : this.ty) {
                com.oracle.svm.enterprise.hosted.objectinlining.a a2 = (com.oracle.svm.enterprise.hosted.objectinlining.a)analysisField.wrapped;
                HostedField hostedField = ObjectInliningPhase.this.tt.lookup((JavaField)analysisField);
                HostedField hostedField2 = ObjectInliningPhase.this.tt.lookup((JavaField)a2.eD());
                LoadFieldNode loadFieldNode = (LoadFieldNode)this.tu.addOrUniqueWithInputs((Node)LoadFieldNode.create(null, (ValueNode)this.tQ, (ResolvedJavaField)hostedField2));
                StoreFieldNode storeFieldNode = ObjectInliningPhase.a(this.tu, this.tz, (ResolvedJavaField)hostedField, (ValueNode)loadFieldNode, this.tA);
                arrayList.add(loadFieldNode);
                arrayList2.add(storeFieldNode);
            }
            for (LoadFieldNode loadFieldNode : arrayList) {
                this.tu.addBeforeFixed((FixedNode)endNode, (FixedWithNextNode)loadFieldNode);
            }
            for (StoreFieldNode storeFieldNode : arrayList2) {
                this.tu.addBeforeFixed((FixedNode)endNode, (FixedWithNextNode)storeFieldNode);
            }
            this.b(endNode);
        }

        @Override
        public void a(IfNode ifNode, MergeNode mergeNode) {
            FixedNode fixedNode = this.tv.next();
            this.tv.setNext(null);
            mergeNode.setNext(fixedNode);
            this.tv.replaceAndDelete((Node)ifNode);
        }
    }

    class d
    extends a {
        protected LoadFieldNode tK;
        protected ValueNode[] tL;

        d(StructuredGraph structuredGraph, AccessFieldNode accessFieldNode) {
            super(structuredGraph, accessFieldNode);
            this.tL = new ValueNode[2];
        }

        @Override
        public LogicNode eL() {
            this.tK = (LoadFieldNode)this.tu.addOrUniqueWithInputs((Node)LoadFieldNode.create(null, (ValueNode)this.tz, (ResolvedJavaField)this.tx));
            return CompareNode.createCompareNode((StructuredGraph)this.tu, (CanonicalCondition)CanonicalCondition.EQ, (ValueNode)this.tK, (ValueNode)ConstantNode.forByte((byte)0, (StructuredGraph)this.tu), null, (NodeView)NodeView.DEFAULT);
        }

        @Override
        public void a(BeginNode beginNode, EndNode endNode) {
            this.tL[0] = (ValueNode)this.tu.addOrUniqueWithInputs((Node)ConstantNode.defaultForKind((JavaKind)JavaKind.Object));
        }

        @Override
        public void b(BeginNode beginNode, EndNode endNode) {
            ArrayList<LoadFieldNode> arrayList = new ArrayList<LoadFieldNode>();
            ArrayList<StoreFieldNode> arrayList2 = new ArrayList<StoreFieldNode>();
            NewInstanceNode newInstanceNode = (NewInstanceNode)this.tu.addOrUniqueWithInputs((Node)new NewInstanceNode((ResolvedJavaType)this.tw.getType(), true, null));
            this.tL[1] = newInstanceNode;
            this.tu.addAfterFixed((FixedWithNextNode)beginNode, (FixedNode)newInstanceNode);
            for (AnalysisField analysisField : this.ty) {
                com.oracle.svm.enterprise.hosted.objectinlining.a a2 = (com.oracle.svm.enterprise.hosted.objectinlining.a)analysisField.wrapped;
                HostedField hostedField = ObjectInliningPhase.this.tt.lookup((JavaField)analysisField);
                HostedField hostedField2 = ObjectInliningPhase.this.tt.lookup((JavaField)a2.eD());
                LoadFieldNode loadFieldNode = (LoadFieldNode)this.tu.addOrUniqueWithInputs((Node)LoadFieldNode.create(null, (ValueNode)this.tz, (ResolvedJavaField)hostedField));
                StoreFieldNode storeFieldNode = ObjectInliningPhase.a(this.tu, (ValueNode)newInstanceNode, (ResolvedJavaField)hostedField2, (ValueNode)loadFieldNode, this.tA);
                arrayList.add(loadFieldNode);
                arrayList2.add(storeFieldNode);
            }
            for (LoadFieldNode loadFieldNode : arrayList) {
                this.tu.addBeforeFixed((FixedNode)endNode, (FixedWithNextNode)loadFieldNode);
            }
            for (StoreFieldNode storeFieldNode : arrayList2) {
                this.tu.addBeforeFixed((FixedNode)endNode, (FixedWithNextNode)storeFieldNode);
            }
        }

        @Override
        public void a(IfNode ifNode, MergeNode mergeNode) {
            ValuePhiNode valuePhiNode = (ValuePhiNode)this.tu.addWithoutUnique((Node)new ValuePhiNode(StampFactory.forKind((JavaKind)JavaKind.Object), (AbstractMergeNode)mergeNode, this.tL));
            FixedNode fixedNode = this.tv.next();
            this.tv.replaceAtUsages((Node)valuePhiNode);
            this.tv.setNext(null);
            mergeNode.setNext(fixedNode);
            this.tv.replaceAndDelete((Node)ifNode);
            this.tu.addBeforeFixed((FixedNode)ifNode, (FixedWithNextNode)this.tK);
        }
    }

    class h
    extends b {
        h(StructuredGraph structuredGraph, AccessFieldNode accessFieldNode) {
            super(structuredGraph, accessFieldNode);
        }

        private StoreFieldNode a(ValueNode valueNode, HostedField hostedField) {
            ValueNode valueNode2 = (ValueNode)this.tD.addOrUniqueWithInputs((Node)ConstantNode.defaultForKind((JavaKind)hostedField.getJavaKind()));
            return ObjectInliningPhase.a(this.tD, valueNode, (ResolvedJavaField)hostedField, valueNode2, this.tG);
        }

        private StoreFieldNode b(ValueNode valueNode, HostedField hostedField) {
            ConstantNode constantNode = ConstantNode.forByte((byte)1, (StructuredGraph)this.tD);
            return ObjectInliningPhase.a(this.tD, valueNode, (ResolvedJavaField)hostedField, (ValueNode)constantNode, this.tG);
        }

        @Override
        protected LogicNode f(ValueNode valueNode) {
            return (LogicNode)this.tD.addOrUniqueWithInputs((Node)IsNullNode.create((ValueNode)valueNode));
        }

        @Override
        protected ValueNode a(BeginNode beginNode, EndNode endNode, ValueNode valueNode, HostedField hostedField, HostedField hostedField2, ValueNode valueNode2) {
            ArrayList<StoreFieldNode> arrayList = new ArrayList<StoreFieldNode>();
            if (ObjectInliningPhase.b(hostedField2)) {
                this.tD.addBeforeFixed((FixedNode)endNode, (FixedWithNextNode)this.a(valueNode, hostedField));
            }
            for (AnalysisField analysisField : i.eM().j(hostedField2.wrapped)) {
                if (analysisField.wrapped instanceof j) continue;
                HostedField hostedField3 = ObjectInliningPhase.this.tt.lookup((JavaField)analysisField);
                if (analysisField.getType().isPrimitive()) continue;
                if (!i.eM().l(analysisField)) {
                    arrayList.add(ObjectInliningPhase.a(this.tD, valueNode, (ResolvedJavaField)hostedField3, valueNode2, this.tG));
                    continue;
                }
                this.a(valueNode, hostedField3, valueNode2, (FixedWithNextNode)endNode.predecessor(), false);
            }
            for (StoreFieldNode storeFieldNode : arrayList) {
                this.tD.addBeforeFixed((FixedNode)endNode, (FixedWithNextNode)storeFieldNode);
            }
            return null;
        }

        @Override
        protected ValueNode b(BeginNode beginNode, EndNode endNode, ValueNode valueNode, HostedField hostedField, HostedField hostedField2, ValueNode valueNode2) {
            ArrayList<StoreFieldNode> arrayList = new ArrayList<StoreFieldNode>();
            for (AnalysisField analysisField : i.eM().j(hostedField2.wrapped)) {
                if (analysisField.wrapped instanceof j) continue;
                HostedField hostedField3 = ObjectInliningPhase.this.tt.lookup((JavaField)analysisField);
                HostedField hostedField4 = ObjectInliningPhase.this.tt.lookup((JavaField)((com.oracle.svm.enterprise.hosted.objectinlining.a)analysisField.wrapped).eD());
                LoadFieldNode loadFieldNode = (LoadFieldNode)this.tD.addOrUniqueWithInputs((Node)LoadFieldNode.create(null, (ValueNode)valueNode2, (ResolvedJavaField)hostedField4));
                this.tD.addBeforeFixed((FixedNode)endNode, (FixedWithNextNode)loadFieldNode);
                if (!i.eM().l(analysisField)) {
                    arrayList.add(ObjectInliningPhase.a(this.tD, valueNode, (ResolvedJavaField)hostedField3, (ValueNode)loadFieldNode, this.tG));
                    continue;
                }
                this.a(valueNode, hostedField3, (ValueNode)loadFieldNode, (FixedWithNextNode)endNode.predecessor(), false);
            }
            for (StoreFieldNode storeFieldNode : arrayList) {
                this.tD.addBeforeFixed((FixedNode)endNode, (FixedWithNextNode)storeFieldNode);
            }
            if (ObjectInliningPhase.b(hostedField2)) {
                this.tD.addBeforeFixed((FixedNode)endNode, (FixedWithNextNode)this.b(valueNode, hostedField));
            }
            return null;
        }

        @Override
        protected ValueNode a(ValueNode valueNode, HostedField hostedField, ValueNode valueNode2, FixedWithNextNode fixedWithNextNode, boolean bl2) {
            HostedField hostedField2 = ObjectInliningPhase.this.a(this.tF, hostedField.wrapped);
            LogicNode logicNode = this.f(valueNode2);
            BeginNode beginNode = (BeginNode)this.tD.add((Node)new BeginNode());
            EndNode endNode = (EndNode)this.tD.add((Node)new EndNode());
            this.tD.addAfterFixed((FixedWithNextNode)beginNode, (FixedNode)endNode);
            this.a(beginNode, endNode, valueNode, hostedField2, hostedField, (ValueNode)ConstantNode.defaultForKind((JavaKind)JavaKind.Object));
            BeginNode beginNode2 = (BeginNode)this.tD.add((Node)new BeginNode());
            EndNode endNode2 = (EndNode)this.tD.add((Node)new EndNode());
            this.tD.addAfterFixed((FixedWithNextNode)beginNode2, (FixedNode)endNode2);
            this.b(beginNode2, endNode2, valueNode, hostedField2, hostedField, valueNode2);
            IfNode ifNode = (IfNode)this.tD.add((Node)new IfNode(logicNode, (AbstractBeginNode)beginNode, (AbstractBeginNode)beginNode2, ProfileData.BranchProbabilityData.unknown()));
            ifNode.setNodeSourcePosition(this.tH);
            MergeNode mergeNode = (MergeNode)this.tD.add((Node)new MergeNode());
            mergeNode.addForwardEnd(endNode);
            mergeNode.addForwardEnd(endNode2);
            if (bl2) {
                FixedNode fixedNode = fixedWithNextNode.next();
                this.tE.setNext(null);
                mergeNode.setNext(fixedNode);
                this.tE.replaceAndDelete((Node)ifNode);
            } else {
                FixedNode fixedNode = fixedWithNextNode.next();
                fixedWithNextNode.setNext((FixedNode)ifNode);
                mergeNode.setNext(fixedNode);
            }
            mergeNode.setStateAfter(this.tG);
            return null;
        }

        @Override
        public void an() {
            this.a(this.tE.object(), (HostedField)this.tE.field(), ((StoreFieldNode)this.tE).value(), (FixedWithNextNode)this.tE, true);
        }
    }

    class e
    extends b {
        e(StructuredGraph structuredGraph, AccessFieldNode accessFieldNode) {
            super(structuredGraph, accessFieldNode);
        }

        @Override
        protected LogicNode f(ValueNode valueNode) {
            return CompareNode.createCompareNode((StructuredGraph)this.tD, (CanonicalCondition)CanonicalCondition.EQ, (ValueNode)valueNode, (ValueNode)ConstantNode.defaultForKind((JavaKind)valueNode.getStackKind()), null, (NodeView)NodeView.DEFAULT);
        }

        @Override
        protected ValueNode a(BeginNode beginNode, EndNode endNode, ValueNode valueNode, HostedField hostedField, HostedField hostedField2, ValueNode valueNode2) {
            return (ValueNode)this.tD.addOrUniqueWithInputs((Node)ConstantNode.defaultForKind((JavaKind)JavaKind.Object));
        }

        @Override
        protected ValueNode b(BeginNode beginNode, EndNode endNode, ValueNode valueNode, HostedField hostedField, HostedField hostedField2, ValueNode valueNode2) {
            AnalysisField analysisField = hostedField2.wrapped;
            NewInstanceNode newInstanceNode = (NewInstanceNode)this.tD.addOrUniqueWithInputs((Node)new NewInstanceNode((ResolvedJavaType)hostedField2.getType(), true, null));
            this.tD.addAfterFixed((FixedWithNextNode)beginNode, (FixedNode)newInstanceNode);
            ArrayList<LoadFieldNode> arrayList = new ArrayList<LoadFieldNode>();
            ArrayList<LoadFieldNode> arrayList2 = new ArrayList<LoadFieldNode>();
            for (AnalysisField analysisField2 : i.eM().j(analysisField)) {
                ValueNode valueNode3;
                LoadFieldNode loadFieldNode;
                if (analysisField2.wrapped instanceof j) continue;
                com.oracle.svm.enterprise.hosted.objectinlining.a a2 = (com.oracle.svm.enterprise.hosted.objectinlining.a)analysisField2.wrapped;
                HostedField hostedField3 = ObjectInliningPhase.this.tt.lookup((JavaField)analysisField2);
                HostedField hostedField4 = ObjectInliningPhase.this.tt.lookup((JavaField)a2.eD());
                if (!i.eM().l(analysisField2)) {
                    loadFieldNode = (LoadFieldNode)this.tD.addOrUniqueWithInputs((Node)LoadFieldNode.create(null, (ValueNode)valueNode, (ResolvedJavaField)hostedField3));
                    arrayList.add(loadFieldNode);
                    valueNode3 = loadFieldNode;
                } else {
                    valueNode3 = this.a(valueNode, hostedField3, valueNode2, (FixedWithNextNode)newInstanceNode, false);
                }
                loadFieldNode = ObjectInliningPhase.a(this.tD, (ValueNode)newInstanceNode, (ResolvedJavaField)hostedField4, valueNode3, this.tG);
                arrayList2.add(loadFieldNode);
            }
            for (LoadFieldNode loadFieldNode : arrayList) {
                this.tD.addBeforeFixed((FixedNode)endNode, (FixedWithNextNode)loadFieldNode);
            }
            for (StoreFieldNode storeFieldNode : arrayList2) {
                this.tD.addBeforeFixed((FixedNode)endNode, (FixedWithNextNode)storeFieldNode);
            }
            return newInstanceNode;
        }

        @Override
        protected ValueNode a(ValueNode valueNode, HostedField hostedField, ValueNode valueNode2, FixedWithNextNode fixedWithNextNode, boolean bl2) {
            HostedField hostedField2 = ObjectInliningPhase.this.a(this.tF, hostedField.wrapped);
            ValueNode[] valueNodeArray = new ValueNode[2];
            LoadFieldNode loadFieldNode = (LoadFieldNode)this.tD.addOrUniqueWithInputs((Node)LoadFieldNode.create(null, (ValueNode)valueNode, (ResolvedJavaField)hostedField2));
            LogicNode logicNode = this.f((ValueNode)loadFieldNode);
            BeginNode beginNode = (BeginNode)this.tD.add((Node)new BeginNode());
            EndNode endNode = (EndNode)this.tD.add((Node)new EndNode());
            this.tD.addAfterFixed((FixedWithNextNode)beginNode, (FixedNode)endNode);
            valueNodeArray[0] = this.a(beginNode, endNode, valueNode, hostedField2, hostedField, null);
            BeginNode beginNode2 = (BeginNode)this.tD.add((Node)new BeginNode());
            EndNode endNode2 = (EndNode)this.tD.add((Node)new EndNode());
            this.tD.addAfterFixed((FixedWithNextNode)beginNode2, (FixedNode)endNode2);
            valueNodeArray[1] = this.b(beginNode2, endNode2, valueNode, hostedField2, hostedField, null);
            IfNode ifNode = (IfNode)this.tD.add((Node)new IfNode(logicNode, (AbstractBeginNode)beginNode, (AbstractBeginNode)beginNode2, ProfileData.BranchProbabilityData.unknown()));
            ifNode.setNodeSourcePosition(this.tH);
            MergeNode mergeNode = (MergeNode)this.tD.add((Node)new MergeNode());
            mergeNode.addForwardEnd(endNode);
            mergeNode.addForwardEnd(endNode2);
            ValuePhiNode valuePhiNode = (ValuePhiNode)this.tD.addWithoutUnique((Node)new ValuePhiNode(StampFactory.forKind((JavaKind)JavaKind.Object), (AbstractMergeNode)mergeNode, valueNodeArray));
            if (bl2) {
                FixedNode fixedNode = fixedWithNextNode.next();
                fixedWithNextNode.replaceAtUsages((Node)valuePhiNode);
                fixedWithNextNode.setNext(null);
                mergeNode.setNext(fixedNode);
                fixedWithNextNode.replaceAndDelete((Node)ifNode);
                this.tD.addBeforeFixed((FixedNode)ifNode, (FixedWithNextNode)loadFieldNode);
            } else {
                FixedNode fixedNode = fixedWithNextNode.next();
                fixedWithNextNode.setNext((FixedNode)loadFieldNode);
                this.tD.addAfterFixed((FixedWithNextNode)loadFieldNode, (FixedNode)ifNode);
                mergeNode.setNext(fixedNode);
            }
            mergeNode.setStateAfter(this.tG);
            return valuePhiNode;
        }

        @Override
        public void an() {
            this.a(this.tE.object(), (HostedField)this.tE.field(), null, (FixedWithNextNode)this.tE, true);
        }
    }

    abstract class b {
        protected final StructuredGraph tD;
        protected final AccessFieldNode tE;
        protected final List<AnalysisField> tF;
        protected final FrameState tG;
        protected final NodeSourcePosition tH;

        b(StructuredGraph structuredGraph, AccessFieldNode accessFieldNode) {
            this.tD = structuredGraph;
            this.tE = accessFieldNode;
            HostedField hostedField = (HostedField)accessFieldNode.field();
            this.tF = i.eM().n(hostedField.wrapped);
            this.tG = GraphUtil.findLastFrameState((FixedNode)accessFieldNode).duplicateWithVirtualState();
            this.tH = accessFieldNode.getNodeSourcePosition();
        }

        public abstract void an();

        protected abstract ValueNode a(ValueNode var1, HostedField var2, ValueNode var3, FixedWithNextNode var4, boolean var5);

        protected abstract LogicNode f(ValueNode var1);

        protected abstract ValueNode a(BeginNode var1, EndNode var2, ValueNode var3, HostedField var4, HostedField var5, ValueNode var6);

        protected abstract ValueNode b(BeginNode var1, EndNode var2, ValueNode var3, HostedField var4, HostedField var5, ValueNode var6);
    }

    abstract class a {
        protected final StructuredGraph tu;
        protected final AccessFieldNode tv;
        protected final HostedField tw;
        protected final HostedField tx;
        protected final List<AnalysisField> ty;
        protected final ValueNode tz;
        protected final FrameState tA;
        protected final NodeSourcePosition tB;

        a(StructuredGraph structuredGraph, AccessFieldNode accessFieldNode) {
            this.tu = structuredGraph;
            this.tv = accessFieldNode;
            this.tw = (HostedField)accessFieldNode.field();
            this.tz = accessFieldNode.object();
            this.ty = i.eM().m(this.tw.wrapped);
            this.tx = ObjectInliningPhase.this.g(this.tw.wrapped);
            this.tA = GraphUtil.findLastFrameState((FixedNode)accessFieldNode).duplicateWithVirtualState();
            this.tB = accessFieldNode.getNodeSourcePosition();
        }

        public void an() {
            LogicNode logicNode = this.eL();
            BeginNode beginNode = (BeginNode)this.tu.add((Node)new BeginNode());
            EndNode endNode = (EndNode)this.tu.add((Node)new EndNode());
            this.tu.addAfterFixed((FixedWithNextNode)beginNode, (FixedNode)endNode);
            this.a(beginNode, endNode);
            BeginNode beginNode2 = (BeginNode)this.tu.add((Node)new BeginNode());
            EndNode endNode2 = (EndNode)this.tu.add((Node)new EndNode());
            this.tu.addAfterFixed((FixedWithNextNode)beginNode2, (FixedNode)endNode2);
            this.b(beginNode2, endNode2);
            IfNode ifNode = (IfNode)this.tu.add((Node)new IfNode(logicNode, (AbstractBeginNode)beginNode, (AbstractBeginNode)beginNode2, ProfileData.BranchProbabilityData.unknown()));
            ifNode.setNodeSourcePosition(this.tB);
            MergeNode mergeNode = (MergeNode)this.tu.add((Node)new MergeNode());
            mergeNode.addForwardEnd(endNode);
            mergeNode.addForwardEnd(endNode2);
            this.a(ifNode, mergeNode);
            mergeNode.setStateAfter(this.tA);
        }

        public abstract LogicNode eL();

        public abstract void a(BeginNode var1, EndNode var2);

        public abstract void b(BeginNode var1, EndNode var2);

        public abstract void a(IfNode var1, MergeNode var2);
    }
}

