// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: SerialGCOptions.java
package com.oracle.svm.core.genscavenge;

import java.util.*;
import org.graalvm.compiler.options.*;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionStability;

public class SerialGCOptions_OptionDescriptors implements OptionDescriptors {
    @Override
    public OptionDescriptor get(String value) {
        switch (value) {
        // CheckStyle: stop line length check
        case "CollectYoungGenerationSeparately": {
            return OptionDescriptor.create(
                /*name*/ "CollectYoungGenerationSeparately",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Determines if a full GC collects the young generation separately or together with the old generation. Serial GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "CollectYoungGenerationSeparately",
                /*option*/ SerialGCOptions.CollectYoungGenerationSeparately,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CountWriteBarriers": {
            return OptionDescriptor.create(
                /*name*/ "CountWriteBarriers",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Instrument write barriers with counters. Serial GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "CountWriteBarriers",
                /*option*/ SerialGCOptions.CountWriteBarriers,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "GreyToBlackObjRefDemographics": {
            return OptionDescriptor.create(
                /*name*/ "GreyToBlackObjRefDemographics",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Develop demographics of the object references visited. Serial GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "GreyToBlackObjRefDemographics",
                /*option*/ SerialGCOptions.GreyToBlackObjRefDemographics,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "IgnoreMaxHeapSizeWhileInVMOperation": {
            return OptionDescriptor.create(
                /*name*/ "IgnoreMaxHeapSizeWhileInVMOperation",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Ignore the maximum heap size while in VM-internal code.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "IgnoreMaxHeapSizeWhileInVMOperation",
                /*option*/ SerialGCOptions.IgnoreMaxHeapSizeWhileInVMOperation,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ImageHeapCardMarking": {
            return OptionDescriptor.create(
                /*name*/ "ImageHeapCardMarking",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enables card marking for image heap objects, which arranges them in chunks. Automatically enabled when supported. Serial GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "ImageHeapCardMarking",
                /*option*/ SerialGCOptions.ImageHeapCardMarking,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InitialCollectionPolicy": {
            return OptionDescriptor.create(
                /*name*/ "InitialCollectionPolicy",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "The garbage collection policy, either Adaptive (default) or BySpaceAndTime. Serial GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "InitialCollectionPolicy",
                /*option*/ SerialGCOptions.InitialCollectionPolicy,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxHeapFree": {
            return OptionDescriptor.create(
                /*name*/ "MaxHeapFree",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Long.class,
                /*help*/ "The maximum free bytes reserved for allocations, in bytes (0 for automatic according to GC policy). Serial GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "MaxHeapFree",
                /*option*/ SerialGCOptions.MaxHeapFree,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxSurvivorSpaces": {
            return OptionDescriptor.create(
                /*name*/ "MaxSurvivorSpaces",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum number of survivor spaces. Serial GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "MaxSurvivorSpaces",
                /*option*/ SerialGCOptions.MaxSurvivorSpaces,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PercentTimeInIncrementalCollection": {
            return OptionDescriptor.create(
                /*name*/ "PercentTimeInIncrementalCollection",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Integer.class,
                /*help*/ "Percentage of total collection time that should be spent on young generation collections. Serial GC with collection policy 'BySpaceAndTime' only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "PercentTimeInIncrementalCollection",
                /*option*/ SerialGCOptions.PercentTimeInIncrementalCollection,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintGCSummary": {
            return OptionDescriptor.create(
                /*name*/ "PrintGCSummary",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print summary GC information after application main method returns. Serial GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "PrintGCSummary",
                /*option*/ SerialGCOptions.PrintGCSummary,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintGCTimeStamps": {
            return OptionDescriptor.create(
                /*name*/ "PrintGCTimeStamps",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Deprecated. Print a time stamp at each collection, if +PrintGC or +VerboseGC. Serial GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "PrintGCTimeStamps",
                /*option*/ SerialGCOptions.PrintGCTimeStamps,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintGCTimes": {
            return OptionDescriptor.create(
                /*name*/ "PrintGCTimes",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print the time for each of the phases of each collection, if +VerboseGC. Serial GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "PrintGCTimes",
                /*option*/ SerialGCOptions.PrintGCTimes,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SoftRefLRUPolicyMSPerMB": {
            return OptionDescriptor.create(
                /*name*/ "SoftRefLRUPolicyMSPerMB",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "This number of milliseconds multiplied by the free heap memory in MByte is the time span for which a soft reference will keep its referent alive after its last access. Serial GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "SoftRefLRUPolicyMSPerMB",
                /*option*/ SerialGCOptions.SoftRefLRUPolicyMSPerMB,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceHeapChunks": {
            return OptionDescriptor.create(
                /*name*/ "TraceHeapChunks",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Trace heap chunks during collections, if +VerboseGC. Serial GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "TraceHeapChunks",
                /*option*/ SerialGCOptions.TraceHeapChunks,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyAfterGC": {
            return OptionDescriptor.create(
                /*name*/ "VerifyAfterGC",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify the heap after doing a garbage collection if VerifyHeap is enabled. Serial GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "VerifyAfterGC",
                /*option*/ SerialGCOptions.VerifyAfterGC,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyBeforeGC": {
            return OptionDescriptor.create(
                /*name*/ "VerifyBeforeGC",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify the heap before doing a garbage collection if VerifyHeap is enabled. Serial GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "VerifyBeforeGC",
                /*option*/ SerialGCOptions.VerifyBeforeGC,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyDuringGC": {
            return OptionDescriptor.create(
                /*name*/ "VerifyDuringGC",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify the heap during a garbage collection if VerifyHeap is enabled. Serial GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "VerifyDuringGC",
                /*option*/ SerialGCOptions.VerifyDuringGC,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyReferences": {
            return OptionDescriptor.create(
                /*name*/ "VerifyReferences",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify all object references if VerifyHeap is enabled. Serial GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "VerifyReferences",
                /*option*/ SerialGCOptions.VerifyReferences,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyReferencesPointIntoValidChunk": {
            return OptionDescriptor.create(
                /*name*/ "VerifyReferencesPointIntoValidChunk",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify that object references point into valid heap chunks if VerifyHeap is enabled. Serial GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "VerifyReferencesPointIntoValidChunk",
                /*option*/ SerialGCOptions.VerifyReferencesPointIntoValidChunk,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyRememberedSet": {
            return OptionDescriptor.create(
                /*name*/ "VerifyRememberedSet",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify the remembered set if VerifyHeap is enabled. Serial GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "VerifyRememberedSet",
                /*option*/ SerialGCOptions.VerifyRememberedSet,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyWriteBarriers": {
            return OptionDescriptor.create(
                /*name*/ "VerifyWriteBarriers",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify write barriers. Serial GC only.",
                /*declaringClass*/ SerialGCOptions.class,
                /*fieldName*/ "VerifyWriteBarriers",
                /*option*/ SerialGCOptions.VerifyWriteBarriers,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 21;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("CollectYoungGenerationSeparately");
                    case 1: return get("CountWriteBarriers");
                    case 2: return get("GreyToBlackObjRefDemographics");
                    case 3: return get("IgnoreMaxHeapSizeWhileInVMOperation");
                    case 4: return get("ImageHeapCardMarking");
                    case 5: return get("InitialCollectionPolicy");
                    case 6: return get("MaxHeapFree");
                    case 7: return get("MaxSurvivorSpaces");
                    case 8: return get("PercentTimeInIncrementalCollection");
                    case 9: return get("PrintGCSummary");
                    case 10: return get("PrintGCTimeStamps");
                    case 11: return get("PrintGCTimes");
                    case 12: return get("SoftRefLRUPolicyMSPerMB");
                    case 13: return get("TraceHeapChunks");
                    case 14: return get("VerifyAfterGC");
                    case 15: return get("VerifyBeforeGC");
                    case 16: return get("VerifyDuringGC");
                    case 17: return get("VerifyReferences");
                    case 18: return get("VerifyReferencesPointIntoValidChunk");
                    case 19: return get("VerifyRememberedSet");
                    case 20: return get("VerifyWriteBarriers");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
