/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.macho;

public enum MachOCpuType {
    X86_64,
    POWERPC64,
    ARM,
    ARM64;


    public static MachOCpuType from(int c) {
        switch (c) {
            case 0x1000007: {
                return X86_64;
            }
            case 0x1000012: {
                return POWERPC64;
            }
            case 12: {
                return ARM;
            }
            case 0x100000C: {
                return ARM64;
            }
        }
        throw new IllegalStateException("Unknown CPU type");
    }

    public static MachOCpuType from(String s) {
        switch (s) {
            case "amd64": 
            case "x86_64": {
                return X86_64;
            }
            case "arm64": 
            case "aarch64": {
                return ARM64;
            }
        }
        throw new IllegalStateException("Unknown CPU type: " + s);
    }

    public int toInt() {
        switch (this.ordinal()) {
            case 0: {
                return 0x1000007;
            }
            case 1: {
                return 0x1000012;
            }
            case 2: {
                return 12;
            }
            case 3: {
                return 0x100000C;
            }
        }
        throw new IllegalStateException("Should not reach here");
    }
}

