/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.elf.dwarf;

import com.oracle.objectfile.debugentry.ArrayTypeEntry;
import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.CompiledMethodEntry;
import com.oracle.objectfile.debugentry.FieldEntry;
import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debugentry.ForeignTypeEntry;
import com.oracle.objectfile.debugentry.HeaderTypeEntry;
import com.oracle.objectfile.debugentry.InterfaceClassEntry;
import com.oracle.objectfile.debugentry.MethodEntry;
import com.oracle.objectfile.debugentry.PrimitiveTypeEntry;
import com.oracle.objectfile.debugentry.StructureTypeEntry;
import com.oracle.objectfile.debugentry.TypeEntry;
import com.oracle.objectfile.debugentry.range.PrimaryRange;
import com.oracle.objectfile.debugentry.range.Range;
import com.oracle.objectfile.debugentry.range.SubRange;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import com.oracle.objectfile.elf.dwarf.DwarfDebugInfo;
import com.oracle.objectfile.elf.dwarf.DwarfSectionImpl;
import com.oracle.objectfile.elf.dwarf.constants.DwarfAccess;
import com.oracle.objectfile.elf.dwarf.constants.DwarfEncoding;
import com.oracle.objectfile.elf.dwarf.constants.DwarfExpressionOpcode;
import com.oracle.objectfile.elf.dwarf.constants.DwarfFlag;
import com.oracle.objectfile.elf.dwarf.constants.DwarfInline;
import com.oracle.objectfile.elf.dwarf.constants.DwarfLanguage;
import com.oracle.objectfile.elf.dwarf.constants.DwarfSectionName;
import com.oracle.objectfile.elf.dwarf.constants.DwarfVersion;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PrimitiveConstant;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.debug.DebugContext;

public class DwarfInfoSectionImpl
extends DwarfSectionImpl {
    private static final String OBJECT_HEADER_STRUCT_NAME = "_objhdr";
    private static final int DIE_HEADER_SIZE = 11;
    private int voidOffset = -1;
    private int cuStart = -1;

    public DwarfInfoSectionImpl(DwarfDebugInfo dwarfSections) {
        super(dwarfSections, DwarfSectionName.DW_INFO_SECTION, DwarfSectionName.DW_LOC_SECTION);
    }

    @Override
    public void createContent() {
        assert (!this.contentByteArrayCreated());
        byte[] buffer = null;
        int len = this.generateContent(null, buffer);
        buffer = new byte[len];
        super.setContent(buffer);
    }

    @Override
    public void writeContent(DebugContext context) {
        assert (this.contentByteArrayCreated());
        byte[] buffer = this.getContent();
        int size = buffer.length;
        int pos = 0;
        this.enableLog(context, pos);
        this.log(context, "  [0x%08x] DEBUG_INFO", pos);
        this.log(context, "  [0x%08x] size = 0x%08x", pos, size);
        pos = this.generateContent(context, buffer);
        assert (pos == size);
    }

    DwarfEncoding computeEncoding(int flags, int bitCount) {
        assert (bitCount > 0);
        if ((flags & 1) != 0) {
            if ((flags & 2) != 0) {
                if ((flags & 4) != 0) {
                    switch (bitCount) {
                        case 8: {
                            return DwarfEncoding.DW_ATE_signed_char;
                        }
                    }
                    assert (bitCount == 16 || bitCount == 32 || bitCount == 64);
                    return DwarfEncoding.DW_ATE_signed;
                }
                assert (bitCount == 16);
                return DwarfEncoding.DW_ATE_unsigned;
            }
            assert (bitCount == 32 || bitCount == 64);
            return DwarfEncoding.DW_ATE_float;
        }
        assert (bitCount == 1);
        return DwarfEncoding.DW_ATE_boolean;
    }

    public int generateContent(DebugContext context, byte[] buffer) {
        int pos = 0;
        pos = this.writeBuiltInTypes(context, buffer, pos);
        pos = this.writeInstanceClasses(context, buffer, pos);
        pos = this.writeArrays(context, buffer, pos);
        return pos;
    }

    private int writeBuiltInTypes(DebugContext context, byte[] buffer, int p) {
        int pos;
        int lengthPos = pos = p;
        this.log(context, "  [0x%08x] <0> Java Builtin Compile Unit", pos);
        this.cuStart = p;
        pos = this.writeCUHeader(buffer, pos);
        assert (pos == lengthPos + 11);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.BUILTIN_UNIT;
        this.log(context, "  [0x%08x] <0> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     language  %s", pos, "DW_LANG_Java");
        pos = this.writeAttrLanguage(DwarfDebugInfo.LANG_ENCODING, buffer, pos);
        this.log(context, "  [0x%08x]     use_UTF8", pos);
        pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        String name = this.uniqueDebugString("JAVA");
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeStrSectionOffset(name, buffer, pos);
        String compilationDirectory = this.dwarfSections.getCachePath();
        this.log(context, "  [0x%08x]     comp_dir  0x%x (%s)", pos, this.debugStringIndex(compilationDirectory), compilationDirectory);
        pos = this.writeStrSectionOffset(compilationDirectory, buffer, pos);
        pos = this.primitiveTypeStream().reduce(pos, (pos1, primitiveTypeEntry) -> {
            if (primitiveTypeEntry.getBitCount() > 0) {
                return this.writePrimitiveType(context, (PrimitiveTypeEntry)primitiveTypeEntry, buffer, (int)pos1);
            }
            return this.writeVoidType(context, (PrimitiveTypeEntry)primitiveTypeEntry, buffer, (int)pos1);
        }, (oldpos, newpos) -> newpos);
        pos = this.writeHeaderType(context, this.headerType(), buffer, pos);
        pos = this.primitiveTypeStream().reduce(pos, (pos1, primitiveTypeEntry) -> this.writeClassConstantDeclaration(context, (TypeEntry)primitiveTypeEntry, buffer, (int)pos1), (oldpos, newpos) -> newpos);
        pos = this.writeAttrNull(buffer, pos);
        this.patchLength(lengthPos, buffer, pos);
        return pos;
    }

    public int writePrimitiveType(DebugContext context, PrimitiveTypeEntry primitiveTypeEntry, byte[] buffer, int p) {
        assert (primitiveTypeEntry.getBitCount() > 0);
        int pos = p;
        this.log(context, "  [0x%08x] primitive type %s", pos, primitiveTypeEntry.getTypeName());
        this.setTypeIndex(primitiveTypeEntry, pos);
        this.setIndirectTypeIndex(primitiveTypeEntry, pos);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.PRIMITIVE_TYPE;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        byte byteSize = (byte)primitiveTypeEntry.getSize();
        this.log(context, "  [0x%08x]     byte_size  %d", pos, byteSize);
        pos = this.writeAttrData1(byteSize, buffer, pos);
        byte bitCount = (byte)primitiveTypeEntry.getBitCount();
        this.log(context, "  [0x%08x]     bitCount  %d", pos, bitCount);
        pos = this.writeAttrData1(bitCount, buffer, pos);
        DwarfEncoding encoding = this.computeEncoding(primitiveTypeEntry.getFlags(), bitCount);
        this.log(context, "  [0x%08x]     encoding  0x%x", pos, encoding.value());
        pos = this.writeAttrEncoding(encoding, buffer, pos);
        String name = primitiveTypeEntry.getTypeName();
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        return this.writeStrSectionOffset(name, buffer, pos);
    }

    public int writeVoidType(DebugContext context, PrimitiveTypeEntry primitiveTypeEntry, byte[] buffer, int p) {
        assert (primitiveTypeEntry.getBitCount() == 0);
        int pos = p;
        this.log(context, "  [0x%08x] primitive type void", pos);
        this.setTypeIndex(primitiveTypeEntry, pos);
        this.setIndirectTypeIndex(primitiveTypeEntry, pos);
        assert (this.voidOffset == -1 || this.voidOffset == pos);
        this.voidOffset = pos;
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.VOID_TYPE;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String name = primitiveTypeEntry.getTypeName();
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        return this.writeStrSectionOffset(name, buffer, pos);
    }

    public int writeHeaderType(DebugContext context, HeaderTypeEntry headerTypeEntry, byte[] buffer, int p) {
        int pos = p;
        String name = headerTypeEntry.getTypeName();
        byte size = (byte)headerTypeEntry.getSize();
        this.log(context, "  [0x%08x] header type %s", pos, name);
        this.setTypeIndex(headerTypeEntry, pos);
        this.setIndirectTypeIndex(headerTypeEntry, pos);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.OBJECT_HEADER;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeStrSectionOffset(name, buffer, pos);
        this.log(context, "  [0x%08x]     byte_size  0x%x", pos, size);
        pos = this.writeAttrData1(size, buffer, pos);
        pos = this.writeStructFields(context, headerTypeEntry.fields(), buffer, pos);
        return this.writeAttrNull(buffer, pos);
    }

    private int writeStructFields(DebugContext context, Stream<FieldEntry> fields, byte[] buffer, int p) {
        DwarfSectionImpl.Cursor cursor = new DwarfSectionImpl.Cursor(p);
        fields.forEach(fieldEntry -> cursor.set(this.writeStructField(context, (FieldEntry)fieldEntry, buffer, cursor.get())));
        return cursor.get();
    }

    private int writeStructField(DebugContext context, FieldEntry fieldEntry, byte[] buffer, int p) {
        int valueTypeIdx;
        int pos = p;
        String fieldName = fieldEntry.fieldName();
        TypeEntry valueType = fieldEntry.getValueType();
        if (fieldEntry.isEmbedded()) {
            ForeignTypeEntry foreignValueType = (ForeignTypeEntry)valueType;
            int fieldSize = fieldEntry.getSize();
            int valueSize = foreignValueType.getSize();
            if (fieldEntry.getSize() != foreignValueType.getSize()) {
                assert (fieldSize % valueSize == 0) : "embedded field size is not a multiple of value type size!";
                valueTypeIdx = pos;
                pos = this.writeEmbeddedArrayDataType(context, foreignValueType, valueSize, fieldSize / valueSize, buffer, pos);
            } else if (foreignValueType.isPointer()) {
                TypeEntry pointerTo = foreignValueType.getPointerTo();
                assert (pointerTo != null) : "ADDRESS field pointer type must have a known target type";
                valueTypeIdx = this.getTypeIndex(pointerTo);
            } else {
                valueTypeIdx = this.getIndirectLayoutIndex(foreignValueType);
            }
        } else {
            valueTypeIdx = this.getIndirectTypeIndex(valueType);
        }
        this.log(context, "  [0x%08x] struct field", pos);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.HEADER_FIELD;
        this.log(context, "  [0x%08x] <2> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(fieldName), fieldName);
        pos = this.writeStrSectionOffset(fieldName, buffer, pos);
        this.log(context, "  [0x%08x]     type 0x%x (%s)", pos, valueTypeIdx, valueType.getTypeName());
        pos = this.writeInfoSectionOffset(valueTypeIdx, buffer, pos);
        short offset = (short)fieldEntry.getOffset();
        int size = fieldEntry.getSize();
        this.log(context, "  [0x%08x]     offset 0x%x (size 0x%x)", pos, offset, size);
        pos = this.writeAttrData2(offset, buffer, pos);
        int modifiers = fieldEntry.getModifiers();
        this.log(context, "  [0x%08x]     modifiers %s", pos, fieldEntry.getModifiersString());
        return this.writeAttrAccessibility(modifiers, buffer, pos);
    }

    private int writeInstanceClasses(DebugContext context, byte[] buffer, int pos) {
        this.log(context, "  [0x%08x] instance classes", pos);
        DwarfSectionImpl.Cursor cursor = new DwarfSectionImpl.Cursor(pos);
        this.instanceClassStream().forEach(classEntry -> {
            this.cuStart = cursor.get();
            this.setCUIndex((ClassEntry)classEntry, this.cuStart);
            cursor.set(this.writeInstanceClassInfo(context, (ClassEntry)classEntry, buffer, cursor.get()));
        });
        return cursor.get();
    }

    private int writeInstanceClassInfo(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        String loaderId;
        int pos;
        int lengthPos = pos = p;
        this.log(context, "  [0x%08x] Instance class unit", pos);
        pos = this.writeCUHeader(buffer, pos);
        assert (pos == lengthPos + 11);
        DwarfDebugInfo.AbbrevCode abbrevCode = classEntry.hasCompiledEntries() ? DwarfDebugInfo.AbbrevCode.CLASS_UNIT_2 : DwarfDebugInfo.AbbrevCode.CLASS_UNIT_1;
        this.log(context, "  [0x%08x] <0> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     language  %s", pos, "DW_LANG_Java");
        pos = this.writeAttrLanguage(DwarfDebugInfo.LANG_ENCODING, buffer, pos);
        this.log(context, "  [0x%08x]     use_UTF8", pos);
        pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        Object name = classEntry.getFullFileName();
        if (name == null) {
            name = classEntry.getTypeName().replace('.', '/') + ".java";
        }
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex((String)name), name);
        pos = this.writeStrSectionOffset(this.uniqueDebugString((String)name), buffer, pos);
        String compilationDirectory = this.dwarfSections.getCachePath();
        this.log(context, "  [0x%08x]     comp_dir  0x%x (%s)", pos, this.debugStringIndex(compilationDirectory), compilationDirectory);
        pos = this.writeStrSectionOffset(compilationDirectory, buffer, pos);
        if (abbrevCode == DwarfDebugInfo.AbbrevCode.CLASS_UNIT_2) {
            int codeRangesIndex = this.getCodeRangesIndex(classEntry);
            this.log(context, "  [0x%08x]     ranges  0x%x", pos, codeRangesIndex);
            pos = this.writeRangesSectionOffset(codeRangesIndex, buffer, pos);
            int lo = classEntry.lowpc();
            this.log(context, "  [0x%08x]     low_pc  0x%x", pos, codeRangesIndex);
            pos = this.writeAttrAddress(lo, buffer, pos);
            int lineIndex = this.getLineIndex(classEntry);
            this.log(context, "  [0x%08x]     stmt_list  0x%x", pos, lineIndex);
            pos = this.writeLineSectionOffset(lineIndex, buffer, pos);
        }
        if (!(loaderId = classEntry.getLoaderId()).isEmpty()) {
            pos = this.writeNameSpace(context, loaderId, buffer, pos);
        }
        if (classEntry.isInterface()) {
            InterfaceClassEntry interfaceClassEntry = (InterfaceClassEntry)classEntry;
            pos = this.writeInterfaceLayout(context, interfaceClassEntry, buffer, pos);
            pos = this.writeInterfaceType(context, interfaceClassEntry, buffer, pos);
        } else if (classEntry.isForeign()) {
            ForeignTypeEntry foreignTypeEntry = (ForeignTypeEntry)classEntry;
            pos = this.writeForeignLayout(context, foreignTypeEntry, buffer, pos);
            pos = this.writeForeignType(context, foreignTypeEntry, buffer, pos);
        } else {
            pos = this.writeClassLayout(context, classEntry, buffer, pos);
            pos = this.writeClassType(context, classEntry, buffer, pos);
        }
        pos = this.writeClassConstantDeclaration(context, classEntry, buffer, pos);
        pos = this.writeMethodLocations(context, classEntry, buffer, pos);
        pos = this.writeAbstractInlineMethods(context, classEntry, buffer, pos);
        pos = this.writeStaticFieldLocations(context, classEntry, buffer, pos);
        if (!loaderId.isEmpty()) {
            pos = this.writeAttrNull(buffer, pos);
        }
        pos = this.writeAttrNull(buffer, pos);
        this.patchLength(lengthPos, buffer, pos);
        return pos;
    }

    private int writeNameSpace(DebugContext context, String id, byte[] buffer, int p) {
        int pos = p;
        String name = this.uniqueDebugString(id);
        assert (!id.isEmpty());
        this.log(context, "  [0x%08x] namespace %s", pos, name);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.NAMESPACE;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeStrSectionOffset(name, buffer, pos);
        return pos;
    }

    private int writeClassConstantDeclaration(DebugContext context, TypeEntry typeEntry, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] class constant", pos);
        long offset = typeEntry.getClassOffset();
        if (offset < 0L) {
            return pos;
        }
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.CLASS_CONSTANT;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String name = this.uniqueDebugString(typeEntry.getTypeName() + ".class");
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeStrSectionOffset(name, buffer, pos);
        ClassEntry valueType = this.dwarfSections.getHubClassEntry();
        int typeIdx = valueType == null ? -1 : this.getLayoutIndex(valueType);
        this.log(context, "  [0x%08x]     type  0x%x (<hub type>)", pos, typeIdx);
        pos = this.writeInfoSectionOffset(typeIdx, buffer, pos);
        this.log(context, "  [0x%08x]     accessibility public static final", pos);
        pos = this.writeAttrAccessibility(25, buffer, pos);
        this.log(context, "  [0x%08x]     external(true)", pos);
        pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        this.log(context, "  [0x%08x]     definition(true)", pos);
        pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        this.log(context, "  [0x%08x]     location  heapbase + 0x%x (class constant)", pos, offset);
        pos = this.writeHeapLocationExprLoc(offset, false, buffer, pos);
        return pos;
    }

    private int writeClassLayout(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        int superTypeOffset;
        String superName;
        ClassEntry superClassEntry;
        int pos;
        int layoutIndex = pos = p;
        this.setLayoutIndex(classEntry, layoutIndex);
        this.log(context, "  [0x%08x] class layout", pos);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.CLASS_LAYOUT_1;
        if (!this.dwarfSections.useHeapBase() && this.dwarfSections.isHubClassEntry(classEntry)) {
            abbrevCode = DwarfDebugInfo.AbbrevCode.CLASS_LAYOUT_2;
        }
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String name = classEntry.getTypeName();
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeStrSectionOffset(name, buffer, pos);
        int size = classEntry.getSize();
        this.log(context, "  [0x%08x]     byte_size 0x%x", pos, size);
        pos = this.writeAttrData2((short)size, buffer, pos);
        int fileIdx = classEntry.getFileIdx();
        this.log(context, "  [0x%08x]     file  0x%x (%s)", pos, fileIdx, classEntry.getFileName());
        pos = this.writeAttrData2((short)fileIdx, buffer, pos);
        if (abbrevCode == DwarfDebugInfo.AbbrevCode.CLASS_LAYOUT_2) {
            this.log(context, "  [0x%08x]     data_location", pos);
            pos = this.writeIndirectOopConversionExpression(true, buffer, pos);
        }
        if ((superClassEntry = classEntry.getSuperClass()) != null) {
            superName = superClassEntry.getTypeName();
            superTypeOffset = this.getLayoutIndex(superClassEntry);
        } else {
            superName = OBJECT_HEADER_STRUCT_NAME;
            HeaderTypeEntry headerType = this.headerType();
            superTypeOffset = this.getTypeIndex(headerType);
        }
        pos = this.writeSuperReference(context, superTypeOffset, superName, buffer, pos);
        pos = this.writeFields(context, classEntry, buffer, pos);
        pos = this.writeMethodDeclarations(context, classEntry, buffer, pos);
        pos = this.writeAttrNull(buffer, pos);
        if (this.dwarfSections.useHeapBase()) {
            this.setIndirectLayoutIndex(classEntry, pos);
            this.log(context, "  [0x%08x] indirect class layout", pos);
            abbrevCode = DwarfDebugInfo.AbbrevCode.INDIRECT_LAYOUT;
            this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
            pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
            String indirectName = this.uniqueDebugString("_z_." + classEntry.getTypeName());
            this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(indirectName), name);
            pos = this.writeStrSectionOffset(indirectName, buffer, pos);
            this.log(context, "  [0x%08x]     byte_size 0x%x", pos, size);
            pos = this.writeAttrData2((short)size, buffer, pos);
            this.log(context, "  [0x%08x]     data_location", pos);
            pos = this.writeIndirectOopConversionExpression(this.dwarfSections.isHubClassEntry(classEntry), buffer, pos);
            superTypeOffset = layoutIndex;
            pos = this.writeSuperReference(context, superTypeOffset, superName, buffer, pos);
            pos = this.writeAttrNull(buffer, pos);
        } else {
            this.log(context, "  [0x%08x] setIndirectLayoutIndex %s 0x%x", pos, classEntry.getTypeName(), pos);
            this.setIndirectLayoutIndex(classEntry, layoutIndex);
        }
        return pos;
    }

    private int writeSuperReference(DebugContext context, int superTypeOffset, String superName, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] super reference", pos);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.SUPER_REFERENCE;
        this.log(context, "  [0x%08x] <2> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     type 0x%x (%s)", pos, superTypeOffset, superName);
        pos = this.writeInfoSectionOffset(superTypeOffset, buffer, pos);
        this.log(context, "  [0x%08x]     data_member_location (super) 0x%x", pos, 0);
        pos = this.writeAttrData1((byte)0, buffer, pos);
        this.log(context, "  [0x%08x]     modifiers public", pos);
        int modifiers = 1;
        pos = this.writeAttrAccessibility(modifiers, buffer, pos);
        return pos;
    }

    private int writeFields(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        return classEntry.fields().filter(DwarfInfoSectionImpl::isManifestedField).reduce(p, (pos, fieldEntry) -> this.writeField(context, classEntry, (FieldEntry)fieldEntry, buffer, (int)pos), (oldPos, newPos) -> newPos);
    }

    private static boolean isManifestedField(FieldEntry fieldEntry) {
        return fieldEntry.getOffset() >= 0;
    }

    private int writeField(DebugContext context, StructureTypeEntry entry, FieldEntry fieldEntry, byte[] buffer, int p) {
        DwarfDebugInfo.AbbrevCode abbrevCode;
        int pos = p;
        int modifiers = fieldEntry.getModifiers();
        boolean hasFile = fieldEntry.getFileName().length() > 0;
        this.log(context, "  [0x%08x] field definition", pos);
        boolean isStatic = Modifier.isStatic(modifiers);
        if (!isStatic) {
            abbrevCode = !hasFile ? DwarfDebugInfo.AbbrevCode.FIELD_DECLARATION_1 : DwarfDebugInfo.AbbrevCode.FIELD_DECLARATION_2;
        } else {
            abbrevCode = !hasFile ? DwarfDebugInfo.AbbrevCode.FIELD_DECLARATION_3 : DwarfDebugInfo.AbbrevCode.FIELD_DECLARATION_4;
            this.setFieldDeclarationIndex(entry, fieldEntry.fieldName(), pos);
        }
        this.log(context, "  [0x%08x] <2> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String name = fieldEntry.fieldName();
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeStrSectionOffset(name, buffer, pos);
        if (hasFile) {
            assert (entry instanceof ClassEntry);
            int fileIdx = fieldEntry.getFileIdx();
            assert (fileIdx > 0);
            this.log(context, "  [0x%08x]     filename  0x%x (%s)", pos, fileIdx, fieldEntry.getFileName());
            pos = this.writeAttrData2((short)fileIdx, buffer, pos);
        }
        TypeEntry valueType = fieldEntry.getValueType();
        int typeIdx = this.getIndirectTypeIndex(valueType);
        this.log(context, "  [0x%08x]     type  0x%x (%s)", pos, typeIdx, valueType.getTypeName());
        pos = this.writeInfoSectionOffset(typeIdx, buffer, pos);
        if (!isStatic) {
            int memberOffset = fieldEntry.getOffset();
            this.log(context, "  [0x%08x]     member offset 0x%x", pos, memberOffset);
            pos = this.writeAttrData2((short)memberOffset, buffer, pos);
        }
        this.log(context, "  [0x%08x]     accessibility %s", pos, fieldEntry.getModifiersString());
        pos = this.writeAttrAccessibility(fieldEntry.getModifiers(), buffer, pos);
        if (isStatic) {
            this.log(context, "  [0x%08x]     external(true)", pos);
            pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
            this.log(context, "  [0x%08x]     definition(true)", pos);
            pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        }
        return pos;
    }

    private int writeMethodDeclarations(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        int pos = p;
        for (MethodEntry method : classEntry.getMethods()) {
            if (!method.isInRange() && !method.isInlined()) continue;
            pos = this.writeMethodDeclaration(context, classEntry, method, buffer, pos);
        }
        return pos;
    }

    private int writeMethodDeclaration(DebugContext context, ClassEntry classEntry, MethodEntry method, byte[] buffer, int p) {
        int pos = p;
        String methodKey = method.getSymbolName();
        String linkageName = this.uniqueDebugString(methodKey);
        this.setMethodDeclarationIndex(method, pos);
        int modifiers = method.getModifiers();
        boolean isStatic = Modifier.isStatic(modifiers);
        this.log(context, "  [0x%08x] method declaration %s::%s", pos, classEntry.getTypeName(), method.methodName());
        DwarfDebugInfo.AbbrevCode abbrevCode = isStatic ? DwarfDebugInfo.AbbrevCode.METHOD_DECLARATION_STATIC : DwarfDebugInfo.AbbrevCode.METHOD_DECLARATION;
        this.log(context, "  [0x%08x] <2> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     external  true", pos);
        pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        String name = this.uniqueDebugString(method.methodName());
        this.log(context, "  [0x%08x]     name 0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeStrSectionOffset(name, buffer, pos);
        FileEntry fileEntry = method.getFileEntry();
        if (fileEntry == null) {
            fileEntry = classEntry.getFileEntry();
        }
        assert (fileEntry != null);
        int fileIdx = classEntry.getFileIdx(fileEntry);
        this.log(context, "  [0x%08x]     file 0x%x (%s)", pos, fileIdx, fileEntry.getFullName());
        pos = this.writeAttrData2((short)fileIdx, buffer, pos);
        int line = method.getLine();
        this.log(context, "  [0x%08x]     line 0x%x", pos, line);
        pos = this.writeAttrData2((short)line, buffer, pos);
        this.log(context, "  [0x%08x]     linkage_name %s", pos, linkageName);
        pos = this.writeStrSectionOffset(linkageName, buffer, pos);
        TypeEntry returnType = method.getValueType();
        int retTypeIdx = this.getTypeIndex(returnType);
        this.log(context, "  [0x%08x]     type 0x%x (%s)", pos, retTypeIdx, returnType.getTypeName());
        pos = this.writeInfoSectionOffset(retTypeIdx, buffer, pos);
        this.log(context, "  [0x%08x]     artificial %s", pos, method.isDeopt() ? "true" : "false");
        pos = this.writeFlag(method.isDeopt() ? DwarfFlag.DW_FLAG_true : DwarfFlag.DW_FLAG_false, buffer, pos);
        this.log(context, "  [0x%08x]     accessibility %s", pos, "public");
        pos = this.writeAttrAccessibility(modifiers, buffer, pos);
        this.log(context, "  [0x%08x]     declaration true", pos);
        pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        int typeIdx = this.getLayoutIndex(classEntry);
        this.log(context, "  [0x%08x]     containing_type 0x%x (%s)", pos, typeIdx, classEntry.getTypeName());
        pos = this.writeAttrRef4(typeIdx, buffer, pos);
        if (abbrevCode == DwarfDebugInfo.AbbrevCode.METHOD_DECLARATION) {
            int objectPointerIndex = pos;
            pos = this.writeAttrRef4(0, null, pos);
            this.log(context, "  [0x%08x]     object_pointer 0x%x", objectPointerIndex, pos);
            this.writeAttrRef4(pos, buffer, objectPointerIndex);
        }
        pos = this.writeMethodParameterDeclarations(context, classEntry, method, fileIdx, 3, buffer, pos);
        pos = this.writeMethodLocalDeclarations(context, classEntry, method, fileIdx, 3, buffer, pos);
        return this.writeAttrNull(buffer, pos);
    }

    private int writeMethodParameterDeclarations(DebugContext context, ClassEntry classEntry, MethodEntry method, int fileIdx, int level, byte[] buffer, int p) {
        int refAddr;
        int pos = p;
        if (!Modifier.isStatic(method.getModifiers())) {
            refAddr = pos;
            DebugInfoProvider.DebugLocalInfo paramInfo = method.getThisParam();
            this.setMethodLocalIndex(classEntry, method, paramInfo, refAddr);
            pos = this.writeMethodParameterDeclaration(context, paramInfo, fileIdx, true, level, buffer, pos);
        }
        for (int i = 0; i < method.getParamCount(); ++i) {
            refAddr = pos;
            DebugInfoProvider.DebugLocalInfo paramInfo = method.getParam(i);
            this.setMethodLocalIndex(classEntry, method, paramInfo, refAddr);
            pos = this.writeMethodParameterDeclaration(context, paramInfo, fileIdx, false, level, buffer, pos);
        }
        return pos;
    }

    private int writeMethodParameterDeclaration(DebugContext context, DebugInfoProvider.DebugLocalInfo paramInfo, int fileIdx, boolean artificial, int level, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] method parameter declaration", pos);
        String paramName = paramInfo.name();
        TypeEntry paramType = this.lookupType(paramInfo.valueType());
        int line = paramInfo.line();
        DwarfDebugInfo.AbbrevCode abbrevCode = artificial ? DwarfDebugInfo.AbbrevCode.METHOD_PARAMETER_DECLARATION_1 : (line >= 0 ? DwarfDebugInfo.AbbrevCode.METHOD_PARAMETER_DECLARATION_2 : DwarfDebugInfo.AbbrevCode.METHOD_PARAMETER_DECLARATION_3);
        this.log(context, "  [0x%08x] <%d> Abbrev Number %d", pos, level, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     name %s", pos, paramName);
        pos = this.writeStrSectionOffset(this.uniqueDebugString(paramName), buffer, pos);
        if (abbrevCode == DwarfDebugInfo.AbbrevCode.METHOD_PARAMETER_DECLARATION_2) {
            this.log(context, "  [0x%08x]     file 0x%x", pos, fileIdx);
            pos = this.writeAttrData2((short)fileIdx, buffer, pos);
            this.log(context, "  [0x%08x]     line 0x%x", pos, line);
            pos = this.writeAttrData2((short)line, buffer, pos);
        }
        int typeIdx = this.getTypeIndex(paramType);
        this.log(context, "  [0x%08x]     type 0x%x (%s)", pos, typeIdx, paramType.getTypeName());
        pos = this.writeInfoSectionOffset(typeIdx, buffer, pos);
        if (abbrevCode == DwarfDebugInfo.AbbrevCode.METHOD_PARAMETER_DECLARATION_1) {
            this.log(context, "  [0x%08x]     artificial true", pos);
            pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        }
        this.log(context, "  [0x%08x]     declaration true", pos);
        pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        return pos;
    }

    private int writeMethodLocalDeclarations(DebugContext context, ClassEntry classEntry, MethodEntry method, int fileIdx, int level, byte[] buffer, int p) {
        int pos = p;
        for (int i = 0; i < method.getLocalCount(); ++i) {
            int refAddr = pos;
            DebugInfoProvider.DebugLocalInfo localInfo = method.getLocal(i);
            this.setMethodLocalIndex(classEntry, method, localInfo, refAddr);
            pos = this.writeMethodLocalDeclaration(context, localInfo, fileIdx, level, buffer, pos);
        }
        return pos;
    }

    private int writeMethodLocalDeclaration(DebugContext context, DebugInfoProvider.DebugLocalInfo paramInfo, int fileIdx, int level, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] method local declaration", pos);
        String paramName = paramInfo.name();
        TypeEntry paramType = this.lookupType(paramInfo.valueType());
        int line = paramInfo.line();
        DwarfDebugInfo.AbbrevCode abbrevCode = line >= 0 ? DwarfDebugInfo.AbbrevCode.METHOD_LOCAL_DECLARATION_1 : DwarfDebugInfo.AbbrevCode.METHOD_LOCAL_DECLARATION_2;
        this.log(context, "  [0x%08x] <%d> Abbrev Number %d", pos, level, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     name %s", pos, paramName);
        pos = this.writeStrSectionOffset(this.uniqueDebugString(paramName), buffer, pos);
        if (abbrevCode == DwarfDebugInfo.AbbrevCode.METHOD_LOCAL_DECLARATION_1) {
            this.log(context, "  [0x%08x]     file 0x%x", pos, fileIdx);
            pos = this.writeAttrData2((short)fileIdx, buffer, pos);
            this.log(context, "  [0x%08x]     line 0x%x", pos, line);
            pos = this.writeAttrData2((short)line, buffer, pos);
        }
        int typeIdx = this.getTypeIndex(paramType);
        this.log(context, "  [0x%08x]     type 0x%x (%s)", pos, typeIdx, paramType.getTypeName());
        pos = this.writeInfoSectionOffset(typeIdx, buffer, pos);
        this.log(context, "  [0x%08x]     declaration true", pos);
        pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        return pos;
    }

    private int writeInterfaceLayout(DebugContext context, InterfaceClassEntry interfaceClassEntry, byte[] buffer, int p) {
        int pos;
        int layoutOffset = pos = p;
        this.setLayoutIndex(interfaceClassEntry, layoutOffset);
        this.log(context, "  [0x%08x] interface layout", pos);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.INTERFACE_LAYOUT;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String name = interfaceClassEntry.getTypeName();
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeStrSectionOffset(name, buffer, pos);
        pos = this.writeInterfaceImplementors(context, interfaceClassEntry, buffer, pos);
        pos = this.writeMethodDeclarations(context, interfaceClassEntry, buffer, pos);
        pos = this.writeAttrNull(buffer, pos);
        if (this.dwarfSections.useHeapBase()) {
            this.setIndirectLayoutIndex(interfaceClassEntry, pos);
            this.log(context, "  [0x%08x] indirect class layout", pos);
            abbrevCode = DwarfDebugInfo.AbbrevCode.INDIRECT_LAYOUT;
            this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
            pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
            String indirectName = this.uniqueDebugString("_z_." + interfaceClassEntry.getTypeName());
            this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(indirectName), name);
            pos = this.writeStrSectionOffset(indirectName, buffer, pos);
            int size = interfaceClassEntry.getSize();
            this.log(context, "  [0x%08x]     byte_size 0x%x", pos, size);
            pos = this.writeAttrData2((short)size, buffer, pos);
            this.log(context, "  [0x%08x]     data_location", pos);
            pos = this.writeIndirectOopConversionExpression(false, buffer, pos);
            pos = this.writeSuperReference(context, layoutOffset, name, buffer, pos);
            pos = this.writeAttrNull(buffer, pos);
        } else {
            this.setIndirectLayoutIndex(interfaceClassEntry, layoutOffset);
        }
        return pos;
    }

    private int writeInterfaceImplementors(DebugContext context, InterfaceClassEntry interfaceClassEntry, byte[] buffer, int p) {
        return interfaceClassEntry.implementors().reduce(p, (pos, classEntry) -> this.writeInterfaceImplementor(context, (ClassEntry)classEntry, buffer, (int)pos), (oldPos, newPos) -> newPos);
    }

    private int writeInterfaceImplementor(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] interface implementor", pos);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.INTERFACE_IMPLEMENTOR;
        this.log(context, "  [0x%08x] <2> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String name = this.uniqueDebugString("_" + classEntry.getTypeName());
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeStrSectionOffset(name, buffer, pos);
        int layoutOffset = this.getLayoutIndex(classEntry);
        this.log(context, "  [0x%08x]     type  0x%x (%s)", pos, layoutOffset, classEntry.getTypeName());
        pos = this.writeInfoSectionOffset(layoutOffset, buffer, pos);
        int modifiers = 1;
        this.log(context, "  [0x%08x]     modifiers %s", pos, "public");
        pos = this.writeAttrAccessibility(modifiers, buffer, pos);
        return pos;
    }

    private int writeForeignLayout(DebugContext context, ForeignTypeEntry foreignTypeEntry, byte[] buffer, int p) {
        int pos = p;
        int size = foreignTypeEntry.getSize();
        int layoutOffset = pos;
        if (foreignTypeEntry.isWord()) {
            pos = this.writeForeignWordLayout(context, foreignTypeEntry, size, foreignTypeEntry.isSigned(), buffer, pos);
        } else if (foreignTypeEntry.isIntegral()) {
            pos = this.writeForeignIntegerLayout(context, foreignTypeEntry, size, foreignTypeEntry.isSigned(), buffer, pos);
        } else if (foreignTypeEntry.isFloat()) {
            pos = this.writeForeignFloatLayout(context, foreignTypeEntry, size, buffer, pos);
        } else if (foreignTypeEntry.isStruct()) {
            pos = this.writeForeignStructLayout(context, foreignTypeEntry, size, buffer, pos);
        } else {
            TypeEntry pointerTo;
            layoutOffset = this.voidOffset;
            String referentName = "void";
            if (foreignTypeEntry.isPointer() && (pointerTo = foreignTypeEntry.getPointerTo()) != null) {
                layoutOffset = this.getTypeIndex(foreignTypeEntry.getPointerTo());
                referentName = foreignTypeEntry.getTypeName();
            }
            this.log(context, "  [0x%08x] foreign pointer type %s referent 0x%x (%s)", pos, foreignTypeEntry.getTypeName(), layoutOffset, referentName);
        }
        this.setLayoutIndex(foreignTypeEntry, layoutOffset);
        pos = this.writeMethodDeclarations(context, foreignTypeEntry, buffer, pos);
        this.setIndirectLayoutIndex(foreignTypeEntry, layoutOffset);
        return pos;
    }

    private int writeForeignStructLayout(DebugContext context, ForeignTypeEntry foreignTypeEntry, int size, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] foreign struct type for %s", pos, foreignTypeEntry.getTypeName());
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.FOREIGN_STRUCT;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        Object typedefName = foreignTypeEntry.getTypedefName();
        if (typedefName == null) {
            typedefName = "_" + foreignTypeEntry.getTypeName();
            this.verboseLog(context, "  [0x%08x]   using synthetic typedef name %s", pos, typedefName);
        }
        if (((String)typedefName).startsWith("struct ")) {
            this.log(context, "  [0x%08x]     typedefName includes redundant keyword struct %s", pos, typedefName);
            typedefName = ((String)typedefName).substring("struct ".length());
        }
        typedefName = this.uniqueDebugString((String)typedefName);
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex((String)typedefName), typedefName);
        pos = this.writeStrSectionOffset((String)typedefName, buffer, pos);
        this.log(context, "  [0x%08x]     byte_size  0x%x", pos, size);
        pos = this.writeAttrData1((byte)size, buffer, pos);
        ForeignTypeEntry parent = foreignTypeEntry.getParent();
        if (parent != null) {
            int parentOffset = this.getLayoutIndex(parent);
            pos = this.writeSuperReference(context, parentOffset, parent.getTypedefName(), buffer, pos);
        }
        pos = this.writeStructFields(context, foreignTypeEntry.fields(), buffer, pos);
        return this.writeAttrNull(buffer, pos);
    }

    private int writeForeignWordLayout(DebugContext context, ForeignTypeEntry foreignTypeEntry, int size, boolean isSigned, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] foreign primitive word type for %s", pos, foreignTypeEntry.getTypeName());
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.PRIMITIVE_TYPE;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        assert (size >= 0);
        byte byteSize = (byte)(size > 0 ? size : this.dwarfSections.pointerSize());
        this.log(context, "  [0x%08x]     byte_size  %d", pos, byteSize);
        pos = this.writeAttrData1(byteSize, buffer, pos);
        byte bitCount = (byte)(byteSize * 8);
        this.log(context, "  [0x%08x]     bitCount  %d", pos, bitCount);
        pos = this.writeAttrData1(bitCount, buffer, pos);
        DwarfEncoding encoding = isSigned ? DwarfEncoding.DW_ATE_signed : DwarfEncoding.DW_ATE_unsigned;
        this.log(context, "  [0x%08x]     encoding  0x%x", pos, encoding.value());
        pos = this.writeAttrEncoding(encoding, buffer, pos);
        String name = this.uniqueDebugString(DwarfInfoSectionImpl.integralTypeName(byteSize, isSigned));
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        return this.writeStrSectionOffset(name, buffer, pos);
    }

    private int writeForeignIntegerLayout(DebugContext context, ForeignTypeEntry foreignTypeEntry, int size, boolean isSigned, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] foreign primitive integral type for %s", pos, foreignTypeEntry.getTypeName());
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.PRIMITIVE_TYPE;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        assert (size > 0);
        byte byteSize = (byte)size;
        this.log(context, "  [0x%08x]     byte_size  %d", pos, byteSize);
        pos = this.writeAttrData1(byteSize, buffer, pos);
        byte bitCount = (byte)(byteSize * 8);
        this.log(context, "  [0x%08x]     bitCount  %d", pos, bitCount);
        pos = this.writeAttrData1(bitCount, buffer, pos);
        DwarfEncoding encoding = isSigned ? DwarfEncoding.DW_ATE_signed : DwarfEncoding.DW_ATE_unsigned;
        this.log(context, "  [0x%08x]     encoding  0x%x", pos, encoding.value());
        pos = this.writeAttrEncoding(encoding, buffer, pos);
        String name = this.uniqueDebugString(DwarfInfoSectionImpl.integralTypeName(byteSize, isSigned));
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        return this.writeStrSectionOffset(name, buffer, pos);
    }

    private int writeForeignFloatLayout(DebugContext context, ForeignTypeEntry foreignTypeEntry, int size, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] foreign primitive float type for %s", pos, foreignTypeEntry.getTypeName());
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.PRIMITIVE_TYPE;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        assert (size > 0);
        byte byteSize = (byte)size;
        this.log(context, "  [0x%08x]     byte_size  %d", pos, byteSize);
        pos = this.writeAttrData1(byteSize, buffer, pos);
        byte bitCount = (byte)(byteSize * 8);
        this.log(context, "  [0x%08x]     bitCount  %d", pos, bitCount);
        pos = this.writeAttrData1(bitCount, buffer, pos);
        DwarfEncoding encoding = DwarfEncoding.DW_ATE_float;
        this.log(context, "  [0x%08x]     encoding  0x%x", pos, encoding.value());
        pos = this.writeAttrEncoding(encoding, buffer, pos);
        String name = this.uniqueDebugString(size == 4 ? "float" : (size == 8 ? "double" : "long double"));
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        return this.writeStrSectionOffset(name, buffer, pos);
    }

    private static String integralTypeName(int byteSize, boolean isSigned) {
        assert ((byteSize & byteSize - 1) == 0) : "expecting a power of 2!";
        StringBuilder stringBuilder = new StringBuilder();
        if (!isSigned) {
            stringBuilder.append('u');
        }
        stringBuilder.append("int");
        stringBuilder.append(8 * byteSize);
        stringBuilder.append("_t");
        return stringBuilder.toString();
    }

    private int writeClassType(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        int pos;
        int typeIdx = pos = p;
        this.setTypeIndex(classEntry, typeIdx);
        this.log(context, "  [0x%08x] class pointer type", pos);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.CLASS_POINTER;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        int pointerSize = this.dwarfSections.pointerSize();
        this.log(context, "  [0x%08x]     byte_size 0x%x", pos, pointerSize);
        pos = this.writeAttrData1((byte)pointerSize, buffer, pos);
        int layoutOffset = this.getLayoutIndex(classEntry);
        this.log(context, "  [0x%08x]     type 0x%x", pos, layoutOffset);
        pos = this.writeAttrRef4(layoutOffset, buffer, pos);
        if (this.dwarfSections.useHeapBase()) {
            this.setIndirectTypeIndex(classEntry, pos);
            this.log(context, "  [0x%08x] class indirect pointer type", pos);
            abbrevCode = DwarfDebugInfo.AbbrevCode.INDIRECT_POINTER;
            this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
            pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
            int oopReferenceSize = this.dwarfSections.oopReferenceSize();
            this.log(context, "  [0x%08x]     byte_size 0x%x", pos, oopReferenceSize);
            pos = this.writeAttrData1((byte)oopReferenceSize, buffer, pos);
            layoutOffset = this.getIndirectLayoutIndex(classEntry);
            this.log(context, "  [0x%08x]     type 0x%x", pos, layoutOffset);
            pos = this.writeAttrRef4(layoutOffset, buffer, pos);
        } else {
            this.setIndirectTypeIndex(classEntry, typeIdx);
        }
        return pos;
    }

    private int writeInterfaceType(DebugContext context, InterfaceClassEntry interfaceClassEntry, byte[] buffer, int p) {
        int pos;
        int typeIdx = pos = p;
        this.setTypeIndex(interfaceClassEntry, typeIdx);
        this.log(context, "  [0x%08x] interface pointer type", pos);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.INTERFACE_POINTER;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        int pointerSize = this.dwarfSections.pointerSize();
        this.log(context, "  [0x%08x]     byte_size 0x%x", pos, pointerSize);
        pos = this.writeAttrData1((byte)pointerSize, buffer, pos);
        int layoutOffset = this.getLayoutIndex(interfaceClassEntry);
        this.log(context, "  [0x%08x]     type 0x%x", pos, layoutOffset);
        pos = this.writeAttrRef4(layoutOffset, buffer, pos);
        if (this.dwarfSections.useHeapBase()) {
            this.setIndirectTypeIndex(interfaceClassEntry, pos);
            this.log(context, "  [0x%08x] interface indirect pointer type", pos);
            abbrevCode = DwarfDebugInfo.AbbrevCode.INDIRECT_POINTER;
            this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
            pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
            int byteSize = this.dwarfSections.oopReferenceSize();
            this.log(context, "  [0x%08x]     byte_size 0x%x", pos, byteSize);
            pos = this.writeAttrData1((byte)byteSize, buffer, pos);
            layoutOffset = this.getIndirectLayoutIndex(interfaceClassEntry);
            this.log(context, "  [0x%08x]     type 0x%x", pos, layoutOffset);
            pos = this.writeAttrRef4(layoutOffset, buffer, pos);
        } else {
            this.setIndirectTypeIndex(interfaceClassEntry, typeIdx);
        }
        return pos;
    }

    private int writeForeignType(DebugContext context, ForeignTypeEntry foreignTypeEntry, byte[] buffer, int p) {
        int pos = p;
        int layoutOffset = this.getLayoutIndex(foreignTypeEntry);
        int refTypeIdx = pos;
        this.log(context, "  [0x%08x] foreign pointer type", pos);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.FOREIGN_POINTER;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        int pointerSize = this.dwarfSections.pointerSize();
        this.log(context, "  [0x%08x]     byte_size 0x%x", pos, pointerSize);
        pos = this.writeAttrData1((byte)pointerSize, buffer, pos);
        this.log(context, "  [0x%08x]     type 0x%x", pos, layoutOffset);
        int typedefIdx = pos = this.writeInfoSectionOffset(layoutOffset, buffer, pos);
        this.log(context, "  [0x%08x] foreign typedef", pos);
        abbrevCode = DwarfDebugInfo.AbbrevCode.FOREIGN_TYPEDEF;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String name = this.uniqueDebugString(foreignTypeEntry.getTypeName());
        this.log(context, "  [0x%08x]     name %s", pos, name);
        pos = this.writeStrSectionOffset(name, buffer, pos);
        this.log(context, "  [0x%08x]     type 0x%x", pos, refTypeIdx);
        pos = this.writeAttrRef4(refTypeIdx, buffer, pos);
        this.setTypeIndex(foreignTypeEntry, typedefIdx);
        this.setIndirectTypeIndex(foreignTypeEntry, typedefIdx);
        return pos;
    }

    private int writeStaticFieldLocations(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        DwarfSectionImpl.Cursor cursor = new DwarfSectionImpl.Cursor(p);
        classEntry.fields().filter(DwarfInfoSectionImpl::isManifestedStaticField).forEach(fieldEntry -> cursor.set(this.writeClassStaticFieldLocation(context, classEntry, (FieldEntry)fieldEntry, buffer, cursor.get())));
        return cursor.get();
    }

    private static boolean isManifestedStaticField(FieldEntry fieldEntry) {
        return Modifier.isStatic(fieldEntry.getModifiers()) && fieldEntry.getOffset() >= 0;
    }

    private int writeClassStaticFieldLocation(DebugContext context, ClassEntry classEntry, FieldEntry fieldEntry, byte[] buffer, int p) {
        int pos = p;
        String fieldName = fieldEntry.fieldName();
        int fieldDefinitionOffset = this.getFieldDeclarationIndex(classEntry, fieldName);
        this.log(context, "  [0x%08x] static field location %s.%s", pos, classEntry.getTypeName(), fieldName);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.STATIC_FIELD_LOCATION;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     specification  0x%x", pos, fieldDefinitionOffset);
        pos = this.writeAttrRef4(fieldDefinitionOffset, buffer, pos);
        int offset = fieldEntry.getOffset();
        this.log(context, "  [0x%08x]     location  heapbase + 0x%x (%s)", pos, offset, fieldEntry.getValueType().isPrimitive() ? "primitive" : "object");
        pos = this.writeHeapLocationExprLoc(offset, buffer, pos);
        return pos;
    }

    private int writeArrays(DebugContext context, byte[] buffer, int p) {
        this.log(context, "  [0x%08x] array classes", p);
        DwarfSectionImpl.Cursor cursor = new DwarfSectionImpl.Cursor(p);
        this.arrayTypeStream().forEach(arrayTypeEntry -> {
            this.cuStart = cursor.get();
            cursor.set(this.writeArray(context, (ArrayTypeEntry)arrayTypeEntry, buffer, cursor.get()));
        });
        return cursor.get();
    }

    private int writeArray(DebugContext context, ArrayTypeEntry arrayTypeEntry, byte[] buffer, int p) {
        int pos;
        int lengthPos = pos = p;
        this.log(context, "  [0x%08x] Array class unit", pos);
        pos = this.writeCUHeader(buffer, pos);
        assert (pos == lengthPos + 11);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.CLASS_UNIT_1;
        this.log(context, "  [0x%08x] <0> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     language  %s", pos, "DW_LANG_Java");
        pos = this.writeAttrLanguage(DwarfDebugInfo.LANG_ENCODING, buffer, pos);
        this.log(context, "  [0x%08x]     use_UTF8", pos);
        pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        String name = this.uniqueDebugString("JAVA");
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeStrSectionOffset(name, buffer, pos);
        String compilationDirectory = this.dwarfSections.getCachePath();
        this.log(context, "  [0x%08x]     comp_dir  0x%x (%s)", pos, this.debugStringIndex(compilationDirectory), compilationDirectory);
        pos = this.writeStrSectionOffset(compilationDirectory, buffer, pos);
        String loaderId = arrayTypeEntry.getLoaderId();
        if (!loaderId.isEmpty()) {
            pos = this.writeNameSpace(context, loaderId, buffer, pos);
        }
        TypeEntry elementType = arrayTypeEntry.getElementType();
        int size = arrayTypeEntry.getSize();
        int layoutIdx = pos;
        int indirectLayoutIdx = pos = this.writeArrayLayout(context, arrayTypeEntry, elementType, size, buffer, pos);
        if (this.dwarfSections.useHeapBase()) {
            pos = this.writeIndirectArrayLayout(context, arrayTypeEntry, size, layoutIdx, buffer, pos);
        }
        pos = this.writeArrayTypes(context, arrayTypeEntry, layoutIdx, indirectLayoutIdx, buffer, pos);
        pos = this.writeClassConstantDeclaration(context, arrayTypeEntry, buffer, pos);
        if (!loaderId.isEmpty()) {
            pos = this.writeAttrNull(buffer, pos);
        }
        pos = this.writeAttrNull(buffer, pos);
        this.patchLength(lengthPos, buffer, pos);
        return pos;
    }

    private int writeArrayLayout(DebugContext context, ArrayTypeEntry arrayTypeEntry, TypeEntry elementType, int size, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] array layout", pos);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.ARRAY_LAYOUT;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String name = arrayTypeEntry.getTypeName();
        this.log(context, "  [0x%08x]     name 0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeStrSectionOffset(name, buffer, pos);
        this.log(context, "  [0x%08x]     byte_size  0x%x", pos, size);
        int arrayDataTypeIdx = pos = this.writeAttrData2((short)size, buffer, pos);
        pos = this.writeArrayDataType(context, elementType, buffer, pos);
        pos = this.writeFields(context, arrayTypeEntry, buffer, pos);
        pos = this.writeArrayElementField(context, size, arrayDataTypeIdx, buffer, pos);
        pos = this.writeArraySuperReference(context, buffer, pos);
        return this.writeAttrNull(buffer, pos);
    }

    private int writeFields(DebugContext context, ArrayTypeEntry arrayTypeEntry, byte[] buffer, int p) {
        DwarfSectionImpl.Cursor cursor = new DwarfSectionImpl.Cursor(p);
        arrayTypeEntry.fields().filter(DwarfInfoSectionImpl::isManifestedField).forEach(fieldEntry -> cursor.set(this.writeField(context, arrayTypeEntry, (FieldEntry)fieldEntry, buffer, cursor.get())));
        return cursor.get();
    }

    private int writeIndirectArrayLayout(DebugContext context, ArrayTypeEntry arrayTypeEntry, int size, int layoutOffset, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] indirect class layout", pos);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.INDIRECT_LAYOUT;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String name = arrayTypeEntry.getTypeName();
        String indirectName = this.uniqueDebugString("_z_." + name);
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(indirectName), name);
        pos = this.writeStrSectionOffset(indirectName, buffer, pos);
        this.log(context, "  [0x%08x]     byte_size 0x%x", pos, size);
        pos = this.writeAttrData2((short)size, buffer, pos);
        this.log(context, "  [0x%08x]     data_location", pos);
        pos = this.writeIndirectOopConversionExpression(false, buffer, pos);
        pos = this.writeSuperReference(context, layoutOffset, name, buffer, pos);
        return this.writeAttrNull(buffer, pos);
    }

    private int writeArrayDataType(DebugContext context, TypeEntry elementType, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] array element data type", pos);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.ARRAY_DATA_TYPE_1;
        this.log(context, "  [0x%08x] <2> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String elementTypeName = elementType.getTypeName();
        int elementTypeIdx = this.getIndirectTypeIndex(elementType);
        this.log(context, "  [0x%08x]     type idx 0x%x (%s)", pos, elementTypeIdx, elementTypeName);
        pos = this.writeInfoSectionOffset(elementTypeIdx, buffer, pos);
        return pos;
    }

    private int writeEmbeddedArrayDataType(DebugContext context, ForeignTypeEntry foreignValueType, int valueSize, int arraySize, byte[] buffer, int p) {
        int elementTypeIdx;
        int pos = p;
        this.log(context, "  [0x%08x] embedded array element data type", pos);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.ARRAY_DATA_TYPE_2;
        this.log(context, "  [0x%08x] <2> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        int size = arraySize * valueSize;
        this.log(context, "  [0x%08x]     byte_size 0x%x", pos, size);
        pos = this.writeAttrData4(size, buffer, pos);
        String elementTypeName = foreignValueType.getTypeName();
        if (foreignValueType.isPointer()) {
            TypeEntry pointerTo = foreignValueType.getPointerTo();
            assert (pointerTo != null) : "ADDRESS field pointer type must have a known target type";
            elementTypeIdx = this.getTypeIndex(pointerTo);
        } else {
            elementTypeIdx = this.getIndirectLayoutIndex(foreignValueType);
        }
        this.log(context, "  [0x%08x]     type idx 0x%x (%s)", pos, elementTypeIdx, elementTypeName);
        pos = this.writeInfoSectionOffset(elementTypeIdx, buffer, pos);
        this.log(context, "  [0x%08x] embedded array element range", pos);
        abbrevCode = DwarfDebugInfo.AbbrevCode.ARRAY_SUBRANGE;
        this.log(context, "  [0x%08x] <3> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     count 0x%x", pos, arraySize);
        pos = this.writeAttrData4(arraySize, buffer, pos);
        return this.writeAttrNull(buffer, pos);
    }

    private int writeArrayElementField(DebugContext context, int offset, int arrayDataTypeIdx, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] array element data field", pos);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.HEADER_FIELD;
        this.log(context, "  [0x%08x] <2> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String fieldName = this.uniqueDebugString("data");
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(fieldName), fieldName);
        pos = this.writeStrSectionOffset(fieldName, buffer, pos);
        this.log(context, "  [0x%08x]     type idx 0x%x", pos, arrayDataTypeIdx);
        pos = this.writeInfoSectionOffset(arrayDataTypeIdx, buffer, pos);
        int size = 0;
        this.log(context, "  [0x%08x]     offset 0x%x (size 0x%x)", pos, offset, size);
        pos = this.writeAttrData2((short)offset, buffer, pos);
        int modifiers = 1;
        this.log(context, "  [0x%08x]     modifiers %s", pos, "public");
        return this.writeAttrAccessibility(modifiers, buffer, pos);
    }

    private int writeArraySuperReference(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        ClassEntry objectType = this.lookupObjectClass();
        String superName = objectType.getTypeName();
        assert (objectType != null);
        assert (objectType instanceof ClassEntry);
        int superOffset = this.getLayoutIndex(objectType);
        return this.writeSuperReference(context, superOffset, superName, buffer, pos);
    }

    private int writeArrayTypes(DebugContext context, ArrayTypeEntry arrayTypeEntry, int layoutOffset, int indirectLayoutOffset, byte[] buffer, int p) {
        int pos = p;
        String name = this.uniqueDebugString(arrayTypeEntry.getTypeName());
        int typeIdx = pos;
        this.setTypeIndex(arrayTypeEntry, pos);
        this.log(context, "  [0x%08x] array pointer type", pos);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.ARRAY_POINTER;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        int pointerSize = this.dwarfSections.pointerSize();
        this.log(context, "  [0x%08x]     byte_size  0x%x", pos, pointerSize);
        pos = this.writeAttrData1((byte)pointerSize, buffer, pos);
        this.log(context, "  [0x%08x]     type (pointer) 0x%x (%s)", pos, layoutOffset, name);
        pos = this.writeAttrRef4(layoutOffset, buffer, pos);
        if (this.dwarfSections.useHeapBase()) {
            this.setIndirectTypeIndex(arrayTypeEntry, pos);
            this.log(context, "  [0x%08x] array indirect pointer type", pos);
            abbrevCode = DwarfDebugInfo.AbbrevCode.INDIRECT_POINTER;
            this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
            pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
            int byteSize = this.dwarfSections.oopReferenceSize();
            this.log(context, "  [0x%08x]     byte_size  0x%x", pos, byteSize);
            pos = this.writeAttrData1((byte)byteSize, buffer, pos);
            this.log(context, "  [0x%08x]     type (pointer) 0x%x (%s)", pos, indirectLayoutOffset, name);
            pos = this.writeAttrRef4(indirectLayoutOffset, buffer, pos);
        } else {
            this.setIndirectTypeIndex(arrayTypeEntry, typeIdx);
        }
        return pos;
    }

    private int writeMethodLocations(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        DwarfSectionImpl.Cursor cursor = new DwarfSectionImpl.Cursor(p);
        classEntry.compiledEntries().forEach(compiledMethodEntry -> cursor.set(this.writeMethodLocation(context, classEntry, (CompiledMethodEntry)compiledMethodEntry, buffer, cursor.get())));
        return cursor.get();
    }

    private int writeMethodLocation(DebugContext context, ClassEntry classEntry, CompiledMethodEntry compiledEntry, byte[] buffer, int p) {
        int pos = p;
        PrimaryRange primary = compiledEntry.getPrimary();
        this.log(context, "  [0x%08x] method location", pos);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.METHOD_LOCATION;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     lo_pc  0x%08x", pos, primary.getLo());
        pos = this.writeAttrAddress(primary.getLo(), buffer, pos);
        this.log(context, "  [0x%08x]     hi_pc  0x%08x", pos, primary.getHi());
        pos = this.writeAttrAddress(primary.getHi(), buffer, pos);
        this.log(context, "  [0x%08x]     external  true", pos);
        pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        String methodKey = primary.getSymbolName();
        int methodSpecOffset = this.getMethodDeclarationIndex(primary.getMethodEntry());
        this.log(context, "  [0x%08x]     specification  0x%x (%s)", pos, methodSpecOffset, methodKey);
        pos = this.writeAttrRef4(methodSpecOffset, buffer, pos);
        HashMap<DebugInfoProvider.DebugLocalInfo, List<SubRange>> varRangeMap = primary.getVarRangeMap();
        pos = this.writeMethodParameterLocations(context, classEntry, varRangeMap, primary, 2, buffer, pos);
        pos = this.writeMethodLocalLocations(context, classEntry, varRangeMap, primary, 2, buffer, pos);
        if (primary.includesInlineRanges()) {
            pos = this.generateConcreteInlinedMethods(context, classEntry, compiledEntry, buffer, pos);
        }
        return this.writeAttrNull(buffer, pos);
    }

    private int writeMethodParameterLocations(DebugContext context, ClassEntry classEntry, HashMap<DebugInfoProvider.DebugLocalInfo, List<SubRange>> varRangeMap, Range range, int depth, byte[] buffer, int p) {
        MethodEntry methodEntry;
        int pos = p;
        if (range.isPrimary()) {
            methodEntry = range.getMethodEntry();
        } else {
            assert (!range.isLeaf()) : "should only be looking up var ranges for inlined calls";
            methodEntry = range.getFirstCallee().getMethodEntry();
        }
        if (!Modifier.isStatic(methodEntry.getModifiers())) {
            DebugInfoProvider.DebugLocalInfo thisParamInfo = methodEntry.getThisParam();
            int refAddr = this.getMethodLocalIndex(classEntry, methodEntry, thisParamInfo);
            List<SubRange> ranges = varRangeMap.get(thisParamInfo);
            pos = this.writeMethodLocalLocation(context, range, thisParamInfo, refAddr, ranges, depth, true, buffer, pos);
        }
        for (int i = 0; i < methodEntry.getParamCount(); ++i) {
            DebugInfoProvider.DebugLocalInfo paramInfo = methodEntry.getParam(i);
            int refAddr = this.getMethodLocalIndex(classEntry, methodEntry, paramInfo);
            List<SubRange> ranges = varRangeMap.get(paramInfo);
            pos = this.writeMethodLocalLocation(context, range, paramInfo, refAddr, ranges, depth, true, buffer, pos);
        }
        return pos;
    }

    private int writeMethodLocalLocations(DebugContext context, ClassEntry classEntry, HashMap<DebugInfoProvider.DebugLocalInfo, List<SubRange>> varRangeMap, Range range, int depth, byte[] buffer, int p) {
        MethodEntry methodEntry;
        int pos = p;
        if (range.isPrimary()) {
            methodEntry = range.getMethodEntry();
        } else {
            assert (!range.isLeaf()) : "should only be looking up var ranges for inlined calls";
            methodEntry = range.getFirstCallee().getMethodEntry();
        }
        int count = methodEntry.getLocalCount();
        for (int i = 0; i < count; ++i) {
            DebugInfoProvider.DebugLocalInfo localInfo = methodEntry.getLocal(i);
            int refAddr = this.getMethodLocalIndex(classEntry, methodEntry, localInfo);
            List<SubRange> ranges = varRangeMap.get(localInfo);
            pos = this.writeMethodLocalLocation(context, range, localInfo, refAddr, ranges, depth, false, buffer, pos);
        }
        return pos;
    }

    private int writeMethodLocalLocation(DebugContext context, Range range, DebugInfoProvider.DebugLocalInfo localInfo, int refAddr, List<SubRange> ranges, int depth, boolean isParam, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] method %s location %s:%s", pos, isParam ? "parameter" : "local", localInfo.name(), localInfo.typeName());
        ArrayList<DebugInfoProvider.DebugLocalValueInfo> localValues = new ArrayList<DebugInfoProvider.DebugLocalValueInfo>();
        for (SubRange subrange : ranges) {
            DebugInfoProvider.DebugLocalValueInfo value = subrange.lookupValue(localInfo);
            if (value == null) continue;
            this.log(context, "  [0x%08x]     local  %s:%s [0x%x, 0x%x] = %s", pos, value.name(), value.typeName(), subrange.getLo(), subrange.getHi(), DwarfInfoSectionImpl.formatValue(value));
            switch (value.localKind()) {
                case REGISTER: 
                case STACKSLOT: {
                    localValues.add(value);
                    break;
                }
                case CONSTANT: {
                    JavaConstant constant = value.constantValue();
                    if (!(constant instanceof PrimitiveConstant) && constant.getJavaKind() != JavaKind.Object) break;
                    localValues.add(value);
                    break;
                }
            }
        }
        DwarfDebugInfo.AbbrevCode abbrevCode = localValues.isEmpty() ? (isParam ? DwarfDebugInfo.AbbrevCode.METHOD_PARAMETER_LOCATION_1 : DwarfDebugInfo.AbbrevCode.METHOD_LOCAL_LOCATION_1) : (isParam ? DwarfDebugInfo.AbbrevCode.METHOD_PARAMETER_LOCATION_2 : DwarfDebugInfo.AbbrevCode.METHOD_LOCAL_LOCATION_2);
        this.log(context, "  [0x%08x] <%d> Abbrev Number %d", pos, depth, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     specification  0x%x", pos, refAddr);
        pos = this.writeAttrRef4(refAddr, buffer, pos);
        if (abbrevCode == DwarfDebugInfo.AbbrevCode.METHOD_LOCAL_LOCATION_2 || abbrevCode == DwarfDebugInfo.AbbrevCode.METHOD_PARAMETER_LOCATION_2) {
            int locRefAddr = this.getRangeLocalIndex(range, localInfo);
            this.log(context, "  [0x%08x]     loc list  0x%x", pos, locRefAddr);
            pos = this.writeLocSectionOffset(locRefAddr, buffer, pos);
        }
        return pos;
    }

    private int generateConcreteInlinedMethods(DebugContext context, ClassEntry classEntry, CompiledMethodEntry compiledEntry, byte[] buffer, int p) {
        PrimaryRange primary = compiledEntry.getPrimary();
        if (((Range)primary).isLeaf()) {
            return p;
        }
        int pos = p;
        this.log(context, "  [0x%08x] concrete entries [0x%x,0x%x] %s", pos, primary.getLo(), primary.getHi(), primary.getFullMethodName());
        int depth = 0;
        Iterator<SubRange> iterator = compiledEntry.topDownRangeIterator();
        while (iterator.hasNext()) {
            SubRange subrange = iterator.next();
            if (subrange.isLeaf()) continue;
            while (depth > subrange.getDepth()) {
                pos = this.writeAttrNull(buffer, pos);
                --depth;
            }
            depth = subrange.getDepth();
            pos = this.writeInlineSubroutine(context, classEntry, subrange, depth + 2, buffer, pos);
            HashMap<DebugInfoProvider.DebugLocalInfo, List<SubRange>> varRangeMap = subrange.getVarRangeMap();
            pos = this.writeMethodParameterLocations(context, classEntry, varRangeMap, subrange, ++depth + 2, buffer, pos);
            pos = this.writeMethodLocalLocations(context, classEntry, varRangeMap, subrange, depth + 2, buffer, pos);
        }
        while (depth > 0) {
            pos = this.writeAttrNull(buffer, pos);
            --depth;
        }
        return pos;
    }

    private int writeInlineSubroutine(DebugContext context, ClassEntry classEntry, SubRange caller, int depth, byte[] buffer, int p) {
        int fileIndex;
        assert (!caller.isLeaf());
        SubRange callee = caller.getFirstCallee();
        MethodEntry methodEntry = callee.getMethodEntry();
        String methodKey = methodEntry.getSymbolName();
        int abstractOriginIndex = classEntry == methodEntry.ownerType() ? this.getMethodDeclarationIndex(methodEntry) : this.getAbstractInlineMethodIndex(classEntry, methodEntry);
        int pos = p;
        this.log(context, "  [0x%08x] concrete inline subroutine [0x%x, 0x%x] %s", pos, caller.getLo(), caller.getHi(), methodKey);
        int callLine = caller.getLine();
        assert (callLine >= -1) : callLine;
        if (callLine == -1) {
            this.log(context, "  Unable to retrieve call line for inlined method %s", callee.getFullMethodName());
            callLine = 0;
            fileIndex = classEntry.getFileIdx();
        } else {
            FileEntry subFileEntry = caller.getFileEntry();
            if (subFileEntry != null) {
                fileIndex = classEntry.getFileIdx(subFileEntry);
            } else {
                this.log(context, "  Unable to retrieve caller FileEntry for inlined method %s (caller method %s)", callee.getFullMethodName(), caller.getFullMethodName());
                fileIndex = classEntry.getFileIdx();
            }
        }
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.INLINED_SUBROUTINE_WITH_CHILDREN;
        this.log(context, "  [0x%08x] <%d> Abbrev Number %d", pos, depth, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     abstract_origin  0x%x", pos, abstractOriginIndex);
        pos = this.writeAttrRef4(abstractOriginIndex, buffer, pos);
        this.log(context, "  [0x%08x]     lo_pc  0x%08x", pos, caller.getLo());
        pos = this.writeAttrAddress(caller.getLo(), buffer, pos);
        this.log(context, "  [0x%08x]     hi_pc  0x%08x", pos, caller.getHi());
        pos = this.writeAttrAddress(caller.getHi(), buffer, pos);
        this.log(context, "  [0x%08x]     call_file  %d", pos, fileIndex);
        pos = this.writeAttrData4(fileIndex, buffer, pos);
        this.log(context, "  [0x%08x]     call_line  %d", pos, callLine);
        pos = this.writeAttrData4(callLine, buffer, pos);
        return pos;
    }

    private int writeAbstractInlineMethods(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        EconomicSet<MethodEntry> inlinedMethods = this.collectInlinedMethods(context, classEntry, p);
        int pos = p;
        for (MethodEntry methodEntry : inlinedMethods) {
            this.setAbstractInlineMethodIndex(classEntry, methodEntry, pos);
            pos = this.writeAbstractInlineMethod(context, classEntry, methodEntry, buffer, pos);
        }
        return pos;
    }

    private EconomicSet<MethodEntry> collectInlinedMethods(DebugContext context, ClassEntry classEntry, int p) {
        EconomicSet methods = EconomicSet.create();
        classEntry.compiledEntries().forEach(compiledEntry -> this.addInlinedMethods(context, (CompiledMethodEntry)compiledEntry, compiledEntry.getPrimary(), (EconomicSet<MethodEntry>)methods, p));
        return methods;
    }

    private void addInlinedMethods(DebugContext context, CompiledMethodEntry compiledEntry, Range primary, EconomicSet<MethodEntry> hashSet, int p) {
        if (primary.isLeaf()) {
            return;
        }
        this.verboseLog(context, "  [0x%08x] collect abstract inlined methods %s", p, primary.getFullMethodName());
        Iterator<SubRange> iterator = compiledEntry.topDownRangeIterator();
        while (iterator.hasNext()) {
            SubRange callee;
            MethodEntry methodEntry;
            SubRange subrange = iterator.next();
            if (subrange.isLeaf() || !hashSet.add((Object)(methodEntry = (callee = subrange.getFirstCallee()).getMethodEntry()))) continue;
            this.verboseLog(context, "  [0x%08x]   add abstract inlined method %s", p, methodEntry.getSymbolName());
        }
    }

    private int writeAbstractInlineMethod(DebugContext context, ClassEntry classEntry, MethodEntry method, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] abstract inline method %s::%s", pos, classEntry.getTypeName(), method.methodName());
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.ABSTRACT_INLINE_METHOD;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     inline  0x%x", pos, DwarfInline.DW_INL_inlined.value());
        pos = this.writeAttrInline(DwarfInline.DW_INL_inlined, buffer, pos);
        this.log(context, "  [0x%08x]     external  true", pos);
        pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        int methodSpecOffset = this.getMethodDeclarationIndex(method);
        this.log(context, "  [0x%08x]     specification  0x%x", pos, methodSpecOffset);
        pos = this.writeInfoSectionOffset(methodSpecOffset, buffer, pos);
        if (classEntry != method.ownerType()) {
            FileEntry fileEntry = method.getFileEntry();
            if (fileEntry == null) {
                fileEntry = classEntry.getFileEntry();
            }
            assert (fileEntry != null);
            int fileIdx = classEntry.getFileIdx(fileEntry);
            int level = 3;
            pos = this.writeMethodParameterDeclarations(context, classEntry, method, fileIdx, level, buffer, pos);
            pos = this.writeMethodLocalDeclarations(context, classEntry, method, fileIdx, level, buffer, pos);
        }
        return this.writeAttrNull(buffer, pos);
    }

    private int writeAttrRef4(int reference, byte[] buffer, int p) {
        assert (this.cuStart >= 0);
        return this.writeAttrData4(reference - this.cuStart, buffer, p);
    }

    private int writeCUHeader(byte[] buffer, int p) {
        int pos = p;
        pos = this.writeInt(0, buffer, pos);
        pos = this.writeDwarfVersion(DwarfVersion.DW_VERSION_4, buffer, pos);
        pos = this.writeAbbrevSectionOffset(0, buffer, pos);
        return this.writeByte((byte)8, buffer, pos);
    }

    public int writeAttrString(String value, byte[] buffer, int p) {
        int pos = p;
        return this.writeUTF8StringBytes(value, buffer, pos);
    }

    public int writeAttrLanguage(DwarfLanguage language, byte[] buffer, int p) {
        int pos = p;
        return this.writeByte(language.value(), buffer, pos);
    }

    public int writeAttrEncoding(DwarfEncoding encoding, byte[] buffer, int p) {
        return this.writeByte(encoding.value(), buffer, p);
    }

    public int writeAttrInline(DwarfInline inline, byte[] buffer, int p) {
        return this.writeByte(inline.value(), buffer, p);
    }

    public int writeAttrAccessibility(int modifiers, byte[] buffer, int p) {
        DwarfAccess access = Modifier.isPublic(modifiers) ? DwarfAccess.DW_ACCESS_public : (Modifier.isProtected(modifiers) ? DwarfAccess.DW_ACCESS_protected : (Modifier.isPrivate(modifiers) ? DwarfAccess.DW_ACCESS_private : DwarfAccess.DW_ACCESS_public));
        return this.writeByte(access.value(), buffer, p);
    }

    public int writeIndirectOopConversionExpression(boolean isHub, byte[] buffer, int p) {
        int pos = p;
        boolean useHeapBase = this.dwarfSections.useHeapBase();
        int oopCompressShift = this.dwarfSections.oopCompressShift();
        byte oopTagsShift = this.dwarfSections.oopTagsShift();
        int oopAlignShift = this.dwarfSections.oopAlignShift();
        byte mask = 0;
        byte rightShift = 0;
        int leftShift = 0;
        int exprSize = 0;
        if (!useHeapBase) {
            assert (isHub);
            mask = this.dwarfSections.oopTagsMask();
            assert (mask != 0);
            exprSize += 4;
        } else {
            exprSize += 10;
            if (isHub) {
                if (oopCompressShift == 0) {
                    oopCompressShift = oopAlignShift;
                }
                if (oopCompressShift == oopTagsShift) {
                    mask = this.dwarfSections.oopTagsMask();
                    exprSize += 3;
                } else {
                    if (oopTagsShift != 0) {
                        rightShift = oopTagsShift;
                        exprSize += 2;
                    }
                    leftShift = oopCompressShift;
                    exprSize += 2;
                }
            } else if (oopCompressShift != 0) {
                leftShift = oopCompressShift;
                exprSize += 2;
            }
        }
        int exprStart = pos = this.writeULEB(exprSize, buffer, pos);
        if (!useHeapBase) {
            pos = this.writeExprOpcode(DwarfExpressionOpcode.DW_OP_push_object_address, buffer, pos);
            pos = this.writeExprOpcodeLiteral(mask, buffer, pos);
            pos = this.writeExprOpcode(DwarfExpressionOpcode.DW_OP_not, buffer, pos);
            pos = this.writeExprOpcode(DwarfExpressionOpcode.DW_OP_and, buffer, pos);
        } else {
            pos = this.writeExprOpcode(DwarfExpressionOpcode.DW_OP_push_object_address, buffer, pos);
            pos = this.writeExprOpcode(DwarfExpressionOpcode.DW_OP_dup, buffer, pos);
            pos = this.writeExprOpcode(DwarfExpressionOpcode.DW_OP_lit0, buffer, pos);
            pos = this.writeExprOpcode(DwarfExpressionOpcode.DW_OP_eq, buffer, pos);
            int skipStart = pos + 3;
            short offsetToEnd = (short)(exprSize - (skipStart - exprStart));
            pos = this.writeExprOpcode(DwarfExpressionOpcode.DW_OP_bra, buffer, pos);
            pos = this.writeShort(offsetToEnd, buffer, pos);
            if (mask != 0) {
                pos = this.writeExprOpcodeLiteral(mask, buffer, pos);
                pos = this.writeExprOpcode(DwarfExpressionOpcode.DW_OP_not, buffer, pos);
                pos = this.writeExprOpcode(DwarfExpressionOpcode.DW_OP_and, buffer, pos);
            } else {
                if (rightShift != 0) {
                    pos = this.writeExprOpcodeLiteral(rightShift, buffer, pos);
                    pos = this.writeExprOpcode(DwarfExpressionOpcode.DW_OP_shr, buffer, pos);
                }
                if (leftShift != 0) {
                    pos = this.writeExprOpcodeLiteral(leftShift, buffer, pos);
                    pos = this.writeExprOpcode(DwarfExpressionOpcode.DW_OP_shl, buffer, pos);
                }
            }
            pos = this.writeExprOpcodeBReg(this.dwarfSections.getHeapbaseRegister(), buffer, pos);
            pos = this.writeSLEB(0L, buffer, pos);
            pos = this.writeExprOpcode(DwarfExpressionOpcode.DW_OP_plus, buffer, pos);
            assert (pos == skipStart + offsetToEnd);
            assert (pos == exprStart + exprSize);
        }
        return pos;
    }
}

