/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debuginfo;

import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.DebugContext;

public interface DebugInfoProvider {
    public boolean useHeapBase();

    public int oopCompressShift();

    public int oopTagsMask();

    public int oopReferenceSize();

    public int pointerSize();

    public int oopAlignment();

    public int compiledCodeMax();

    public Stream<DebugTypeInfo> typeInfoProvider();

    public Stream<DebugCodeInfo> codeInfoProvider();

    public Stream<DebugDataInfo> dataInfoProvider();

    public Path getCachePath();

    public void recordActivity();

    public static interface DebugFrameSizeChange {
        public int getOffset();

        public Type getType();

        public static enum Type {
            EXTEND,
            CONTRACT;

        }
    }

    public static interface DebugLocalValueInfo
    extends DebugLocalInfo {
        public LocalKind localKind();

        public int regIndex();

        public int stackSlot();

        public long heapOffset();

        public JavaConstant constantValue();

        public static enum LocalKind {
            UNDEFINED,
            REGISTER,
            STACKSLOT,
            CONSTANT;

        }
    }

    public static interface DebugLocalInfo {
        public ResolvedJavaType valueType();

        public String name();

        public String typeName();

        public int slot();

        public int slotCount();

        public JavaKind javaKind();

        public int line();
    }

    public static interface DebugLocationInfo
    extends DebugRangeInfo {
        public DebugLocationInfo getCaller();

        public DebugLocalValueInfo[] getLocalValueInfo();

        public boolean isLeaf();
    }

    public static interface DebugDataInfo {
        public void debugContext(Consumer<DebugContext> var1);

        public String getProvenance();

        public String getTypeName();

        public String getPartition();

        public long getOffset();

        public long getAddress();

        public long getSize();
    }

    public static interface DebugCodeInfo
    extends DebugRangeInfo {
        public void debugContext(Consumer<DebugContext> var1);

        public Stream<DebugLocationInfo> locationInfoProvider();

        public int getFrameSize();

        public List<DebugFrameSizeChange> getFrameSizeChanges();
    }

    public static interface DebugRangeInfo
    extends DebugMethodInfo {
        public int addressLo();

        public int addressHi();
    }

    public static interface DebugMethodInfo
    extends DebugMemberInfo {
        public int line();

        public DebugLocalInfo[] getParamInfo();

        public DebugLocalInfo getThisParamInfo();

        public String symbolNameForMethod();

        public boolean isDeoptTarget();

        public boolean isConstructor();

        public boolean isVirtual();

        public int vtableOffset();

        public boolean isOverride();

        public ResolvedJavaType ownerType();

        public ResolvedJavaMethod idMethod();
    }

    public static interface DebugFieldInfo
    extends DebugMemberInfo {
        public int offset();

        public int size();

        public boolean isEmbedded();
    }

    public static interface DebugMemberInfo
    extends DebugFileInfo {
        public String name();

        public ResolvedJavaType valueType();

        public int modifiers();
    }

    public static interface DebugHeaderTypeInfo
    extends DebugTypeInfo {
        public Stream<DebugFieldInfo> fieldInfoProvider();
    }

    public static interface DebugPrimitiveTypeInfo
    extends DebugTypeInfo {
        public static final int FLAG_NUMERIC = 1;
        public static final int FLAG_INTEGRAL = 2;
        public static final int FLAG_SIGNED = 4;

        public int bitCount();

        public char typeChar();

        public int flags();
    }

    public static interface DebugArrayTypeInfo
    extends DebugTypeInfo {
        public int baseSize();

        public int lengthOffset();

        public ResolvedJavaType elementType();

        public Stream<DebugFieldInfo> fieldInfoProvider();
    }

    public static interface DebugForeignTypeInfo
    extends DebugInstanceTypeInfo {
        public String typedefName();

        public boolean isWord();

        public boolean isStruct();

        public boolean isPointer();

        public boolean isIntegral();

        public boolean isFloat();

        public boolean isSigned();

        public ResolvedJavaType parent();

        public ResolvedJavaType pointerTo();
    }

    public static interface DebugInterfaceTypeInfo
    extends DebugInstanceTypeInfo {
    }

    public static interface DebugEnumTypeInfo
    extends DebugInstanceTypeInfo {
    }

    public static interface DebugInstanceTypeInfo
    extends DebugTypeInfo {
        public String loaderName();

        public Stream<DebugFieldInfo> fieldInfoProvider();

        public Stream<DebugMethodInfo> methodInfoProvider();

        public ResolvedJavaType superClass();

        public Stream<ResolvedJavaType> interfaces();
    }

    public static interface DebugTypeInfo
    extends DebugFileInfo {
        public ResolvedJavaType idType();

        public void debugContext(Consumer<DebugContext> var1);

        public String typeName();

        public DebugTypeKind typeKind();

        public long classOffset();

        public int size();

        public static enum DebugTypeKind {
            PRIMITIVE,
            ENUM,
            INSTANCE,
            INTERFACE,
            ARRAY,
            HEADER,
            FOREIGN;


            public String toString() {
                switch (this.ordinal()) {
                    case 0: {
                        return "primitive";
                    }
                    case 1: {
                        return "enum";
                    }
                    case 2: {
                        return "instance";
                    }
                    case 3: {
                        return "interface";
                    }
                    case 4: {
                        return "array";
                    }
                    case 5: {
                        return "header";
                    }
                    case 6: {
                        return "foreign";
                    }
                }
                return "???";
            }
        }
    }

    public static interface DebugFileInfo {
        public String fileName();

        public Path filePath();
    }
}

