/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.processor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.graalvm.compiler.processor.AbstractProcessor;
import org.graalvm.compiler.replacements.processor.AnnotationHandler;
import org.graalvm.compiler.replacements.processor.FoldHandler;
import org.graalvm.compiler.replacements.processor.NodeIntrinsicHandler;
import org.graalvm.compiler.replacements.processor.PluginGenerator;

public class ReplacementsAnnotationProcessor
extends AbstractProcessor {
    private List<AnnotationHandler> handlers;

    @Override
    public boolean doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            PluginGenerator generator = new PluginGenerator();
            for (AnnotationHandler handler : this.getHandlers()) {
                TypeElement annotationClass = this.getTypeElementOrNull(handler.annotationTypeName);
                if (annotationClass != null) {
                    for (Element element : roundEnv.getElementsAnnotatedWith(annotationClass)) {
                        AnnotationMirror annotationMirror = this.getAnnotation(element, annotationClass.asType());
                        handler.process(element, annotationMirror, generator);
                    }
                    continue;
                }
                Set<? extends Element> roots = roundEnv.getRootElements();
                String string = String.format("Processor %s disabled as %s is not resolvable on the compilation class path", handler.getClass().getName(), handler.annotationTypeName);
                if (roots.isEmpty()) {
                    this.env().getMessager().printMessage(Diagnostic.Kind.WARNING, string);
                    continue;
                }
                this.env().getMessager().printMessage(Diagnostic.Kind.WARNING, string, roots.iterator().next());
            }
            generator.generateAll(this);
        }
        return false;
    }

    public List<AnnotationHandler> getHandlers() {
        if (this.handlers == null) {
            this.handlers = new ArrayList<AnnotationHandler>();
            this.handlers.add(new NodeIntrinsicHandler(this));
            this.handlers.add(new FoldHandler(this));
        }
        return this.handlers;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> annotationTypes = new HashSet<String>();
        for (AnnotationHandler handler : this.getHandlers()) {
            annotationTypes.add(handler.annotationTypeName);
        }
        return annotationTypes;
    }
}

