/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.processor;

import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import javax.tools.Diagnostic;
import org.graalvm.compiler.processor.AbstractProcessor;
import org.graalvm.compiler.replacements.processor.AnnotationHandler;
import org.graalvm.compiler.replacements.processor.GeneratedFoldPlugin;
import org.graalvm.compiler.replacements.processor.PluginGenerator;

public final class FoldHandler
extends AnnotationHandler {
    static final String FOLD_CLASS_NAME = "org.graalvm.compiler.api.replacements.Fold";
    static final String INJECTED_PARAMETER_CLASS_NAME = "org.graalvm.compiler.api.replacements.Fold.InjectedParameter";

    public FoldHandler(AbstractProcessor processor) {
        super(processor, FOLD_CLASS_NAME);
    }

    @Override
    public void process(Element element, AnnotationMirror annotation, PluginGenerator generator) {
        if (element.getKind() != ElementKind.METHOD) {
            assert (false) : "Element is guaranteed to be a method.";
            return;
        }
        ExecutableElement foldMethod = (ExecutableElement)element;
        if (foldMethod.getReturnType().getKind() == TypeKind.VOID) {
            this.processor.env().getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("A @%s method must not be void as it won't yield a compile-time constant (the reason for supporting folding!).", AbstractProcessor.getSimpleName(FOLD_CLASS_NAME)), element, annotation);
        } else if (foldMethod.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.processor.env().getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("A @%s method must not be private.", AbstractProcessor.getSimpleName(FOLD_CLASS_NAME)), element, annotation);
        } else {
            generator.addPlugin(new GeneratedFoldPlugin(foldMethod));
        }
    }
}

