/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.openssl.Rand;
import com.oracle.jipher.internal.spi.InternalTlsSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class TlsRsaPremasterSecretGenerator
extends KeyGeneratorSpi {
    private static final int PREMASTER_SECRET_KEY_LEN = 48;
    private static final String MSG = "TlsRsaPremasterSecretGenerator must be initialized using a TlsRsaPremasterSecretParameterSpec";
    private InternalTlsSpec.RsaPremasterSecretParamSpec paramSpec;

    @Override
    protected void engineInit(int keySize, SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.paramSpec = new InternalTlsSpec.RsaPremasterSecretParamSpec(algorithmParameterSpec);
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (this.paramSpec == null) {
            throw new IllegalStateException("TlsRsaPremasterSecretGenerator must be initialized");
        }
        byte[] premaster = this.paramSpec.getEncodedSecret();
        try {
            if (premaster == null) {
                premaster = Rand.generate(48);
            }
            premaster[0] = (byte)this.paramSpec.getMajorVersion();
            premaster[1] = (byte)this.paramSpec.getMinorVersion();
            SecretKeySpec secretKeySpec = new SecretKeySpec(premaster, "TlsRsaPremasterSecret");
            return secretKeySpec;
        }
        finally {
            Util.clearArray(premaster);
        }
    }
}

