/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.Jre;
import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.openssl.EvpKdf;
import com.oracle.jipher.internal.openssl.MdAlg;
import com.oracle.jipher.internal.spi.InternalTlsSpec;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class TlsKeyMaterialGenerator
extends KeyGeneratorSpi {
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    private static final byte[] KEY_EXPANSION_LABEL = "key expansion".getBytes(US_ASCII);
    private static final String MSG = "TlsKeyMaterialGenerator must be initialized using a TlsKeyMaterialParameterSpec";
    private static final int TLS1_2_VER = 771;
    private InternalTlsSpec.KeyMaterialParamSpec paramSpec;
    private MdAlg md;

    @Override
    protected void engineInit(int keySize, SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.paramSpec = null;
        InternalTlsSpec.KeyMaterialParamSpec pSpec = new InternalTlsSpec.KeyMaterialParamSpec(algorithmParameterSpec);
        if (!"RAW".equals(pSpec.getMasterSecret().getFormat())) {
            throw new InvalidAlgorithmParameterException("Key encoding format must be RAW");
        }
        int protocolVersion = pSpec.getMajorVersion() << 8 | pSpec.getMinorVersion();
        if (protocolVersion != 771) {
            throw new InvalidAlgorithmParameterException("Only TLS 1.2 supported");
        }
        if (pSpec.getCipherKeyLength() == 0) {
            throw new InvalidAlgorithmParameterException("Null ciphersuites are not supported");
        }
        this.md = MdAlg.byName(pSpec.getPRFHashAlg());
        if (this.md == null) {
            throw new InvalidAlgorithmParameterException("Unsupported PRF hash algorithm");
        }
        this.paramSpec = pSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SecretKey engineGenerateKey() {
        SecretKey secretKey;
        if (this.paramSpec == null) {
            throw new IllegalStateException("TlsKeyMaterialGenerator must be initialized");
        }
        String alg = this.paramSpec.getCipherAlgorithm();
        int macKeyLength = this.paramSpec.getMacKeyLength();
        int keyLength = this.paramSpec.getCipherKeyLength();
        int ivLength = this.paramSpec.getIvLength();
        int keyBlockLen = (macKeyLength + keyLength + ivLength) * 2;
        byte[] masterSecret = this.paramSpec.getMasterSecret().getEncoded();
        byte[] keyBlock = null;
        try {
            keyBlock = EvpKdf.tls1PrfDerive(masterSecret, KEY_EXPANSION_LABEL, this.paramSpec.getServerRandom(), this.paramSpec.getClientRandom(), this.md, keyBlockLen);
            ByteBuffer keyBlockBuf = ByteBuffer.wrap(keyBlock);
            SecretKeySpec clientMacKey = null;
            SecretKeySpec serverMacKey = null;
            if (macKeyLength != 0) {
                byte[] macKeyBytes = new byte[macKeyLength];
                keyBlockBuf.get(macKeyBytes);
                clientMacKey = new SecretKeySpec(macKeyBytes, "Mac");
                keyBlockBuf.get(macKeyBytes);
                serverMacKey = new SecretKeySpec(macKeyBytes, "Mac");
                Util.clearArray(macKeyBytes);
            }
            byte[] keyBytes = new byte[keyLength];
            keyBlockBuf.get(keyBytes);
            SecretKeySpec clientCipherKey = new SecretKeySpec(keyBytes, alg);
            keyBlockBuf.get(keyBytes);
            SecretKeySpec serverCipherKey = new SecretKeySpec(keyBytes, alg);
            Util.clearArray(keyBytes);
            IvParameterSpec clientIv = null;
            IvParameterSpec serverIv = null;
            if (ivLength != 0) {
                byte[] ivBytes = new byte[ivLength];
                keyBlockBuf.get(ivBytes);
                clientIv = new IvParameterSpec(ivBytes);
                keyBlockBuf.get(ivBytes);
                serverIv = new IvParameterSpec(ivBytes);
                Util.clearArray(ivBytes);
            }
            secretKey = this.newTlsKeyMaterialSpec(clientMacKey, serverMacKey, clientCipherKey, clientIv, serverCipherKey, serverIv);
        }
        catch (Throwable throwable) {
            Util.clearArray(masterSecret);
            Util.clearArray(keyBlock);
            throw throwable;
        }
        Util.clearArray(masterSecret);
        Util.clearArray(keyBlock);
        return secretKey;
    }

    private SecretKey newTlsKeyMaterialSpec(SecretKey clientMacKey, SecretKey serverMacKey, SecretKey clientCipherKey, IvParameterSpec clientIv, SecretKey serverCipherKey, IvParameterSpec serverIv) {
        try {
            Class<?> specClass = Jre.getVendor() == Jre.Vendor.IBM ? Class.forName("ibm.security.internal.spec.TlsKeyMaterialSpec") : Class.forName("sun.security.internal.spec.TlsKeyMaterialSpec");
            Constructor<?> c = specClass.getConstructor(SecretKey.class, SecretKey.class, SecretKey.class, IvParameterSpec.class, SecretKey.class, IvParameterSpec.class);
            return (SecretKey)c.newInstance(clientMacKey, serverMacKey, clientCipherKey, clientIv, serverCipherKey, serverIv);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ProviderException("Unexpected error creating TlsKeyMaterialSpec", e);
        }
    }
}

