/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.InputChecks;
import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.key.JceRsaPrivateKey;
import com.oracle.jipher.internal.key.JceRsaPublicKey;
import com.oracle.jipher.internal.openssl.Pkey;
import com.oracle.jipher.internal.openssl.PkeyType;
import com.oracle.jipher.internal.spi.AsymKeyFactory;
import com.oracle.jipher.internal.tools.asn1.Asn1;
import com.oracle.jipher.internal.tools.asn1.Asn1BerValue;
import com.oracle.jipher.internal.tools.asn1.Asn1DecodeException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.List;

public final class RsaKeyFactory
extends AsymKeyFactory {
    private static final Asn1BerValue ID_RSA_ENCRYPTION = Asn1.newOid("1.2.840.113549.1.1.1");

    @Override
    PkeyType getPkeyType() {
        return PkeyType.RSA;
    }

    @Override
    PrivateKey createPrivateKey(Pkey pkey) throws InvalidKeyException {
        return new JceRsaPrivateKey(pkey);
    }

    @Override
    PublicKey createPublicKey(Pkey pkey, byte[] pubDer) throws InvalidKeyException {
        return new JceRsaPublicKey(pkey, pubDer);
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof RSAPrivateCrtKeySpec) {
            RSAPrivateCrtKeySpec spec = (RSAPrivateCrtKeySpec)keySpec;
            if (InputChecks.isNullOrZero(spec.getModulus(), spec.getPublicExponent(), spec.getPrivateExponent(), spec.getPrimeP(), spec.getPrimeQ(), spec.getPrimeExponentP(), spec.getPrimeExponentQ(), spec.getCrtCoefficient())) {
                throw new InvalidKeySpecException("Parameter spec values must not be null or ZERO.");
            }
            try {
                return this.generatePrivateInternal(spec.getModulus(), spec.getPublicExponent(), spec.getPrivateExponent(), spec.getPrimeP(), spec.getPrimeQ(), spec.getPrimeExponentP(), spec.getPrimeExponentQ(), spec.getCrtCoefficient());
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeySpecException(e);
            }
        }
        if (keySpec instanceof RSAPrivateKeySpec) {
            throw new InvalidKeySpecException("RSA private key without CRT info not supported.");
        }
        return super.engineGeneratePrivate(keySpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PrivateKey generatePrivateInternal(BigInteger mod, BigInteger e, BigInteger d, BigInteger p, BigInteger q, BigInteger primeExpP, BigInteger primeExpQ, BigInteger crtCoeff) throws InvalidKeyException {
        Pkey pkey;
        byte[][] vals = new byte[8][];
        try {
            vals[0] = mod.toByteArray();
            vals[1] = e.toByteArray();
            vals[2] = d.toByteArray();
            vals[3] = p.toByteArray();
            vals[4] = q.toByteArray();
            vals[5] = primeExpP.toByteArray();
            vals[6] = primeExpQ.toByteArray();
            vals[7] = crtCoeff.toByteArray();
            pkey = Pkey.newRsaPriv(vals[0], vals[1], vals[2], vals[3], vals[4], vals[5], vals[6], vals[7]);
        }
        finally {
            Util.clearArrays(vals);
        }
        return new JceRsaPrivateKey(pkey, mod, e, d, p, q, primeExpP, primeExpQ, crtCoeff);
    }

    @Override
    PrivateKey generatePrivateInternal(byte[] privDer) throws InvalidKeyException {
        BigInteger[] rsaPrivKey;
        try {
            rsaPrivKey = RsaKeyFactory.rsaPrivDerDecode(privDer);
        }
        finally {
            Util.clearArray(privDer);
        }
        return this.generatePrivateInternal(rsaPrivKey[0], rsaPrivKey[1], rsaPrivKey[2], rsaPrivKey[3], rsaPrivKey[4], rsaPrivKey[5], rsaPrivKey[6], rsaPrivKey[7]);
    }

    private static BigInteger[] rsaPrivDerDecode(byte[] privDer) throws InvalidKeyException {
        try {
            Asn1BerValue rsaPrivKey = Asn1.decodeOne(privDer).count(3);
            Util.assertAllUniversal(rsaPrivKey);
            List<Asn1BerValue> rsaPrivKeyValues = rsaPrivKey.sequence();
            BigInteger privKeyInfoVer = rsaPrivKeyValues.get(0).getInteger();
            if (!privKeyInfoVer.equals(BigInteger.ZERO)) {
                throw new Asn1DecodeException("Invalid PrivateKeyInfo version; was: " + privKeyInfoVer + ", expected: 0");
            }
            List<Asn1BerValue> algId = rsaPrivKeyValues.get(1).count(2).sequence();
            Asn1BerValue algorithm = algId.get(0);
            if (!algorithm.equals(ID_RSA_ENCRYPTION)) {
                throw new Asn1DecodeException("Unsupported key algorithm; was: " + algorithm.getOid() + ", expected: " + ID_RSA_ENCRYPTION.getOid());
            }
            algId.get(1).getNull();
            Asn1BerValue rsaPrivateKey = Asn1.decodeOne(rsaPrivKeyValues.get(2).getOctetString()).count(9);
            Util.assertAllUniversal(rsaPrivateKey);
            List<Asn1BerValue> keyValues = rsaPrivateKey.sequence();
            BigInteger rsaPrivKeyVer = rsaPrivKeyValues.get(0).getInteger();
            if (!rsaPrivKeyVer.equals(BigInteger.ZERO)) {
                throw new Asn1DecodeException("Invalid RSAPrivateKey version; was: " + rsaPrivKeyVer + ", expected: 0");
            }
            return (BigInteger[])keyValues.stream().skip(1L).map(i -> i.getInteger()).toArray(BigInteger[]::new);
        }
        catch (Asn1DecodeException ex) {
            throw new InvalidKeyException("Unable to decode RSA Private Key", ex);
        }
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof RSAPublicKeySpec) {
            RSAPublicKeySpec rsaSpec = (RSAPublicKeySpec)keySpec;
            if (InputChecks.isNullOrZero(rsaSpec.getModulus(), rsaSpec.getPublicExponent())) {
                throw new InvalidKeySpecException("Parameter spec values must not be null or ZERO.");
            }
            try {
                return this.generatePublicInternal(rsaSpec.getModulus(), rsaSpec.getPublicExponent(), null);
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeySpecException(e);
            }
        }
        return super.engineGeneratePublic(keySpec);
    }

    PublicKey generatePublicInternal(BigInteger mod, BigInteger e, byte[] pubDer) throws InvalidKeyException {
        Pkey pkey = Pkey.newRsaPub(mod.toByteArray(), e.toByteArray());
        return new JceRsaPublicKey(pkey, mod, e, pubDer);
    }

    @Override
    PublicKey generatePublicInternal(byte[] pubDer) throws InvalidKeyException {
        BigInteger[] rsaPubKey = RsaKeyFactory.rsaPubDerDecode(pubDer);
        return this.generatePublicInternal(rsaPubKey[0], rsaPubKey[1], pubDer);
    }

    private static BigInteger[] rsaPubDerDecode(byte[] pubDer) throws InvalidKeyException {
        try {
            Asn1BerValue rsaPubKey = Asn1.decodeOne(pubDer).count(2);
            Util.assertAllUniversal(rsaPubKey);
            List<Asn1BerValue> rsaPubKeyValues = rsaPubKey.sequence();
            List<Asn1BerValue> algId = rsaPubKeyValues.get(0).count(2).sequence();
            Asn1BerValue algorithm = algId.get(0);
            if (!algorithm.equals(ID_RSA_ENCRYPTION)) {
                throw new Asn1DecodeException("Unsupported key algorithm; was: " + algorithm.getOid() + ", expected: " + ID_RSA_ENCRYPTION.getOid());
            }
            algId.get(1).getNull();
            Asn1BerValue rsaPublicKey = Asn1.decodeOne(rsaPubKeyValues.get(1).getBitStringOctets()).count(2);
            Util.assertAllUniversal(rsaPublicKey);
            return (BigInteger[])rsaPublicKey.sequence().stream().map(i -> i.getInteger()).toArray(BigInteger[]::new);
        }
        catch (Asn1DecodeException ex) {
            throw new InvalidKeyException("Unable to decode RSA Public Key", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> keySpec) throws InvalidKeySpecException {
        Key osslKey;
        try {
            osslKey = this.engineTranslateKey(key);
        }
        catch (InvalidKeyException var4) {
            throw new InvalidKeySpecException(var4);
        }
        if (osslKey instanceof RSAPublicKey) {
            if (keySpec == X509EncodedKeySpec.class) {
                return (T)((KeySpec)keySpec.cast(new X509EncodedKeySpec(osslKey.getEncoded())));
            }
            if (keySpec == RSAPublicKeySpec.class) {
                return (T)((KeySpec)keySpec.cast(new RSAPublicKeySpec(((RSAPublicKey)osslKey).getModulus(), ((RSAPublicKey)osslKey).getPublicExponent())));
            }
            throw new InvalidKeySpecException("Expected either RSAPublicKeySpec or X509EncodedKeySpec");
        }
        if (osslKey instanceof RSAPrivateKey) {
            if (keySpec == PKCS8EncodedKeySpec.class) {
                byte[] privDer = key.getEncoded();
                try {
                    KeySpec keySpec2 = (KeySpec)keySpec.cast(new PKCS8EncodedKeySpec(privDer));
                    return (T)keySpec2;
                }
                finally {
                    Util.clearArray(privDer);
                }
            }
            if (keySpec == RSAPrivateCrtKeySpec.class) {
                if (osslKey instanceof RSAPrivateCrtKey) {
                    RSAPrivateCrtKey prv = (RSAPrivateCrtKey)osslKey;
                    return (T)((KeySpec)keySpec.cast(new RSAPrivateCrtKeySpec(prv.getModulus(), prv.getPublicExponent(), prv.getPrivateExponent(), prv.getPrimeP(), prv.getPrimeQ(), prv.getPrimeExponentP(), prv.getPrimeExponentQ(), prv.getCrtCoefficient())));
                }
                throw new InvalidKeySpecException("Key does not contain CRT data");
            }
            if (keySpec == RSAPrivateKeySpec.class) {
                return (T)((KeySpec)keySpec.cast(new RSAPrivateKeySpec(((RSAPrivateKey)osslKey).getModulus(), ((RSAPrivateKey)osslKey).getPrivateExponent())));
            }
            throw new InvalidKeySpecException("Expected either RSAPrivate(Crt)KeySpec or PKCS8EncodedKeySpec");
        }
        throw new InvalidKeySpecException("Could not getKeySpec for given key");
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof JceRsaPublicKey || key instanceof JceRsaPrivateKey) {
            return key;
        }
        if (key instanceof PrivateKey) {
            return this.translatePrivate((PrivateKey)key);
        }
        if (key instanceof PublicKey) {
            return this.translatePublic((PublicKey)key);
        }
        throw new InvalidKeyException("Could not translate to RSA key");
    }
}

