/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.openssl.Rand;
import com.oracle.jipher.internal.spi.CipherAlg;
import com.oracle.jipher.internal.spi.CipherMode;
import com.oracle.jipher.internal.spi.CipherPadding;
import com.oracle.jipher.internal.spi.SymmCipher;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

public abstract class FeedbackCipher
extends SymmCipher {
    FeedbackCipher(CipherAlg cipherAlg) throws NoSuchAlgorithmException, NoSuchPaddingException {
        super(cipherAlg);
        if (cipherAlg instanceof CipherAlg.FixedModePad) {
            CipherAlg.FixedModePad algModePad = (CipherAlg.FixedModePad)((Object)cipherAlg);
            this.engineSetMode(algModePad.getMode().name());
            this.engineSetPadding(algModePad.getPadding().name());
        }
    }

    @Override
    protected void engineUpdateAAD(ByteBuffer byteBuffer) {
        throw new IllegalStateException("No AAD accepted");
    }

    @Override
    protected void engineUpdateAAD(byte[] bytes, int i, int i1) {
        throw new IllegalStateException("No AAD accepted");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int engineUpdate(byte[] input, int inOffset, int inLen, byte[] out, int outOffset) throws ShortBufferException {
        if (inLen < 0 || outOffset < 0) {
            throw new IllegalArgumentException("Invalid negative argument");
        }
        int outSize = this.getUpdateOutputSize(inLen);
        if (out.length - outOffset < outSize) {
            byte[] tmpOut = new byte[outSize];
            try {
                int outLen = super.engineUpdate(input, inOffset, inLen, tmpOut, 0);
                if (outLen > out.length - outOffset) {
                    throw new ShortBufferException("Not enough space in output array");
                }
                System.arraycopy(tmpOut, 0, out, outOffset, outLen);
                int n = outLen;
                return n;
            }
            finally {
                Util.clearArray(tmpOut);
            }
        }
        return super.engineUpdate(input, inOffset, inLen, out, outOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int engineDoFinal(byte[] input, int inOffset, int inLen, byte[] out, int outOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (inLen < 0 || outOffset < 0) {
            throw new IllegalArgumentException("Invalid negative argument");
        }
        if (inLen == 0 && !this.updateCalled && this.ctx != null && this.padding == CipherPadding.NOPADDING) {
            return 0;
        }
        int outSize = this.getUpdateOutputSize(inLen) + this.getFinalOutputSize();
        if (out.length - outOffset < outSize) {
            byte[] tmpOut = new byte[outSize];
            try {
                int outLen = super.engineDoFinal(input, inOffset, inLen, tmpOut, 0);
                if (outLen > out.length - outOffset) {
                    throw new ShortBufferException("Not enough space in output array");
                }
                System.arraycopy(tmpOut, 0, out, outOffset, outLen);
                int n = outLen;
                return n;
            }
            finally {
                Util.clearArray(tmpOut);
            }
        }
        return super.engineDoFinal(input, inOffset, inLen, out, outOffset);
    }

    @Override
    AlgorithmParameterSpec getParamSpec(byte[] iv, AlgorithmParameterSpec spec) {
        return iv != null ? new IvParameterSpec(iv) : spec;
    }

    @Override
    byte[] verifyParams(AlgorithmParameterSpec params, boolean encrypt) throws InvalidAlgorithmParameterException {
        if (params == null) {
            return this.validateIv(null, encrypt);
        }
        if (params instanceof IvParameterSpec) {
            return this.validateIv(((IvParameterSpec)params).getIV(), encrypt);
        }
        throw new InvalidAlgorithmParameterException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] validateIv(byte[] iv, boolean encrypt) throws InvalidAlgorithmParameterException {
        if (iv == null) {
            if (this.mode == CipherMode.ECB) {
                return null;
            }
            if (!encrypt) throw new InvalidAlgorithmParameterException("IV parameters required for decryption");
            return Rand.generate(this.cipherAlg.getBlockSize());
        }
        if (this.mode == CipherMode.ECB) {
            throw new InvalidAlgorithmParameterException("No IV expected for ECB.");
        }
        if (iv.length == this.cipherAlg.getBlockSize()) return iv;
        throw new InvalidAlgorithmParameterException("Expected IV of length " + this.cipherAlg.getBlockSize());
    }

    @Override
    Class<? extends AlgorithmParameterSpec> getParameterSpecClass() {
        return IvParameterSpec.class;
    }

    @Override
    int getUpdateOutputSize(int inputLen) {
        if (this.mode == CipherMode.ECB || this.mode == CipherMode.CBC) {
            int blkSz = this.cipherAlg.getBlockSize();
            return inputLen + blkSz - 1 & ~(blkSz - 1);
        }
        return inputLen;
    }

    @Override
    int getFinalOutputSize() {
        if ((this.mode == CipherMode.ECB || this.mode == CipherMode.CBC) && this.padding != CipherPadding.NOPADDING) {
            int blkSz = this.cipherAlg.getBlockSize();
            return this.encrypt ? blkSz : blkSz - 1;
        }
        return 0;
    }

    @Override
    String getAlgorithmParametersAlg() {
        return this.cipherAlg.getName();
    }

    public static final class DesEdeCbcPkcs5Pad
    extends FeedbackCipher {
        public DesEdeCbcPkcs5Pad() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.DesEdeFixed(CipherMode.CBC, CipherPadding.PKCS5PADDING));
        }
    }

    public static final class DESEDE
    extends FeedbackCipher {
        public DESEDE() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.DesEde());
        }
    }

    public static final class Aes256OfbNoPad
    extends FeedbackCipher {
        public Aes256OfbNoPad() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesFixed(256, CipherMode.OFB, CipherPadding.NOPADDING));
        }
    }

    public static final class Aes256CfbNoPad
    extends FeedbackCipher {
        public Aes256CfbNoPad() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesFixed(256, CipherMode.CFB, CipherPadding.NOPADDING));
        }
    }

    public static final class Aes256CbcPkcs5Pad
    extends FeedbackCipher {
        public Aes256CbcPkcs5Pad() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesFixed(256, CipherMode.CBC, CipherPadding.PKCS5PADDING));
        }
    }

    public static final class Aes256EcbNoPad
    extends FeedbackCipher {
        public Aes256EcbNoPad() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesFixed(256, CipherMode.ECB, CipherPadding.NOPADDING));
        }
    }

    public static final class Aes192OfbNoPad
    extends FeedbackCipher {
        public Aes192OfbNoPad() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesFixed(192, CipherMode.OFB, CipherPadding.NOPADDING));
        }
    }

    public static final class Aes192CfbNoPad
    extends FeedbackCipher {
        public Aes192CfbNoPad() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesFixed(192, CipherMode.CFB, CipherPadding.NOPADDING));
        }
    }

    public static final class Aes192CbcPkcs5Pad
    extends FeedbackCipher {
        public Aes192CbcPkcs5Pad() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesFixed(192, CipherMode.CBC, CipherPadding.PKCS5PADDING));
        }
    }

    public static final class Aes192EcbNoPad
    extends FeedbackCipher {
        public Aes192EcbNoPad() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesFixed(192, CipherMode.ECB, CipherPadding.NOPADDING));
        }
    }

    public static final class Aes128OfbNoPad
    extends FeedbackCipher {
        public Aes128OfbNoPad() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesFixed(128, CipherMode.OFB, CipherPadding.NOPADDING));
        }
    }

    public static final class Aes128CfbNoPad
    extends FeedbackCipher {
        public Aes128CfbNoPad() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesFixed(128, CipherMode.CFB, CipherPadding.NOPADDING));
        }
    }

    public static final class Aes128CbcPkcs5Pad
    extends FeedbackCipher {
        public Aes128CbcPkcs5Pad() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesFixed(128, CipherMode.CBC, CipherPadding.PKCS5PADDING));
        }
    }

    public static final class Aes128EcbNoPad
    extends FeedbackCipher {
        public Aes128EcbNoPad() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesFixed(128, CipherMode.ECB, CipherPadding.NOPADDING));
        }
    }

    public static final class AES
    extends FeedbackCipher {
        public AES() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AES());
        }
    }
}

