/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.InputChecks;
import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.key.JceDhPrivateKey;
import com.oracle.jipher.internal.key.JceDhPublicKey;
import com.oracle.jipher.internal.openssl.Pkey;
import com.oracle.jipher.internal.openssl.PkeyType;
import com.oracle.jipher.internal.spi.AsymKeyFactory;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;

public final class DhKeyFactory
extends AsymKeyFactory {
    @Override
    PkeyType getPkeyType() {
        return PkeyType.DH;
    }

    @Override
    PrivateKey createPrivateKey(Pkey pkey) throws InvalidKeyException {
        return new JceDhPrivateKey(pkey);
    }

    @Override
    PublicKey createPublicKey(Pkey pkey, byte[] pubDer) throws InvalidKeyException {
        return new JceDhPublicKey(pkey, pubDer);
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DHPrivateKeySpec) {
            DHPrivateKeySpec spec = (DHPrivateKeySpec)keySpec;
            if (InputChecks.isNullOrZero(spec.getP(), spec.getG(), spec.getX())) {
                throw new InvalidKeySpecException("Key spec parameters must not be null, or ZERO.");
            }
            byte[] privVal = spec.getX().toByteArray();
            try {
                Pkey pkey = Pkey.newDhPriv(spec.getP().toByteArray(), null, spec.getG().toByteArray(), privVal);
                JceDhPrivateKey jceDhPrivateKey = new JceDhPrivateKey(pkey, spec.getX(), new DHParameterSpec(spec.getP(), spec.getG()));
                return jceDhPrivateKey;
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeySpecException(e);
            }
            finally {
                Util.clearArray(privVal);
            }
        }
        return super.engineGeneratePrivate(keySpec);
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DHPublicKeySpec) {
            DHPublicKeySpec spec = (DHPublicKeySpec)keySpec;
            if (InputChecks.isNullOrZero(spec.getP(), spec.getG(), spec.getY())) {
                throw new InvalidKeySpecException("Key spec parameters must not be null, or ZERO.");
            }
            try {
                Pkey pkey = Pkey.newDhPub(spec.getP().toByteArray(), null, spec.getG().toByteArray(), spec.getY().toByteArray());
                return new JceDhPublicKey(pkey, spec.getY(), new DHParameterSpec(spec.getP(), spec.getG()), null);
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeySpecException(e);
            }
        }
        return super.engineGeneratePublic(keySpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> keySpec) throws InvalidKeySpecException {
        Key osslKey;
        try {
            osslKey = this.engineTranslateKey(key);
        }
        catch (InvalidKeyException var4) {
            throw new InvalidKeySpecException(var4);
        }
        if (osslKey instanceof DHPublicKey) {
            if (keySpec == X509EncodedKeySpec.class) {
                return (T)((KeySpec)keySpec.cast(new X509EncodedKeySpec(osslKey.getEncoded())));
            }
            if (keySpec == DHPublicKeySpec.class) {
                DHParameterSpec dhParams = ((DHPublicKey)osslKey).getParams();
                return (T)((KeySpec)keySpec.cast(new DHPublicKeySpec(((DHPublicKey)osslKey).getY(), dhParams.getP(), dhParams.getG())));
            }
            throw new InvalidKeySpecException("Expected DHPublicKeySpec or X509EncodedKeySpec");
        }
        if (osslKey instanceof DHPrivateKey) {
            if (keySpec == PKCS8EncodedKeySpec.class) {
                byte[] der = key.getEncoded();
                try {
                    KeySpec keySpec2 = (KeySpec)keySpec.cast(new PKCS8EncodedKeySpec(der));
                    return (T)keySpec2;
                }
                finally {
                    Util.clearArray(der);
                }
            }
            if (keySpec == DHPrivateKeySpec.class) {
                DHParameterSpec dhParams = ((DHPrivateKey)osslKey).getParams();
                return (T)((KeySpec)keySpec.cast(new DHPrivateKeySpec(((DHPrivateKey)osslKey).getX(), dhParams.getP(), dhParams.getG())));
            }
            throw new InvalidKeySpecException("Expected either DHPrivateKeySpec or PKCS8EncodedKeySpec");
        }
        throw new InvalidKeySpecException("Could not getKeySpec for given key");
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof JceDhPublicKey || key instanceof JceDhPrivateKey) {
            return key;
        }
        if (key instanceof PrivateKey) {
            return this.translatePrivate((PrivateKey)key);
        }
        if (key instanceof PublicKey) {
            return this.translatePublic((PublicKey)key);
        }
        throw new InvalidKeyException("Could not translate to DH key");
    }
}

