/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.openssl;

public enum EcCurve {
    secp224r1(713, "1.3.132.0.33", 224),
    secp256r1(415, "1.2.840.10045.3.1.7", 256),
    secp384r1(715, "1.3.132.0.34", 384),
    secp521r1(716, "1.3.132.0.35", 521);

    private final int nid;
    private final String oid;
    private final int keyBits;

    private EcCurve(int nid, String oid, int keyBits) {
        this.nid = nid;
        this.oid = oid;
        this.keyBits = keyBits;
    }

    public int nid() {
        return this.nid;
    }

    public String oid() {
        return this.oid;
    }

    public int keyBits() {
        return this.keyBits;
    }

    public static EcCurve byNid(int nid) {
        for (EcCurve c : EcCurve.values()) {
            if (c.nid != nid) continue;
            return c;
        }
        return null;
    }
}

