/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.key;

import com.oracle.jipher.internal.key.JceOsslKey;
import com.oracle.jipher.internal.openssl.Pkey;
import com.oracle.jipher.internal.tools.asn1.Asn1;
import com.oracle.jipher.internal.tools.asn1.Asn1BerValue;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.interfaces.RSAPublicKey;

public final class JceRsaPublicKey
extends JceOsslKey
implements RSAPublicKey {
    static final String ALG = "RSA";
    private static final Asn1BerValue ID_RSA_ENCRYPTION = Asn1.newOid("1.2.840.113549.1.1.1");
    private final BigInteger mod;
    private final BigInteger e;

    public JceRsaPublicKey(Pkey pkey, BigInteger mod, BigInteger e, byte[] encoding) {
        super(ALG, pkey, encoding);
        this.mod = mod;
        this.e = e;
    }

    public JceRsaPublicKey(Pkey pkey, byte[] encoding) throws InvalidKeyException {
        super(ALG, pkey, encoding);
        byte[][] vals = this.pkey.getRsaKeyData();
        if (vals[0] == null || vals[1] == null) {
            throw new InvalidKeyException("Invalid RSA key value");
        }
        this.mod = new BigInteger(1, vals[0]);
        this.e = new BigInteger(1, vals[1]);
    }

    @Override
    public BigInteger getModulus() {
        return this.mod;
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.e;
    }

    @Override
    byte[] derEncode() throws InvalidKeyException {
        Asn1BerValue rsaPubKey = Asn1.newSequence(Asn1.newSequence(ID_RSA_ENCRYPTION, Asn1.newNull()), Asn1.newBitString(Asn1.newSequence(Asn1.newInteger(this.mod), Asn1.newInteger(this.e)).encodeDerOctets()));
        return rsaPubKey.encodeDerOctets();
    }

    public String toString() {
        return "RsaPublicKey: n=" + this.mod + ",e=" + this.e;
    }
}

