/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.key;

import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.key.JceOsslKey;
import com.oracle.jipher.internal.openssl.Pkey;
import com.oracle.jipher.internal.tools.asn1.Asn1;
import com.oracle.jipher.internal.tools.asn1.Asn1BerValue;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.interfaces.RSAPrivateCrtKey;

public final class JceRsaPrivateKey
extends JceOsslKey
implements RSAPrivateCrtKey {
    static final String ALG = "RSA";
    private static final Asn1BerValue ID_RSA_ENCRYPTION = Asn1.newOid("1.2.840.113549.1.1.1");
    private final BigInteger mod;
    private final BigInteger e;
    private final BigInteger d;
    private final BigInteger p;
    private final BigInteger q;
    private final BigInteger primeExpP;
    private final BigInteger primeExpQ;
    private final BigInteger crtCoeff;

    public JceRsaPrivateKey(Pkey pkey, BigInteger mod, BigInteger e, BigInteger d, BigInteger p, BigInteger q, BigInteger primeExpP, BigInteger primeExpQ, BigInteger crtCoeff) {
        super(ALG, pkey);
        this.mod = mod;
        this.e = e;
        this.d = d;
        this.p = p;
        this.q = q;
        this.primeExpP = primeExpP;
        this.primeExpQ = primeExpQ;
        this.crtCoeff = crtCoeff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JceRsaPrivateKey(Pkey pkey) throws InvalidKeyException {
        super(ALG, pkey);
        byte[][] vals = this.pkey.getRsaKeyData();
        try {
            for (byte[] val : vals) {
                if (val != null) continue;
                throw new InvalidKeyException("Invalid RSA key value.");
            }
            this.mod = new BigInteger(1, vals[0]);
            this.e = new BigInteger(1, vals[1]);
            this.d = new BigInteger(1, vals[2]);
            this.p = new BigInteger(1, vals[3]);
            this.q = new BigInteger(1, vals[4]);
            this.primeExpP = new BigInteger(1, vals[5]);
            this.primeExpQ = new BigInteger(1, vals[6]);
            this.crtCoeff = new BigInteger(1, vals[7]);
        }
        finally {
            Util.clearArrays(vals);
        }
    }

    @Override
    public BigInteger getModulus() {
        return this.mod;
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.e;
    }

    @Override
    public BigInteger getPrivateExponent() {
        return this.d;
    }

    @Override
    public BigInteger getPrimeP() {
        return this.p;
    }

    @Override
    public BigInteger getPrimeQ() {
        return this.q;
    }

    @Override
    public BigInteger getPrimeExponentP() {
        return this.primeExpP;
    }

    @Override
    public BigInteger getPrimeExponentQ() {
        return this.primeExpQ;
    }

    @Override
    public BigInteger getCrtCoefficient() {
        return this.crtCoeff;
    }

    @Override
    public void destroy() {
        this.pkey.free();
    }

    @Override
    byte[] derEncode() {
        Asn1BerValue rsaPrivKey = Asn1.newSequence(Asn1.newInteger(0L), Asn1.newSequence(ID_RSA_ENCRYPTION, Asn1.newNull()), Asn1.newOctetString(Asn1.newSequence(Asn1.newInteger(0L), Asn1.newInteger(this.mod), Asn1.newInteger(this.e), Asn1.newInteger(this.d), Asn1.newInteger(this.p), Asn1.newInteger(this.q), Asn1.newInteger(this.primeExpP), Asn1.newInteger(this.primeExpQ), Asn1.newInteger(this.crtCoeff)).encodeDer()));
        return rsaPrivKey.encodeDerOctets();
    }
}

